/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZGroupEvent;
import edu.umd.cs.jazz.event.ZGroupListener;
import edu.umd.cs.jazz.event.ZNodeListener;
import edu.umd.cs.jazz.io.ZObjectOutputStream;
import edu.umd.cs.jazz.io.ZSerializable;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZFindFilter;
import edu.umd.cs.jazz.util.ZList;
import edu.umd.cs.jazz.util.ZListImpl;
import edu.umd.cs.jazz.util.ZRenderContext;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import edu.umd.cs.jazz.util.ZTooManyChildrenException;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ZGroup
extends ZNode
implements ZSerializable,
Serializable {
    public static final boolean childrenPickable_DEFAULT = true;
    public static final boolean childrenFindable_DEFAULT = true;
    public static final boolean hasOneChild_DEFAULT = false;
    protected ZList.ZNodeList children = ZListImpl.NullList;
    protected transient boolean childrenVolatileBoundsCache = false;
    private boolean childrenPickable = true;
    private boolean childrenFindable = true;
    private boolean hasOneChild = false;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZNodeListener;
    static /* synthetic */ Class class$edu$umd$cs$jazz$event$ZGroupListener;

    public ZGroup() {
    }

    public ZGroup(ZNode child) {
        this();
        this.insertAbove(child);
    }

    protected Object duplicateObject() {
        ZGroup newGroup = (ZGroup)super.duplicateObject();
        if (!this.children.isNull()) {
            newGroup.children = new ZListImpl.ZNodeListImpl(this.children.size());
            ZNode[] childrenRef = this.getChildrenReference();
            int i = 0;
            while (i < this.children.size()) {
                ZNode newChild = (ZNode)childrenRef[i].clone();
                newGroup.children.add(newChild);
                newChild.parent = newGroup;
                ++i;
            }
        }
        return newGroup;
    }

    public void trimToSize() {
        super.trimToSize();
        this.children.trimToSize();
    }

    public void insertAbove(ZNode child) {
        if (this.parent != null) {
            this.parent.removeChild(this, false);
        }
        ZGroup prevParent = this.parent;
        ZGroup p = child.getParent();
        if (p != null) {
            p.children.replaceWith(child, this);
            child.parent = null;
            this.parent = p;
        }
        if (this.inTransaction != child.inTransaction && child.inTransaction) {
            this.markInTransaction();
        }
        this.addChildImpl(child, false);
        if (prevParent != null && p == null) {
            prevParent.childRemovedNotification(this, false);
        } else if (prevParent != null) {
            prevParent.childRemovedNotification(this, true);
        }
        if (p != null) {
            p.childRemovedNotification(child, true);
            if (prevParent == null) {
                p.childAddedNotification(this, false);
            } else {
                p.childAddedNotification(this, true);
            }
            this.childAddedNotification(child, true);
        } else {
            this.childAddedNotification(child, false);
        }
        this.reshape();
    }

    public void extract() {
        ZGroup origParent = this.parent;
        ZNode beforeNode = null;
        if (this.parent != null) {
            int numChildren = this.parent.getNumChildren();
            ZNode[] parentChildren = this.parent.getChildrenReference();
            int i = 0;
            while (i < numChildren) {
                if (this == parentChildren[i]) {
                    if (i >= numChildren - 1) break;
                    beforeNode = parentChildren[i + 1];
                    break;
                }
                ++i;
            }
            this.parent.removeChild(this, false);
        }
        int prevNumChildren = this.children.size();
        ZNode firstChild = null;
        if (prevNumChildren > 0) {
            firstChild = (ZNode)this.children.get(0);
        }
        while (this.children.size() > 0) {
            ZNode child = this.getChild(0);
            if (origParent != null) {
                origParent.addChildImpl(child, false);
                if (beforeNode == null) {
                    origParent.raise(child);
                    continue;
                }
                origParent.lowerTo(child, beforeNode);
                continue;
            }
            this.removeChild(child, true);
        }
        if (origParent != null) {
            origParent.childRemovedNotification(this, false);
            if (prevNumChildren > 0) {
                int index = origParent.indexOf(firstChild);
                int i = 0;
                while (i < prevNumChildren) {
                    this.childRemovedNotification(origParent.getChild(index + i), true);
                    ++i;
                }
                int i2 = 0;
                while (i2 < prevNumChildren) {
                    origParent.childAddedNotification(origParent.getChild(index + i2), true);
                    ++i2;
                }
            }
        }
    }

    public void addChild(ZNode child) {
        this.addChildImpl(child, true);
    }

    protected void addChildImpl(ZNode child, boolean fireEvent) {
        if (this.hasOneChild() && this.children.size() >= 1) {
            throw new ZTooManyChildrenException(this, "Can't have more than one child when hasOneChild flag set");
        }
        if (child.parent != null) {
            child.parent.removeChild(child, fireEvent);
        }
        if (this.children.isNull()) {
            this.children = new ZListImpl.ZNodeListImpl(1);
        }
        this.children.add(child);
        child.parent = this;
        this.updateVolatility();
        if (!this.hasNodeListener && child.hasNodeListener) {
            this.updateHasNodeListener();
        }
        if (this.inTransaction != child.inTransaction) {
            if (this.inTransaction) {
                child.markInTransaction();
            } else {
                child.markNotInTransaction();
            }
        }
        this.updateBounds();
        child.repaint();
        if (fireEvent) {
            this.childAddedNotification(child, false);
        }
    }

    public void addChildren(Collection newChildren) {
        this.addChildren(newChildren, true);
    }

    public void addChildren(Collection newChildren, boolean fireGroupEvents) {
        if (this.hasOneChild() && this.children.size() >= 1) {
            throw new ZTooManyChildrenException(this, "Can't have more than one child when hasOneChild flag set");
        }
        if (this.children.isNull()) {
            this.children = new ZListImpl.ZNodeListImpl(1);
        }
        Iterator i = newChildren.iterator();
        while (i.hasNext()) {
            ZNode child = (ZNode)i.next();
            if (child.parent != null) {
                child.parent.removeChild(child, fireGroupEvents);
            }
            this.children.add(child);
            if (this.inTransaction != child.inTransaction) {
                if (this.inTransaction) {
                    child.markInTransaction();
                } else {
                    child.markNotInTransaction();
                }
            }
            child.parent = this;
            if (!fireGroupEvents) continue;
            this.childAddedNotification(child, false);
        }
        this.updateVolatility();
        this.updateHasNodeListener();
        this.updateBounds();
        this.repaint();
    }

    public void removeAllChildren() {
        this.removeAllChildren(true);
    }

    public void removeAllChildren(boolean fireGroupEvents) {
        int numChildren = this.getNumChildren();
        if (numChildren == 0) {
            return;
        }
        ZNode[] childrenNodes = this.getChildrenReference();
        int i = 0;
        while (i < numChildren) {
            childrenNodes[i].parent = null;
            if (fireGroupEvents) {
                this.childRemovedNotification(childrenNodes[i], false);
            }
            ++i;
        }
        this.children = ZListImpl.NullList;
        this.repaint();
        this.updateHasNodeListener();
        this.updateVolatility();
        this.updateBounds();
    }

    public void removeChild(int index) {
        this.removeChildImpl(index, true);
    }

    protected void removeChild(ZNode child, boolean fireEvent) {
        int index = this.children.indexOf(child);
        if (index == -1) {
            return;
        }
        this.removeChildImpl(index, fireEvent);
    }

    public void removeChild(ZNode child) {
        this.removeChild(child, true);
    }

    protected void removeChildImpl(int index, boolean fireEvent) {
        ZNode removedChild = (ZNode)this.children.remove(index);
        if (removedChild == null) {
            return;
        }
        removedChild.repaint();
        removedChild.parent = null;
        this.updateVolatility();
        if (removedChild.hasNodeListener()) {
            this.updateHasNodeListener();
        }
        this.updateBounds();
        if (this.children.size() == 0) {
            this.children = ZListImpl.NullList;
        }
        if (fireEvent) {
            this.childRemovedNotification(removedChild, false);
        }
    }

    public int indexOf(ZNode child) {
        return this.children.indexOf(child);
    }

    public ZNode[] getChildren() {
        if (this.children.isNull()) {
            return new ZNode[0];
        }
        ZNode[] childrenRef = this.getChildrenReference();
        ZNode[] copyChildren = new ZNode[this.children.size()];
        System.arraycopy(childrenRef, 0, copyChildren, 0, this.children.size());
        return copyChildren;
    }

    public Iterator getChildrenIterator() {
        return this.children.iterator();
    }

    public Iterator iterator() {
        return this.children.iterator();
    }

    public ZNode getChild(int i) {
        return this.getChildrenReference()[i];
    }

    public ZNode[] getChildrenReference() {
        return this.children.getNodesReference();
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public void raise(ZNode child) {
        this.children.moveElementToIndex(child, this.children.size() - 1);
        child.repaint();
    }

    public void raiseTo(ZNode child, ZNode afterNode) {
        if (afterNode == null) {
            this.raise(child);
            return;
        }
        int childIndex = -1;
        int afterIndex = -1;
        ZNode[] childrenRef = this.children.getNodesReference();
        int i = 0;
        while (i < this.children.size()) {
            if (child == childrenRef[i]) {
                childIndex = i;
            }
            if (afterNode == childrenRef[i]) {
                afterIndex = i;
            }
            if (childIndex >= 0 && afterIndex >= 0) break;
            ++i;
        }
        if (childIndex >= 0 && afterIndex >= 0) {
            if (childIndex < afterIndex) {
                i = childIndex;
                while (i < afterIndex) {
                    childrenRef[i] = childrenRef[i + 1];
                    ++i;
                }
                childrenRef[afterIndex] = child;
            } else {
                i = childIndex;
                while (i > afterIndex + 1) {
                    childrenRef[i] = childrenRef[i - 1];
                    --i;
                }
                childrenRef[afterIndex + 1] = child;
            }
        }
        child.repaint();
    }

    public void lower(ZNode child) {
        this.children.moveElementToIndex(child, 0);
        child.repaint();
    }

    public void lowerTo(ZNode child, ZNode beforeNode) {
        if (beforeNode == null) {
            this.lower(child);
            return;
        }
        int childIndex = -1;
        int beforeIndex = -1;
        ZNode[] childrenRef = this.children.getNodesReference();
        int i = 0;
        while (i < this.children.size()) {
            if (child == childrenRef[i]) {
                childIndex = i;
            }
            if (beforeNode == childrenRef[i]) {
                beforeIndex = i;
            }
            if (childIndex >= 0 && beforeIndex >= 0) break;
            ++i;
        }
        if (childIndex >= 0 && beforeIndex >= 0) {
            if (childIndex < beforeIndex) {
                i = childIndex;
                while (i < beforeIndex - 1) {
                    childrenRef[i] = childrenRef[i + 1];
                    ++i;
                }
                childrenRef[beforeIndex - 1] = child;
            } else {
                i = childIndex;
                while (i > beforeIndex) {
                    childrenRef[i] = childrenRef[i - 1];
                    --i;
                }
                childrenRef[beforeIndex] = child;
            }
        }
        child.repaint();
    }

    public boolean getVolatileBounds() {
        return super.getVolatileBounds() || this.childrenVolatileBoundsCache;
    }

    protected void computeVolatileBounds() {
        this.childrenVolatileBoundsCache = !this.children.isNull() ? this.children.collectiveHasVolatileBounds() : false;
    }

    public void setChildrenPickable(boolean childrenPickable) {
        this.childrenPickable = childrenPickable;
    }

    public final boolean getChildrenPickable() {
        return this.childrenPickable;
    }

    public void setChildrenFindable(boolean childrenFindable) {
        this.childrenFindable = childrenFindable;
    }

    public final boolean getChildrenFindable() {
        return this.childrenFindable;
    }

    public void setHasOneChild(boolean oneChild) {
        if (oneChild && this.children.size() > 1) {
            throw new ZTooManyChildrenException(this, "Can't have more than one child when hasOneChild flag set");
        }
        this.hasOneChild = oneChild;
    }

    public final boolean hasOneChild() {
        return this.hasOneChild;
    }

    public void render(ZRenderContext renderContext) {
        if (this.children.size() == 0) {
            return;
        }
        this.children.collectiveRender(renderContext, renderContext.getVisibleBounds());
    }

    protected void computeBounds() {
        this.bounds.reset();
        this.bounds = this.children.collectiveBoundsReference(this.bounds);
    }

    public ZBounds getShallowBounds() {
        return new ZBounds();
    }

    protected void markInTransaction() {
        super.markInTransaction();
        ZNode[] childrenNodes = this.children.getNodesReference();
        int i = 0;
        while (i < this.children.size()) {
            childrenNodes[i].markInTransaction();
            ++i;
        }
    }

    protected void markNotInTransaction() {
        super.markNotInTransaction();
        ZNode[] childrenNodes = this.children.getNodesReference();
        int i = 0;
        while (i < this.children.size()) {
            childrenNodes[i].markNotInTransaction();
            ++i;
        }
    }

    public void removeNodeListener(ZNodeListener l) {
        super.removeNodeListener(l);
        this.updateHasNodeListener();
    }

    public void updateHasNodeListener() {
        boolean hadListener = this.hasNodeListener;
        this.hasNodeListener = false;
        if (this.listenerList != null && this.listenerList.getListenerCount(class$edu$umd$cs$jazz$event$ZNodeListener == null ? (class$edu$umd$cs$jazz$event$ZNodeListener = ZGroup.class$("edu.umd.cs.jazz.event.ZNodeListener")) : class$edu$umd$cs$jazz$event$ZNodeListener) > 0) {
            this.hasNodeListener = true;
        } else {
            int i = 0;
            while (i < this.children.size()) {
                if (((ZNode)this.children.get(i)).hasNodeListener()) {
                    this.hasNodeListener = true;
                    break;
                }
                ++i;
            }
        }
        if (this.parent != null && this.hasNodeListener != hadListener) {
            this.parent.updateHasNodeListener();
        }
    }

    public void addGroupListener(ZGroupListener l) {
        this.getListenerList().add(class$edu$umd$cs$jazz$event$ZGroupListener == null ? (class$edu$umd$cs$jazz$event$ZGroupListener = ZGroup.class$("edu.umd.cs.jazz.event.ZGroupListener")) : class$edu$umd$cs$jazz$event$ZGroupListener, l);
    }

    public void removeGroupListener(ZGroupListener l) {
        this.removeEventListener(class$edu$umd$cs$jazz$event$ZGroupListener == null ? (class$edu$umd$cs$jazz$event$ZGroupListener = ZGroup.class$("edu.umd.cs.jazz.event.ZGroupListener")) : class$edu$umd$cs$jazz$event$ZGroupListener, l);
    }

    public void childAddedNotification(ZNode child, boolean isModification) {
        ZGroupEvent e = null;
        ZGroup node = this;
        while (e == null || !e.isConsumed()) {
            if (node instanceof ZGroup) {
                if (e == null && node.hasListenerOfType(class$edu$umd$cs$jazz$event$ZGroupListener == null ? ZGroup.class$("edu.umd.cs.jazz.event.ZGroupListener") : class$edu$umd$cs$jazz$event$ZGroupListener)) {
                    e = ZGroupEvent.createNodeAddedEvent(this, child, isModification);
                }
                if (e != null) {
                    node.fireEvent(e);
                }
            }
            if ((node = node.getParent()) != null) continue;
        }
    }

    public void childRemovedNotification(ZNode child, boolean isModification) {
        ZGroupEvent e = null;
        ZGroup node = this;
        while (e == null || !e.isConsumed()) {
            if (node instanceof ZGroup) {
                if (e == null && node.hasListenerOfType(class$edu$umd$cs$jazz$event$ZGroupListener == null ? ZGroup.class$("edu.umd.cs.jazz.event.ZGroupListener") : class$edu$umd$cs$jazz$event$ZGroupListener)) {
                    e = ZGroupEvent.createNodeRemovedEvent(this, child, isModification);
                }
                if (e != null) {
                    node.fireEvent(e);
                }
            }
            if ((node = node.getParent()) != null) continue;
        }
    }

    public boolean pick(Rectangle2D rect, ZSceneGraphPath path) {
        if (this.isPickable()) {
            path.push(this);
            ZSceneGraphObject picked = this.children.collectivePick(rect, path);
            if (picked != null) {
                if (!this.getChildrenPickable()) {
                    path.pop(this);
                    path.setObject(this);
                }
                return true;
            }
            path.pop(this);
        }
        return false;
    }

    protected int findNodes(ZFindFilter filter, ArrayList nodes) {
        int nodesSearched = 1;
        if (this.isFindable()) {
            if (filter.accept(this)) {
                nodes.add(this);
            }
            if (this.getChildrenFindable() && filter.childrenFindable(this)) {
                ZNode[] childrenRef = this.getChildrenReference();
                int i = 0;
                while (i < this.children.size()) {
                    nodesSearched += childrenRef[i].findNodes(filter, nodes);
                    ++i;
                }
            }
        }
        return nodesSearched;
    }

    public String dump() {
        String str = super.dump();
        if (this.hasOneChild()) {
            str = str + "\n HasOneChild";
        }
        return str;
    }

    public void writeObject(ZObjectOutputStream out) throws IOException {
        super.writeObject(out);
        this.children.writeObject("children", out);
        if (!this.childrenPickable) {
            out.writeState("boolean", "childrenPickable", this.childrenPickable);
        }
        if (!this.childrenFindable) {
            out.writeState("boolean", "childrenFindable", this.childrenFindable);
        }
        if (this.hasOneChild) {
            out.writeState("boolean", "hasOneChild", this.hasOneChild);
        }
    }

    public void writeObjectRecurse(ZObjectOutputStream out) throws IOException {
        super.writeObjectRecurse(out);
        ZNode[] childrenRef = this.children.getNodesReference();
        int i = 0;
        while (i < this.children.size()) {
            out.addObject(childrenRef[i]);
            ++i;
        }
    }

    public void setState(String fieldType, String fieldName, Object fieldValue) {
        super.setState(fieldType, fieldName, fieldValue);
        if (fieldName.compareTo("children") == 0) {
            this.addChildren((Vector)fieldValue, false);
        } else if (fieldName.compareTo("childrenPickable") == 0) {
            this.setChildrenPickable((Boolean)fieldValue);
        } else if (fieldName.compareTo("childrenFindable") == 0) {
            this.setChildrenFindable((Boolean)fieldValue);
        } else if (fieldName.compareTo("hasOneChild") == 0) {
            this.setHasOneChild((Boolean)fieldValue);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.trimToSize();
        out.defaultWriteObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        childrenPickable_DEFAULT = true;
        childrenFindable_DEFAULT = true;
        hasOneChild_DEFAULT = false;
    }
}

