/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.jazz;

import edu.umd.cs.jazz.ZLocator;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.util.ZBounds;
import java.awt.geom.RectangularShape;

public class ZBoundsLocator
extends ZLocator {
    private double fOffset;
    private int fSide;

    protected ZBoundsLocator(ZSceneGraphObject aSceneGraphObject, int aSide) {
        super(aSceneGraphObject);
        this.fSide = aSide;
    }

    public double getX() {
        ZBounds aBounds = this.getSceneGraphObject().getBoundsReference();
        switch (this.fSide) {
            case 6: 
            case 7: 
            case 8: {
                return ((RectangularShape)aBounds).getX();
            }
            case 2: 
            case 3: 
            case 4: {
                return ((RectangularShape)aBounds).getX() + ((RectangularShape)aBounds).getWidth();
            }
            case 1: 
            case 5: {
                return ((RectangularShape)aBounds).getX() + ((RectangularShape)aBounds).getWidth() / 2.0;
            }
        }
        return -1.0;
    }

    public double getY() {
        ZBounds aBounds = this.getSceneGraphObject().getBoundsReference();
        switch (this.fSide) {
            case 3: 
            case 7: {
                return ((RectangularShape)aBounds).getY() + ((RectangularShape)aBounds).getHeight() / 2.0;
            }
            case 4: 
            case 5: 
            case 6: {
                return ((RectangularShape)aBounds).getY() + ((RectangularShape)aBounds).getHeight();
            }
            case 1: 
            case 2: 
            case 8: {
                return ((RectangularShape)aBounds).getY();
            }
        }
        return -1.0;
    }

    public static ZBoundsLocator createEastLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 3);
    }

    public static ZBoundsLocator createNorthEastLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 2);
    }

    public static ZBoundsLocator createNorthWestLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 8);
    }

    public static ZBoundsLocator createNorthLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 1);
    }

    public static ZBoundsLocator createSouthLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 5);
    }

    public static ZBoundsLocator createWestLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 7);
    }

    public static ZBoundsLocator createSouthWestLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 6);
    }

    public static ZBoundsLocator createSouthEastLocator(ZSceneGraphObject aSceneGraphObject) {
        return new ZBoundsLocator(aSceneGraphObject, 4);
    }
}

