/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZGridLayoutManager;
import edu.umd.cs.jazz.ZLayoutGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.util.ZCanvas;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SelectionPane
extends JPanel {
    static final int SELECTION_THUMB_WIDTH = 100;
    static final int SELECTION_THUMB_SPACE = 10;
    static final int SELECTION_COLUMNS = 2;
    PhotoMesa photomesa;
    ZCanvas detail;
    ZCanvas selection;
    ZLayoutGroup layoutGroup;

    public SelectionPane(PhotoMesa photoMesa) {
        this.photomesa = photoMesa;
        this.detail = new ZCanvas();
        this.selection = new ZCanvas();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.detail.setNavEventHandlersActive(false);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Detail");
        jPanel2.setBorder(titledBorder);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.detail, "Center");
        this.add(jPanel2);
        this.layoutGroup = new ZLayoutGroup();
        this.layoutGroup.setLayoutManager(new ZGridLayoutManager(1, 2, 100.0, 66.66666666666667, 10.0, 10.0));
        this.selection.getLayer().addChild(this.layoutGroup);
        this.selection.setNavEventHandlersActive(false);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder("Selection");
        jPanel.setBorder(titledBorder2);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.selection, "Center");
        this.add(jPanel);
        this.selection.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (SelectionPane.this.photomesa.tabbedPane.getSelectedComponent() == SelectionPane.this && SelectionPane.this.selection.getLayer().getNumChildren() > 0) {
                    SelectionPane.this.selection.getCamera().center(SelectionPane.this.selection.getLayer().getBounds(), 0, SelectionPane.this.selection.getDrawingSurface());
                    SelectionPane.this.detail.getCamera().center(SelectionPane.this.detail.getLayer().getBounds(), 0, SelectionPane.this.detail.getDrawingSurface());
                }
            }
        });
    }

    void clearSelection() {
        this.layoutGroup.removeAllChildren();
    }

    void addToSelection(final ImageItem imageItem) {
        int n = PhotoMesa.THUMB_WIDTHS.length - 1;
        String string = imageItem.getThumbPath(n);
        File file = new File(string);
        if (file.exists()) {
            Image image = Toolkit.getDefaultToolkit().createImage(string);
            PMImage pMImage = new PMImage(image, imageItem, n);
            pMImage.setPenColor(imageItem.getThumb().getPenColor());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
                ZVisualLeaf zVisualLeaf = new ZVisualLeaf(pMImage);
                zVisualLeaf.editor().getTransformGroup();
                this.layoutGroup.addChild(zVisualLeaf.editor().getTop());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.layoutGroup.validate();
        if (imageItem.isSelected()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (SelectionPane.this.isVisible()) {
                        PMImage pMImage = imageItem.getHiResImage();
                        ZVisualLeaf zVisualLeaf = new ZVisualLeaf(pMImage);
                        SelectionPane.this.detail.getLayer().removeAllChildren();
                        SelectionPane.this.detail.getLayer().addChild(zVisualLeaf);
                        SelectionPane.this.detail.getCamera().center(SelectionPane.this.detail.getLayer().getBounds(), 0, SelectionPane.this.detail.getDrawingSurface());
                    }
                }
            });
        }
        if (this.photomesa.tabbedPane.getSelectedComponent() == this && this.selection.getLayer().getNumChildren() > 0) {
            this.selection.getCamera().center(this.selection.getLayer().getBounds(), 0, this.selection.getDrawingSurface());
        }
    }

    void removeFromSelection(ImageItem imageItem) {
        ZNode[] zNodeArray = this.layoutGroup.getChildren();
        int n = 0;
        while (n < zNodeArray.length) {
            ZVisualLeaf zVisualLeaf = (ZVisualLeaf)zNodeArray[n].editor().getNode();
            PMImage pMImage = (PMImage)zVisualLeaf.getFirstVisualComponent();
            if (pMImage.getImageItem() == imageItem) {
                this.layoutGroup.removeChild(zNodeArray[n].editor().getTop());
                break;
            }
            ++n;
        }
        this.layoutGroup.validate();
        if (this.photomesa.tabbedPane.getSelectedComponent() == this && this.selection.getLayer().getNumChildren() > 0) {
            this.selection.getCamera().center(this.selection.getLayer().getBounds(), 0, this.selection.getDrawingSurface());
            this.detail.getCamera().center(this.detail.getLayer().getBounds(), 0, this.detail.getDrawingSurface());
        }
    }
}

