/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZCamera;
import edu.umd.cs.jazz.ZDrawingSurface;
import edu.umd.cs.jazz.ZGroup;
import edu.umd.cs.jazz.ZLayerGroup;
import edu.umd.cs.jazz.ZNode;
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.ZTransformGroup;
import edu.umd.cs.jazz.ZVisualLeaf;
import edu.umd.cs.jazz.component.ZPolyline;
import edu.umd.cs.jazz.component.ZRectangle;
import edu.umd.cs.jazz.component.ZShape;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZBoundsFindFilter;
import edu.umd.cs.jazz.util.ZCanvas;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ImagePane
extends ZCanvas {
    Color hilitePen = PhotoMesa.HILITE_PEN_COLOR;
    Color hiliteFill = PhotoMesa.HILITE_FILL_COLOR;
    Color hiliteSelectionFill = new Color(0.0f, 0.0f, 0.0f, 0.3f);
    Color hiliteSelectionPen = PhotoMesa.SELECTION_COLOR;
    Color marqueePen = Color.black;
    Color marqueeFill = null;
    PhotoMesa photomesa;
    MarqueeRectangle marqueeRect;
    ZVisualLeaf marqueeLeaf;
    ZRectangle hiliteRect;
    ZPolyline hilite1;
    ZPolyline hilite2;
    ZPolyline hilite3;
    ZPolyline hilite4;
    boolean hiliteEmpty = true;
    boolean singleImageHilite = false;
    boolean hiresImageLoaded = false;
    int hiresImageRow;
    int hiresImageCol;
    ImageItem hiresImageItem = null;
    ImageItem singleImageItem = null;
    Timer fadeTimer = null;
    Timer previewTimer = null;
    ActionListener fadeTask = null;
    ActionListener previewTask = null;
    Point2D pressScreenPt = new Point2D.Double();
    Point2D pressPt = new Point2D.Double();
    Vector cameraMags;
    Vector history;
    int historyIndex = 0;
    Vector selection;
    ZLayerGroup hiliteLayer;
    ZLayerGroup topLayer;
    ZLayerGroup bottomLayer;
    Hashtable regionTable;
    Region currentRegion = null;
    Region armedRegion = null;
    boolean isHiliteOn = false;
    boolean isFadingHilite = false;
    boolean isPreviewOn = false;
    boolean isGrowingPreview = false;
    long fadeStartTime;
    long previewStartTime;
    Vector fadeNodes = null;
    ZNode previewNode = null;
    double previewStartScale = 0.0;
    EventHandlers eventHandlers = null;
    ZSceneGraphObject pressObj = null;
    ZCamera activeCamera = this.getCanvasCamera();
    int numFramesRendered = 0;
    EventHandlers orgEventHandlers;
    boolean interruptableZoom = false;
    String currentPreviewThumbPath = null;

    public ImagePane(PhotoMesa photoMesa) {
        ZCamera zCamera = this.getCamera();
        this.cameraMags = new Vector();
        this.history = new Vector();
        this.selection = new Vector();
        this.fadeNodes = new Vector();
        this.regionTable = new Hashtable();
        this.photomesa = photoMesa;
        this.bottomLayer = new ZLayerGroup();
        this.getRoot().addChild(this.bottomLayer);
        zCamera.addLayer(this.bottomLayer);
        this.hiliteLayer = new ZLayerGroup();
        this.getRoot().addChild(this.hiliteLayer);
        ZLayerGroup zLayerGroup = this.getLayer();
        zCamera.removeLayer(zLayerGroup);
        zCamera.addLayer(zLayerGroup);
        zCamera.addLayer(this.hiliteLayer);
        this.topLayer = new ZLayerGroup();
        this.getRoot().addChild(this.topLayer);
        zCamera.addLayer(this.topLayer);
        this.createHilite();
        this.marqueeRect = new MarqueeRectangle();
        this.marqueeRect.setPenPaint(this.marqueePen);
        this.marqueeRect.setFillPaint(this.marqueeFill);
        this.marqueeRect.setPenWidth(0.0);
        this.marqueeLeaf = new ZVisualLeaf(this.marqueeRect);
        this.marqueeLeaf.setFindable(false);
        this.marqueeLeaf.setPickable(false);
        this.topLayer.addChild(this.marqueeLeaf);
        this.setNavEventHandlersActive(false);
        this.eventHandlers = new EventHandlers(this, this);
        this.eventHandlers.activateEventHandlers();
        this.orgEventHandlers = this.eventHandlers;
    }

    void setFullScreenEventHandlers(EventHandlers eventHandlers) {
        this.eventHandlers = eventHandlers;
    }

    void resetEventHandlers() {
        this.eventHandlers = this.orgEventHandlers;
    }

    void setActiveCamera(ZCamera zCamera) {
        this.activeCamera = zCamera;
    }

    public ZCamera getCamera() {
        return this.activeCamera;
    }

    public ZCamera getCanvasCamera() {
        return super.getCamera();
    }

    void clear(boolean bl) {
        this.stopPreview();
        this.clearSelection();
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.removing = bl;
            region.clear();
        }
        this.topLayer.removeAllChildren();
        if (this.hiresImageLoaded) {
            this.hiresImageItem.unloadHiResImage();
            this.hiresImageItem = null;
            this.hiresImageLoaded = false;
        }
        this.regionTable.clear();
        this.cameraMags.clear();
        this.history.clear();
        this.historyIndex = 0;
        this.getLayer().removeAllChildren();
        this.bottomLayer.removeAllChildren();
        this.armedRegion = null;
        this.setCurrentRegion(null);
        this.stopHiliteFade();
        this.setHiliteBounds(0.0, 0.0, 0.0, 0.0);
    }

    void createHilite() {
        this.hilite1 = new ZPolyline();
        this.hilite1.setPenPaint(this.hilitePen);
        this.hilite1.setFillPaint(this.hiliteFill);
        this.hilite2 = new ZPolyline();
        this.hilite2.setPenPaint(this.hilitePen);
        this.hilite2.setFillPaint(this.hiliteFill);
        this.hilite3 = new ZPolyline();
        this.hilite3.setPenPaint(this.hilitePen);
        this.hilite3.setFillPaint(this.hiliteFill);
        this.hilite4 = new ZPolyline();
        this.hilite4.setPenPaint(this.hilitePen);
        this.hilite4.setFillPaint(this.hiliteFill);
        this.hiliteRect = new ZRectangle();
        this.hiliteRect.setPenPaint(this.hilitePen);
        this.hiliteRect.setFillPaint(this.hiliteFill);
        ZVisualLeaf zVisualLeaf = new ZVisualLeaf();
        zVisualLeaf.addVisualComponent(this.hilite1);
        zVisualLeaf.addVisualComponent(this.hilite2);
        zVisualLeaf.addVisualComponent(this.hilite3);
        zVisualLeaf.addVisualComponent(this.hilite4);
        zVisualLeaf.addVisualComponent(this.hiliteRect);
        zVisualLeaf.setFindable(false);
        zVisualLeaf.setPickable(false);
        this.hiliteLayer.addChild(zVisualLeaf);
        this.fadeNodes.add(zVisualLeaf);
    }

    void setHilitePenWidth(double d) {
        this.hilite1.setPenWidth(d);
        this.hilite2.setPenWidth(d);
        this.hilite3.setPenWidth(d);
        this.hilite4.setPenWidth(d);
        this.hiliteRect.setPenWidth(d / 2.0);
    }

    void setHilitePen(Color color) {
        this.hilite1.setPenPaint(color);
        this.hilite2.setPenPaint(color);
        this.hilite3.setPenPaint(color);
        this.hilite4.setPenPaint(color);
        this.hiliteRect.setPenPaint(color);
    }

    void setHiliteFill(Color color) {
        this.hilite1.setFillPaint(color);
        this.hilite2.setFillPaint(color);
        this.hilite3.setFillPaint(color);
        this.hilite4.setFillPaint(color);
        this.hiliteRect.setFillPaint(color);
    }

    void setHiliteBounds(ZBounds zBounds) {
        this.setHiliteBounds(zBounds.getX(), zBounds.getY(), zBounds.getWidth(), zBounds.getHeight());
    }

    void setHiliteBounds(double d, double d2, double d3, double d4) {
        int n = (int)Math.min(d3 * 0.4, (double)PhotoMesa.THUMB_WIDTHS[0] * 0.5);
        int n2 = (int)Math.min(d4 * 0.4, (double)n / this.photomesa.state.getAspectRatio());
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        ((Point2D)double_).setLocation(d, d2 + (double)n2);
        ((Point2D)double_2).setLocation(d, d2);
        this.hilite1.setCoords(double_, double_2);
        ((Point2D)double_2).setLocation(d + (double)n, d2);
        this.hilite1.add(double_2);
        ((Point2D)double_).setLocation(d + d3 - (double)n, d2);
        ((Point2D)double_2).setLocation(d + d3, d2);
        this.hilite2.setCoords(double_, double_2);
        ((Point2D)double_2).setLocation(d + d3, d2 + (double)n2);
        this.hilite2.add(double_2);
        ((Point2D)double_).setLocation(d + d3, d2 + d4 - (double)n2);
        ((Point2D)double_2).setLocation(d + d3, d2 + d4);
        this.hilite3.setCoords(double_, double_2);
        ((Point2D)double_2).setLocation(d + d3 - (double)n, d2 + d4);
        this.hilite3.add(double_2);
        ((Point2D)double_).setLocation(d + (double)n, d2 + d4);
        ((Point2D)double_2).setLocation(d, d2 + d4);
        this.hilite4.setCoords(double_, double_2);
        ((Point2D)double_2).setLocation(d, d2 + d4 - (double)n2);
        this.hilite4.add(double_2);
        this.hiliteRect.setRect(d, d2, d3, d4);
        this.setHilitePenWidth(7.0 / this.getCamera().getMagnification());
    }

    ZBounds getHiliteBounds() {
        ZBounds zBounds = this.hilite1.getBounds();
        ZBounds zBounds2 = this.hilite2.getBounds();
        ZBounds zBounds3 = this.hilite3.getBounds();
        ZBounds zBounds4 = this.hilite4.getBounds();
        ZBounds zBounds5 = zBounds;
        zBounds5.add(zBounds2);
        zBounds5.add(zBounds3);
        zBounds5.add(zBounds4);
        return zBounds5;
    }

    Region getRegion(ZGroup zGroup) {
        return (Region)this.regionTable.get(zGroup);
    }

    Region findRegion(Point2D point2D) {
        Region region = null;
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Shape shape;
            Region region2 = (Region)iterator.next();
            ZShape zShape = region2.getBorder();
            if (zShape == null || !(shape = zShape.getShape()).contains(point2D)) continue;
            region = region2;
            break;
        }
        return region;
    }

    ZLayerGroup getBottomLayer() {
        return this.bottomLayer;
    }

    ZLayerGroup getTopLayer() {
        return this.topLayer;
    }

    int getSelectionSize() {
        return this.selection.size();
    }

    Vector getSelectionImageItems() {
        return (Vector)this.selection.clone();
    }

    void beginSelectionByDragging() {
        if (this.topLayer.indexOf(this.marqueeLeaf) < 0) {
            this.topLayer.addChild(this.marqueeLeaf);
        }
        this.marqueeRect.setDrawing();
        this.marqueeRect.setRect(new ZBounds());
    }

    void updateSelectionByDragging(ZBounds zBounds) {
        this.marqueeRect.setRect(zBounds);
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            Vector vector = region.getImageItems();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                ImageItem imageItem = (ImageItem)iterator2.next();
                ZBounds zBounds2 = imageItem.getThumb().getGlobalBounds();
                if (zBounds.intersects(zBounds2)) {
                    imageItem.setSelected(true);
                    continue;
                }
                imageItem.setSelected(false);
            }
        }
    }

    void endSelectionByDragging() {
        this.marqueeRect.unsetDrawing();
    }

    void clearSelection() {
        Vector vector = (Vector)this.selection.clone();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ImageItem imageItem = (ImageItem)iterator.next();
            imageItem.setSelected(false);
        }
        this.selection.clear();
        if (this.photomesa.selectionPane != null) {
            this.photomesa.selectionPane.clearSelection();
        }
    }

    void addToSelection(ImageItem imageItem) {
        this.selection.add(imageItem);
        this.photomesa.selectionPane.addToSelection(imageItem);
    }

    void removeFromSelection(ImageItem imageItem) {
        this.selection.remove(imageItem);
        this.photomesa.selectionPane.removeFromSelection(imageItem);
    }

    void setPressObj(ZSceneGraphObject zSceneGraphObject) {
        this.pressObj = zSceneGraphObject;
    }

    ZSceneGraphObject getPressObj() {
        return this.pressObj;
    }

    boolean isDraggable() {
        boolean bl = !this.eventHandlers.isInteracting() && !this.isHiResImageLoaded();
        return bl;
    }

    ZBounds getImageItemsBounds(ZBounds zBounds) {
        ZCamera zCamera = this.getCamera();
        ZBoundsFindFilter zBoundsFindFilter = new ZBoundsFindFilter(zBounds);
        ZBounds zBounds2 = new ZBounds();
        ArrayList arrayList = zCamera.findNodes(zBoundsFindFilter);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ZVisualLeaf zVisualLeaf = (ZVisualLeaf)iterator.next();
            zBounds2.add(zVisualLeaf.getGlobalBounds());
        }
        return zBounds2;
    }

    ZGroup layoutImages(Region region, Point[] pointArray) {
        ZBounds zBounds;
        ImageItem imageItem;
        PMImage pMImage;
        ImageItem imageItem2;
        int n = this.photomesa.state.getImagePadding();
        Vector vector = region.getImageItems();
        ZGroup zGroup = new ZGroup();
        int n2 = PhotoMesa.THUMB_WIDTHS[0];
        int n3 = (int)((double)n2 / this.photomesa.state.getAspectRatio());
        double d = this.photomesa.state.getAspectRatio();
        int n4 = n2 + n;
        int n5 = n3 + n;
        Rectangle rectangle = new Rectangle(pointArray[0].x, pointArray[0].y, 0, 0);
        int n6 = 1;
        while (n6 < pointArray.length) {
            if (pointArray[n6].x < rectangle.x) {
                rectangle.width += rectangle.x - pointArray[n6].x;
                rectangle.x = pointArray[n6].x;
            }
            if (pointArray[n6].y < rectangle.y) {
                rectangle.height += rectangle.y - pointArray[n6].y;
                rectangle.y = pointArray[n6].y;
            }
            if (pointArray[n6].x > rectangle.x + rectangle.width) {
                rectangle.width = pointArray[n6].x - rectangle.x;
            }
            if (pointArray[n6].y > rectangle.y + rectangle.height) {
                rectangle.height = pointArray[n6].y - rectangle.y;
            }
            ++n6;
        }
        int n7 = rectangle.width + 1;
        int n8 = rectangle.height + 1;
        region.imageItemsGrid = new ImageItem[n8][n7];
        region.numRows = n8;
        region.numCols = n7;
        int n9 = 0;
        ZLayerGroup zLayerGroup = this.getLayer();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            imageItem2 = (ImageItem)iterator.next();
            Point point = pointArray[n9];
            imageItem2.setGridPosition(point.y - rectangle.y, point.x - rectangle.x);
            region.imageItemsGrid[point.y - rectangle.y][point.x - rectangle.x] = imageItem2;
            pMImage = imageItem2.getThumb();
            while (pMImage.getNumParents() > 0) {
                ((ZVisualLeaf)pMImage.getParents()[0]).removeVisualComponent(pMImage);
            }
            ++n9;
        }
        int n10 = 0;
        int n11 = 0;
        Iterator iterator2 = vector.iterator();
        while (iterator2.hasNext()) {
            imageItem = region.imageItemsGrid[n10][n11];
            if (imageItem != null) {
                imageItem2 = (ImageItem)iterator2.next();
                imageItem2.setGridPosition(n10, n11);
                region.imageItemsGrid[n10][n11] = imageItem2;
                pMImage = imageItem2.getThumb();
                ZVisualLeaf zVisualLeaf = new ZVisualLeaf(pMImage);
                zGroup.addChild(zVisualLeaf);
                int n12 = (int)pMImage.getBounds().getWidth();
                int n13 = (int)pMImage.getBounds().getHeight();
                if ((double)n12 / (double)n13 >= d) {
                    zVisualLeaf.editor().getTransformGroup().scale((double)n2 / (double)n12);
                } else {
                    zVisualLeaf.editor().getTransformGroup().scale((double)n3 / (double)n13);
                }
                zVisualLeaf.editor().getTransformGroup().position((Point2D)new Point2D.Double(0.5, 0.5), (Point2D)new Point2D.Double(0.5, 0.5), new ZBounds(n4 * (rectangle.x + n11), n5 * (rectangle.y + n10), n4, n5), 0, this.getDrawingSurface());
            }
            if (++n11 < n7 && iterator2.hasNext()) continue;
            n11 = 0;
            ++n10;
        }
        int[] nArray = new int[n8];
        int[] nArray2 = new int[n7];
        int[] nArray3 = new int[n8];
        int[] nArray4 = new int[n7];
        n10 = 0;
        while (n10 < n8) {
            n11 = 0;
            while (n11 < n7) {
                imageItem = region.imageItemsGrid[n10][n11];
                if (imageItem != null) {
                    int n14 = n10;
                    nArray[n14] = nArray[n14] + 1;
                    int n15 = n11;
                    nArray2[n15] = nArray2[n15] + 1;
                    zBounds = imageItem.getThumb().getGlobalBounds();
                    int n16 = n10;
                    nArray3[n16] = (int)((double)nArray3[n16] + zBounds.getCenterX());
                    int n17 = n11;
                    nArray4[n17] = (int)((double)nArray4[n17] + zBounds.getCenterY());
                }
                ++n11;
            }
            ++n10;
        }
        n10 = 0;
        while (n10 < n8) {
            if (nArray[n10] > 0) {
                int n18 = n10;
                nArray3[n18] = nArray3[n18] / nArray[n10];
            } else {
                nArray3[n10] = 0;
            }
            ++n10;
        }
        n11 = 0;
        while (n11 < n7) {
            if (nArray2[n11] > 0) {
                int n19 = n11;
                nArray4[n19] = nArray4[n19] / nArray2[n11];
            } else {
                nArray4[n11] = 0;
            }
            ++n11;
        }
        n10 = 0;
        while (n10 < n8) {
            n11 = 0;
            while (n11 < n7) {
                imageItem = region.imageItemsGrid[n10][n11];
                if (imageItem != null) {
                    double d2;
                    double d3 = 1.0 - 0.5 * this.photomesa.state.getGroupPadding();
                    if (nArray[n10] > 1) {
                        d3 = ((double)nArray[n10] - this.photomesa.state.getGroupPadding()) / (double)nArray[n10];
                    }
                    double d4 = 1.0 - 0.5 * this.photomesa.state.getGroupPadding();
                    if (nArray2[n11] > 1) {
                        d4 = ((double)nArray2[n11] - this.photomesa.state.getGroupPadding()) / (double)nArray2[n11];
                    }
                    imageItem.scale = d2 = Math.min(d3, d4);
                    zBounds = imageItem.getThumb().getGlobalBounds();
                    AffineTransform affineTransform = new AffineTransform();
                    double d5 = (1.0 - d3) * ((double)nArray3[n10] - zBounds.getCenterX());
                    double d6 = (1.0 - d4) * ((double)nArray4[n11] - zBounds.getCenterY());
                    affineTransform.translate(d5, d6);
                    affineTransform.translate(zBounds.getCenterX(), zBounds.getCenterY());
                    affineTransform.scale(d2, d2);
                    affineTransform.translate(-zBounds.getCenterX(), -zBounds.getCenterY());
                    ((ZVisualLeaf)imageItem.getThumb().getParents()[0]).editor().getTransformGroup().preConcatenate(affineTransform);
                }
                ++n11;
            }
            ++n10;
        }
        region.setGroup(zGroup);
        this.regionTable.put(zGroup, region);
        zLayerGroup.addChild(zGroup);
        return zGroup;
    }

    ZGroup layoutImages(Region region, int n, int n2, int n3, int n4) {
        int n5 = this.photomesa.state.getImagePadding();
        Vector vector = region.getImageItems();
        ZGroup zGroup = new ZGroup();
        double d = this.photomesa.state.getAspectRatio();
        int n6 = PhotoMesa.THUMB_WIDTHS[0];
        int n7 = (int)((double)n6 / d);
        int n8 = n6 + n5;
        int n9 = n7 + n5;
        region.imageItemsGrid = new ImageItem[n4][n3];
        region.numRows = n4;
        region.numCols = n3;
        int n10 = 0;
        int n11 = 0;
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ImageItem imageItem = (ImageItem)iterator.next();
            imageItem.setGridPosition(n11, n10);
            try {
                region.imageItemsGrid[n11][n10] = imageItem;
            }
            catch (Exception exception) {
                System.out.println("region = " + region.getName());
                System.out.println("dim = (" + n3 + ", " + n4 + ")");
                System.out.println("pos = (" + n11 + ", " + n10 + ")");
                System.out.println("len = " + vector.size());
                exception.printStackTrace();
                System.exit(1);
            }
            PMImage pMImage = imageItem.getThumb();
            while (pMImage.getNumParents() > 0) {
                ((ZVisualLeaf)pMImage.getParents()[0]).removeVisualComponent(pMImage);
            }
            ZVisualLeaf zVisualLeaf = new ZVisualLeaf(pMImage);
            zGroup.addChild(zVisualLeaf);
            int n12 = (int)pMImage.getBounds().getWidth();
            int n13 = (int)pMImage.getBounds().getHeight();
            if ((double)n12 / (double)n13 >= d) {
                zVisualLeaf.editor().getTransformGroup().scale((double)n6 / (double)n12);
            } else {
                zVisualLeaf.editor().getTransformGroup().scale((double)n7 / (double)n13);
            }
            zVisualLeaf.editor().getTransformGroup().position((Point2D)new Point2D.Double(0.5, 0.5), (Point2D)new Point2D.Double(0.5, 0.5), new ZBounds(n8 * (n + n10), n9 * (n2 + n11), n8, n9), 0, this.getDrawingSurface());
            if (++n10 < region.numCols) continue;
            n10 = 0;
            ++n11;
        }
        ZLayerGroup zLayerGroup = this.getLayer();
        region.setGroup(zGroup);
        this.regionTable.put(zGroup, region);
        zLayerGroup.addChild(zGroup);
        return zGroup;
    }

    void updateLabels() {
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.updateLabel();
        }
    }

    void hideLabels() {
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            region.hideLabel();
        }
    }

    void deleteSelectedImages() {
        Object object;
        ImageItem imageItem;
        Vector vector = this.getSelectionImageItems();
        if (vector.size() == 0) {
            return;
        }
        this.stopPreview();
        if (this.photomesa.state.getAskingBeforeDelete()) {
            imageItem = (ImageItem)vector.elementAt(0);
            object = vector.size() == 1 ? imageItem.toString() : "" + vector.size() + " images [" + imageItem.toString() + " ...]";
            if (!this.confirmDelete((String)object)) {
                return;
            }
        }
        object = vector.iterator();
        while (object.hasNext()) {
            imageItem = (ImageItem)object.next();
            this.deleteImage(imageItem, false);
        }
    }

    void deleteImage(ImageItem imageItem) {
        this.stopPreview();
        this.deleteImage(imageItem, true);
    }

    void deleteImage(ImageItem imageItem, boolean bl) {
        if (this.photomesa.state.getAskingBeforeDelete() && bl && !this.confirmDelete(imageItem.toString())) {
            return;
        }
        if (this.hiresImageLoaded && imageItem == this.hiresImageItem) {
            this.unloadHiResImage();
        }
        this.removeFromSelection(imageItem);
        imageItem.delete();
    }

    boolean confirmDelete(String string) {
        JCheckBox jCheckBox = new JCheckBox("Show confirmation when deleting");
        jCheckBox.setSelected(this.photomesa.state.getAskingBeforeDelete());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                Preferences.askingBeforeDelete.setSelected(jCheckBox.isSelected());
                ImagePane.this.photomesa.state.setAskingBeforeDelete(jCheckBox.isSelected());
            }
        });
        Object[] objectArray = new Object[]{"Are you sure delete " + string + " ?", jCheckBox};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 0, null, null, null);
        JDialog jDialog = jOptionPane.createDialog(null, "Delete Image");
        jDialog.show();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImagePane.this.eventHandlers.keyNavHandler.canvas.requestFocus();
            }
        });
        Object object = jOptionPane.getValue();
        return object instanceof Integer && (Integer)object == 0;
    }

    void zoomOut() {
        this.zoomOut(-1, true);
    }

    void zoomOut(int n, boolean bl) {
        Rectangle2D rectangle2D = this.getLayer().getBounds().createUnion(this.bottomLayer.getBounds());
        this.center(rectangle2D, bl, true, n);
        this.setCurrentRegion(null);
        this.cameraMags.clear();
    }

    void zoomOutStep() {
        if (!this.cameraMags.isEmpty()) {
            double d = this.magnificationPop();
            ZCamera zCamera = this.getCamera();
            ZBounds zBounds = zCamera.getViewBounds();
            double d2 = d / zCamera.getMagnification();
            double d3 = zBounds.getWidth() / d2;
            double d4 = zBounds.getHeight() / d2;
            double d5 = zBounds.getCenterX() - 0.5 * d3;
            double d6 = zBounds.getCenterY() - 0.5 * d4;
            ZBounds zBounds2 = this.getLayer().getBounds();
            zBounds2.add(this.getBottomLayer().getBounds());
            if (d5 + d3 > zBounds2.getX() + zBounds2.getWidth()) {
                d5 = zBounds2.getX() + zBounds2.getWidth() - d3;
            }
            if (d6 + d4 > zBounds2.getY() + zBounds2.getHeight()) {
                d6 = zBounds2.getY() + zBounds2.getHeight() - d4;
            }
            if (d5 < zBounds2.getX()) {
                d5 = zBounds2.getX();
            }
            if (d6 < zBounds2.getY()) {
                d6 = zBounds2.getY();
            }
            ZBounds zBounds3 = new ZBounds(d5, d6, d3, d4);
            this.center(zBounds3);
        } else if (this.photomesa.state.getLayoutType() != 3) {
            this.zoomOut();
        }
    }

    void center(Rectangle2D rectangle2D) {
        this.center(rectangle2D, true, true);
    }

    void center(Rectangle2D rectangle2D, boolean bl) {
        this.center(rectangle2D, bl, true);
    }

    void center(Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        this.center(rectangle2D, bl, bl2, -1);
    }

    void center(Rectangle2D rectangle2D, boolean bl, boolean bl2, int n) {
        int n2;
        ZCamera zCamera = this.getCamera();
        ZDrawingSurface zDrawingSurface = this.getDrawingSurface();
        ZBounds zBounds = zCamera.getViewBounds();
        double d = zCamera.getMagnification();
        Point2D point2D = zBounds.getCenter2D();
        ZBounds zBounds2 = new ZBounds(rectangle2D);
        Point2D point2D2 = zBounds2.getCenter2D();
        if (rectangle2D.getWidth() == 0.0 || rectangle2D.getHeight() == 0.0) {
            return;
        }
        this.hideLabels();
        if (bl2) {
            this.historyAdd(zBounds2);
        }
        this.activeCamera.center(zBounds2, 0, zDrawingSurface);
        double d2 = zCamera.getMagnification();
        this.activeCamera.center(zBounds, 0, zDrawingSurface);
        double d3 = d2 > d ? d2 / d : d / d2;
        double d4 = d3 - 1.0;
        double d5 = point2D.distance(point2D2);
        d5 *= d2;
        d4 += (d5 /= 1000.0);
        if (n >= 0) {
            n2 = n;
        } else {
            n2 = d4 < 1.0 ? (int)(d4 * 750.0) : (int)(750.0 + 0.15 * (d4 - 1.0) * 750.0);
            if (n2 < 100) {
                n2 = 0;
            }
            if (n2 > 2000) {
                n2 = 2000;
            }
            n2 = (int)((double)n2 * this.photomesa.state.getAnimationSpeed());
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        long l = 0L;
        if (this.photomesa.showSpeed) {
            l = System.currentTimeMillis();
            this.numFramesRendered = 0;
        }
        if (this.interruptableZoom) {
            boolean bl3 = this.interruptableAnimate(this.activeCamera, zBounds2, n2, zDrawingSurface);
            if (bl3) {
                bl = false;
            }
        } else {
            try {
                this.activeCamera.center(zBounds2, n2, zDrawingSurface);
            }
            catch (Exception exception) {
                System.out.println("Internal Error: Images may not be shown correctly");
            }
        }
        this.interruptableZoom = false;
        if (this.photomesa.showSpeed) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            System.out.println("Time = " + l3 + " ms, frames = " + this.numFramesRendered + ", speed = " + (int)(1000.0 * (double)this.numFramesRendered / (double)n2) + " fps");
        }
        this.updateLabels();
        this.setCursor(cursor);
        if (bl) {
            this.updateThumbs(true);
        }
    }

    boolean interruptableAnimate(ZCamera zCamera, ZBounds zBounds, int n, ZDrawingSurface zDrawingSurface) {
        double d;
        AffineTransform affineTransform = new AffineTransform();
        ZBounds zBounds2 = zCamera.getBoundsReference();
        double d2 = zBounds2.getWidth() / zBounds.getWidth();
        double d3 = d2 < (d = zBounds2.getHeight() / zBounds.getHeight()) ? d2 : d;
        double d4 = 0.5 * zBounds2.getWidth();
        double d5 = 0.5 * zBounds2.getHeight();
        double d6 = zBounds.getX() + 0.5 * zBounds.getWidth();
        double d7 = zBounds.getY() + 0.5 * zBounds.getHeight();
        affineTransform.translate(d4 + -d6 * d3, d5 + -d7 * d3);
        affineTransform.scale(d3, d3);
        double[] dArray = new double[6];
        double[] dArray2 = new double[6];
        double[] dArray3 = new double[6];
        zCamera.getMatrix(dArray);
        affineTransform.getMatrix(dArray3);
        boolean bl = false;
        if (n > 0) {
            long l;
            double d8;
            double d9 = d8 = (double)n / 30000.0;
            long l2 = System.currentTimeMillis();
            do {
                EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                while (eventQueue.peekEvent() != null) {
                    try {
                        AWTEvent aWTEvent = eventQueue.getNextEvent();
                        if (aWTEvent instanceof MouseEvent && (aWTEvent.getID() == 501 || aWTEvent.getID() == 401)) {
                            bl = true;
                            break;
                        }
                        Object object = aWTEvent.getSource();
                        if (aWTEvent instanceof ActiveEvent) {
                            ((ActiveEvent)((Object)aWTEvent)).dispatch();
                            continue;
                        }
                        if (object instanceof Component) {
                            ((Component)object).dispatchEvent(aWTEvent);
                            continue;
                        }
                        if (object instanceof MenuComponent) {
                            ((MenuComponent)object).dispatchEvent(aWTEvent);
                            continue;
                        }
                        System.err.println("unable to dispatch event: " + aWTEvent);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (bl) break;
                dArray2[0] = this.lerp(d9, dArray[0], dArray3[0]);
                dArray2[1] = this.lerp(d9, dArray[1], dArray3[1]);
                dArray2[2] = this.lerp(d9, dArray[2], dArray3[2]);
                dArray2[3] = this.lerp(d9, dArray[3], dArray3[3]);
                dArray2[4] = this.lerp(d9, dArray[4], dArray3[4]);
                dArray2[5] = this.lerp(d9, dArray[5], dArray3[5]);
                zCamera.setTransform(dArray2[0], dArray2[1], dArray2[2], dArray2[3], dArray2[4], dArray2[5]);
                zDrawingSurface.paintImmediately();
                l = System.currentTimeMillis() - l2;
                double d10 = d8 = (double)l / (double)n;
                double d11 = d9 = d10 > d9 ? d10 : d9;
            } while (l < (long)n);
        }
        if (!bl) {
            zCamera.setTransform(dArray3[0], dArray3[1], dArray3[2], dArray3[3], dArray3[4], dArray3[5]);
        }
        if (n > 0) {
            zDrawingSurface.paintImmediately();
        }
        return bl;
    }

    double lerp(double d, double d2, double d3) {
        return d2 + d * (d3 - d2);
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        super.paintImmediately(n, n2, n3, n4);
        ++this.numFramesRendered;
    }

    void magnificationPush() {
        double d = 0.0;
        double d2 = this.getCamera().getMagnification();
        if (!this.cameraMags.isEmpty()) {
            d = (Double)this.cameraMags.get(this.cameraMags.size() - 1);
        }
        if (d2 != d && d2 > d * 1.2) {
            this.cameraMags.add(new Double(d2));
        }
    }

    synchronized double magnificationPop() {
        double d;
        int n = this.cameraMags.size();
        double d2 = (Double)this.cameraMags.get(n - 1);
        this.cameraMags.remove(n - 1);
        if (n > 1 && d2 < 1.2 * (d = ((Double)this.cameraMags.get(n - 2)).doubleValue())) {
            return this.magnificationPop();
        }
        return d2;
    }

    void removeBiggerMagnification() {
        double d = this.getCamera().getMagnification();
        while (!this.cameraMags.isEmpty()) {
            double d2 = (Double)this.cameraMags.get(this.cameraMags.size() - 1);
            if (d2 >= d * 0.8) {
                this.cameraMags.remove(this.cameraMags.size() - 1);
            }
            if (d2 >= d * 0.8) continue;
        }
    }

    void historyAdd(ZBounds zBounds) {
        while (this.history.size() > this.historyIndex) {
            this.history.remove(this.history.size() - 1);
        }
        this.history.add(zBounds);
        ++this.historyIndex;
    }

    void historyBack() {
        if (this.historyIndex > 1) {
            --this.historyIndex;
            this.center((ZBounds)this.history.get(this.historyIndex - 1), true, false);
        }
    }

    void historyForward() {
        if (this.historyIndex < this.history.size()) {
            ++this.historyIndex;
            this.center((ZBounds)this.history.get(this.historyIndex - 1), true, false);
        }
    }

    void startDelayedHiliteFade() {
        if (!this.isHiliteOn) {
            this.isHiliteOn = true;
            Iterator iterator = this.fadeNodes.iterator();
            while (iterator.hasNext()) {
                ZNode zNode = (ZNode)iterator.next();
                zNode.editor().getFadeGroup().setAlpha(1.0);
            }
            this.updateLabels();
        }
        if (this.fadeTimer != null) {
            this.fadeTimer.stop();
        }
        this.fadeTask = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ImagePane.this.fadeTimer = null;
                ImagePane.this.startHiliteFade();
            }
        };
        this.fadeTimer = new Timer(2000, this.fadeTask);
        this.fadeTimer.setRepeats(false);
        this.fadeTimer.start();
    }

    void startHiliteFade() {
        this.isFadingHilite = true;
        this.fadeStartTime = System.currentTimeMillis();
        this.stepHiliteFade();
    }

    void stopHiliteFade() {
        this.isFadingHilite = false;
        if (this.fadeTimer != null) {
            this.fadeTimer.stop();
            this.fadeTimer = null;
        }
        this.stepHiliteFade();
    }

    void stepHiliteFade() {
        ZNode zNode;
        boolean bl = false;
        if (this.isFadingHilite) {
            long l = System.currentTimeMillis();
            double d = ((double)l - (double)this.fadeStartTime) / 500.0;
            if (d <= 1.0) {
                Iterator iterator = this.fadeNodes.iterator();
                while (iterator.hasNext()) {
                    zNode = (ZNode)iterator.next();
                    zNode.editor().getFadeGroup().setAlpha(1.0 - d);
                }
                try {
                    Thread.sleep(20L);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ImagePane.this.stepHiliteFade();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this.isFadingHilite = false;
                }
            } else {
                bl = true;
            }
        }
        if (!this.isFadingHilite || bl) {
            this.isHiliteOn = false;
            Iterator iterator = this.fadeNodes.iterator();
            while (iterator.hasNext()) {
                zNode = (ZNode)iterator.next();
                zNode.editor().getFadeGroup().setAlpha(0.0);
            }
        }
    }

    void showImmediatePreview(PMImage pMImage, Point2D point2D, boolean bl) {
        Cloneable cloneable;
        ZTransformGroup zTransformGroup;
        if (pMImage == null) {
            this.stopPreview();
            return;
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = 1.0 / this.getCamera().getMagnification();
        int n = PhotoMesa.THUMB_WIDTHS.length - 1;
        ImageItem imageItem = pMImage.imageItem;
        String string = imageItem.getThumbPath(n);
        File file = new File(string);
        if (this.previewNode != null && this.currentPreviewThumbPath != null && this.currentPreviewThumbPath.equals(string)) {
            if (!bl) {
                zTransformGroup = this.previewNode.editor().getTransformGroup();
                zTransformGroup.setScale(d3);
                zTransformGroup.setTranslation(d, d2, 0, this.getDrawingSurface());
            }
        } else if (file.exists()) {
            if (this.previewNode != null) {
                this.stopPreview();
            }
            int n2 = PhotoMesa.THUMB_WIDTHS[n];
            cloneable = imageItem.getThumb().getParents()[0];
            double d4 = ((ZNode)cloneable).getGlobalBounds().getWidth();
            double d5 = ((ZNode)cloneable).getGlobalBounds().getHeight();
            if (d5 > d4) {
                d4 = d5 * this.photomesa.state.getAspectRatio();
            }
            this.previewStartScale = d4 / (double)n2;
            if (this.previewStartScale * this.getCamera().getMagnification() > 0.6) {
                this.previewNode = null;
                return;
            }
            this.currentPreviewThumbPath = string;
            Image image = Toolkit.getDefaultToolkit().createImage(string);
            PMImage pMImage2 = new PMImage(image, imageItem, n);
            pMImage2.setPenColor(imageItem.getThumb().getPenColor());
            pMImage2.setPenWidth(this.photomesa.state.getThumbPenWidth());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
                this.previewNode = new ZVisualLeaf(pMImage2);
                ZTransformGroup zTransformGroup2 = this.previewNode.editor().getTransformGroup();
                zTransformGroup2.setScale(d3);
                if (bl) {
                    zTransformGroup2.setTranslation(d, d2, 0, this.getDrawingSurface());
                } else {
                    zTransformGroup2.setTranslation(d, d2, 0, this.getDrawingSurface());
                }
                this.previewNode.editor().getTop().setFindable(false);
                this.previewNode.editor().getTop().setPickable(false);
                this.topLayer.addChild(this.previewNode.editor().getTop());
                this.isPreviewOn = true;
                this.isGrowingPreview = false;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Couldn't load image: " + file);
            }
        }
        if (this.previewNode != null) {
            zTransformGroup = this.previewNode.editor().getTransformGroup();
            cloneable = this.getCamera().getViewBounds();
            ZBounds zBounds = this.previewNode.getGlobalBounds();
            if (zBounds.getX() < ((Rectangle2D.Double)cloneable).getX()) {
                zTransformGroup.translate((((Rectangle2D.Double)cloneable).getX() - zBounds.getX()) / d3, 0.0);
            }
            if (zBounds.getY() < ((Rectangle2D.Double)cloneable).getY()) {
                zTransformGroup.translate(0.0, (((Rectangle2D.Double)cloneable).getY() - zBounds.getY()) / d3);
            }
            if (zBounds.getX() + zBounds.getWidth() > ((Rectangle2D.Double)cloneable).getX() + ((Rectangle2D.Double)cloneable).getWidth()) {
                zTransformGroup.translate((((Rectangle2D.Double)cloneable).getX() + ((Rectangle2D.Double)cloneable).getWidth() - (zBounds.getX() + zBounds.getWidth())) / d3, 0.0);
            }
            if (zBounds.getY() + zBounds.getHeight() > ((Rectangle2D.Double)cloneable).getY() + ((Rectangle2D.Double)cloneable).getHeight()) {
                zTransformGroup.translate(0.0, (((Rectangle2D.Double)cloneable).getY() + ((Rectangle2D.Double)cloneable).getHeight() - (zBounds.getY() + zBounds.getHeight())) / d3);
            }
        }
    }

    void startDelayedPreview(final PMImage pMImage, final Point2D point2D) {
        if (this.isPreviewOn) {
            this.stopPreview();
        }
        if (this.previewTimer != null) {
            this.previewTimer.stop();
        }
        if (pMImage != null) {
            this.previewTask = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ImagePane.this.previewTimer = null;
                    ImagePane.this.startPreview(pMImage.getImageItem(), point2D);
                }
            };
            this.previewTimer = new Timer(400, this.previewTask);
            this.previewTimer.setRepeats(false);
            this.previewTimer.start();
        }
    }

    void startPreview(ImageItem imageItem, Point2D point2D) {
        int n = PhotoMesa.THUMB_WIDTHS.length - 1;
        String string = imageItem.getThumbPath(n);
        File file = new File(string);
        if (file.exists()) {
            Image image = Toolkit.getDefaultToolkit().createImage(string);
            PMImage pMImage = new PMImage(image, imageItem, n);
            pMImage.setPenColor(imageItem.getThumb().getPenColor());
            pMImage.setPenWidth(this.photomesa.state.getThumbPenWidth());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
                this.previewNode = new ZVisualLeaf(pMImage);
                ZNode zNode = imageItem.getThumb().getParents()[0];
                ZBounds zBounds = zNode.getGlobalBounds();
                double d = zNode.getGlobalBounds().getWidth();
                this.previewStartScale = d / this.previewNode.getBounds().getWidth();
                if (this.previewStartScale * this.getCamera().getMagnification() < 0.6) {
                    ZTransformGroup zTransformGroup = this.previewNode.editor().getTransformGroup();
                    zTransformGroup.setScale(this.previewStartScale);
                    zTransformGroup.setTranslation(zBounds.getX(), zBounds.getY());
                    this.previewNode.editor().getTop().setFindable(false);
                    this.previewNode.editor().getTop().setPickable(false);
                    this.topLayer.addChild(this.previewNode.editor().getTop());
                    this.isPreviewOn = true;
                    this.isGrowingPreview = true;
                    this.previewStartTime = System.currentTimeMillis();
                    this.stepPreview(zNode, point2D);
                } else {
                    this.previewNode = null;
                }
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Couldn't load image: " + file);
            }
        }
    }

    void stopPreview() {
        this.isGrowingPreview = false;
        this.isPreviewOn = false;
        this.currentPreviewThumbPath = null;
        if (this.previewTimer != null) {
            this.previewTimer.stop();
            this.previewTimer = null;
        }
        if (this.previewNode != null) {
            ZNode zNode = this.previewNode.editor().getTop();
            zNode.getParent().removeChild(zNode);
            this.previewNode = null;
        }
    }

    void stepPreview(final ZNode zNode, final Point2D point2D) {
        double d = 0.0;
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = 1.0 / this.getCamera().getMagnification();
        if (this.isGrowingPreview) {
            long l = System.currentTimeMillis();
            double d5 = ((double)l - (double)this.previewStartTime) / 100.0;
            if (d5 <= 1.0) {
                d = this.previewStartScale + d5 * (d4 - this.previewStartScale);
                ZBounds zBounds = zNode.getGlobalBounds();
                d2 = zBounds.getX() + d5 * (point2D.getX() - zBounds.getX());
                d3 = zBounds.getY() + d5 * (point2D.getY() - zBounds.getY());
                try {
                    Thread.sleep(20L);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            ImagePane.this.stepPreview(zNode, point2D);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    d = d4;
                    this.isGrowingPreview = false;
                }
            } else {
                d = d4;
                this.isGrowingPreview = false;
            }
        }
        if (this.previewNode != null) {
            ZBounds zBounds = zNode.getGlobalBounds();
            ZTransformGroup zTransformGroup = this.previewNode.editor().getTransformGroup();
            zTransformGroup.setScale(d);
            zTransformGroup.position((Point2D)new Point2D.Double(0.5, 0.5), (Point2D)new Point2D.Double(0.5, 0.5), zBounds, 0, this.getDrawingSurface());
            ZBounds zBounds2 = this.getCamera().getViewBounds();
            zBounds = this.previewNode.getGlobalBounds();
            if (zBounds.getX() < zBounds2.getX()) {
                zTransformGroup.translate((zBounds2.getX() - zBounds.getX()) / d, 0.0);
            }
            if (zBounds.getY() < zBounds2.getY()) {
                zTransformGroup.translate(0.0, (zBounds2.getY() - zBounds.getY()) / d);
            }
            if (zBounds.getX() + zBounds.getWidth() > zBounds2.getX() + zBounds2.getWidth()) {
                zTransformGroup.translate((zBounds2.getX() + zBounds2.getWidth() - (zBounds.getX() + zBounds.getWidth())) / d, 0.0);
            }
            if (zBounds.getY() + zBounds.getHeight() > zBounds2.getY() + zBounds2.getHeight()) {
                zTransformGroup.translate(0.0, (zBounds2.getY() + zBounds2.getHeight() - (zBounds.getY() + zBounds.getHeight())) / d);
            }
        }
    }

    boolean isHiResImageLoaded() {
        return this.hiresImageLoaded;
    }

    void showHiResImage(ImageItem imageItem) {
        if (this.hiresImageLoaded) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        PMImage pMImage = imageItem.getThumb();
        double d = this.photomesa.state.getAnimationSpeed();
        this.photomesa.state.setAnimationSpeed(this.photomesa.state.getAnimationSpeed() * 0.5);
        ZBounds zBounds = pMImage.getGlobalBounds();
        imageItem.loadHiResImage();
        this.center(zBounds, false);
        imageItem.displayHiResImage();
        this.hiresImageLoaded = true;
        this.hiresImageItem = imageItem;
        this.photomesa.state.setAnimationSpeed(d);
        if (this.currentRegion != imageItem.getRegion()) {
            this.currentRegion = imageItem.getRegion();
        }
        this.hiresImageRow = imageItem.getGridRow();
        this.hiresImageCol = imageItem.getGridCol();
        this.stopHiliteFade();
        this.setCursor(cursor);
        this.hideLabels();
    }

    void unloadHiResImage() {
        if (this.hiresImageLoaded) {
            this.hiresImageItem.unloadHiResImage();
            this.hiresImageItem = null;
            this.hiresImageLoaded = false;
        }
        this.updateLabels();
    }

    ZBounds getHiresOneToOneBounds(ImageItem imageItem) {
        ZBounds zBounds = new ZBounds();
        ZBounds zBounds2 = imageItem.getThumb().getGlobalBounds();
        double d = zBounds2.getWidth();
        double d2 = zBounds2.getHeight();
        Point2D point2D = zBounds2.getCenter2D();
        double d3 = this.getCamera().getBoundsReference().getWidth();
        double d4 = this.getCamera().getBoundsReference().getHeight();
        if (imageItem.hiresImage == null || imageItem.hiresImage.width < 0) {
            return zBounds;
        }
        double d5 = d / (double)imageItem.hiresImage.width;
        double d6 = d3 * d5;
        double d7 = d4 * d5;
        zBounds.setRect(point2D.getX() - d6 / 2.0, point2D.getY() - d7 / 2.0, d6, d7);
        return zBounds;
    }

    void notifyOneToOne(ImageItem imageItem, double d, double d2) {
        PMImage pMImage = imageItem.getThumb();
        double d3 = this.photomesa.state.getAnimationSpeed();
        this.photomesa.state.setAnimationSpeed(this.photomesa.state.getAnimationSpeed() * 0.5);
        ZBounds zBounds = pMImage.getGlobalBounds();
        double d4 = zBounds.getWidth();
        double d5 = zBounds.getHeight();
        Point2D point2D = zBounds.getCenter2D();
        double d6 = this.getCamera().getBoundsReference().getWidth();
        double d7 = this.getCamera().getBoundsReference().getHeight();
        double d8 = this.getCamera().getScale();
        double d9 = d4 / d;
        double d10 = d6 * d9;
        double d11 = d7 * d9;
        ZBounds zBounds2 = new ZBounds(point2D.getX() - d10 / 2.0, point2D.getY() - d11 / 2.0, d10, d11);
        this.center(zBounds2, false);
        imageItem.displayHiResImage();
        this.hiresImageLoaded = true;
        this.hiresImageItem = imageItem;
        this.photomesa.state.setAnimationSpeed(d3);
        if (this.currentRegion != imageItem.getRegion()) {
            this.currentRegion = imageItem.getRegion();
        }
        this.hiresImageRow = imageItem.getGridRow();
        this.hiresImageCol = imageItem.getGridCol();
        this.stopHiliteFade();
        this.hideLabels();
    }

    void showHiResOneToOneImage(ImageItem imageItem) {
        if (this.hiresImageLoaded) {
            return;
        }
        imageItem.loadHiResOneToOneImage();
    }

    void setFocus(ZMouseEvent zMouseEvent) {
        ImageItem imageItem;
        Point2D.Double double_ = new Point2D.Double();
        ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
        ((Point2D)double_).setLocation(zMouseEvent.getX(), zMouseEvent.getY());
        zSceneGraphPath.screenToGlobal(double_);
        boolean bl = false;
        if (this.currentRegion == null) {
            bl = true;
        }
        this.setActiveRegion(double_);
        PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
        if (pMImage != null && (imageItem = pMImage.getImageItem()) != null) {
            if (imageItem.imageWidth > 0 && imageItem.imageHeight > 0) {
                this.photomesa.setStatusBarAuxText(imageItem.getImagePath() + "       (" + imageItem.imageWidth + "x" + imageItem.imageHeight + " pixels)");
            } else {
                this.photomesa.setStatusBarAuxText(imageItem.getImagePath());
            }
        }
        if (bl) {
            return;
        }
        this.computeHiliteArea(double_);
        this.startDelayedHiliteFade();
    }

    void setActiveRegion(Point2D point2D) {
        if (this.currentRegion == null && this.photomesa.regions.size() > 1 && this.photomesa.state.getLayoutType() != 3) {
            Region region = this.findRegion(point2D);
            if (region != null) {
                Rectangle2D rectangle2D;
                if (this.armedRegion != region) {
                    if (this.armedRegion != null) {
                        this.armedRegion.updateLabel(false);
                        this.armedRegion.setActive(false);
                    }
                    if (region != null) {
                        region.updateLabel(true);
                        region.setActive(true);
                    }
                    this.armedRegion = region;
                }
                if (!(rectangle2D = this.hiliteRect.getRect()).equals(region.getBorder().getParents()[0].getGlobalBounds())) {
                    this.setHiliteBounds(region.getBorder().getParents()[0].getGlobalBounds());
                    this.setHilitePen(PhotoMesa.HILITE_PEN_COLOR);
                    this.setHiliteFill(PhotoMesa.HILITE_FILL_COLOR);
                }
                this.hiliteEmpty = false;
            }
        } else if (this.photomesa.regions.size() >= 1) {
            this.armedRegion = this.findRegion(point2D);
            if (this.armedRegion == null) {
                this.armedRegion = (Region)this.photomesa.regions.get(0);
            }
            this.setCurrentRegion(this.armedRegion);
        }
    }

    void setCurrentRegion(Region region) {
        if (region != this.currentRegion) {
            if (this.currentRegion != null) {
                this.currentRegion.setActive(false);
            }
            this.currentRegion = region;
            if (this.currentRegion != null) {
                this.currentRegion.setActive(true);
            }
        }
        if (this.photomesa.state.getLayoutType() == 3) {
            if (this.hiliteRect.getPenColor() != PhotoMesa.HILITE_PEN_COLOR) {
                this.setHilitePen(PhotoMesa.HILITE_PEN_COLOR);
            }
            if (this.hiliteRect.getFillColor() != null) {
                this.setHilitePen(null);
            }
        } else {
            if (this.hiliteRect.getPenColor() != PhotoMesa.HILITE_PEN_COLOR) {
                this.setHilitePen(PhotoMesa.HILITE_PEN_COLOR);
            }
            if (this.hiliteRect.getFillColor() != PhotoMesa.HILITE_FILL_COLOR) {
                this.setHilitePen(PhotoMesa.HILITE_FILL_COLOR);
            }
        }
    }

    void computeHiliteArea(Point2D point2D) {
        ZGroup zGroup;
        ZCamera zCamera = this.getCamera();
        if (this.currentRegion != null && (zGroup = this.currentRegion.getGroup()) != null) {
            ZBounds zBounds = zGroup.getGlobalBounds();
            ZBounds zBounds2 = zCamera.getViewBounds();
            double d = zCamera.getMagnification();
            double d2 = zGroup.editor().getTransformGroup().getScale();
            double d3 = (double)(PhotoMesa.THUMB_WIDTHS[0] + this.photomesa.state.getImagePadding()) * d * d2;
            double d4 = ((double)PhotoMesa.THUMB_WIDTHS[0] / this.photomesa.state.getAspectRatio() + (double)this.photomesa.state.getImagePadding()) * d * d2;
            double d5 = zBounds.getWidth() * d;
            double d6 = zBounds.getHeight() * d;
            if ((double)this.getWidth() < d5) {
                d5 = this.getWidth();
            }
            if ((double)this.getHeight() < d6) {
                d6 = this.getHeight();
            }
            int n = d5 > d6 ? (int)Math.floor(0.5 * d5 / d3) : (int)Math.floor(0.5 * d6 / d4);
            if (d3 > 0.75 * (double)PhotoMesa.THUMB_WIDTHS[PhotoMesa.THUMB_WIDTHS.length - 1]) {
                n = 0;
            } else if (n == 1) {
                n = 2;
            }
            int n2 = n / 2;
            Point point = this.currentRegion.getGridPt(point2D);
            ZBounds zBounds3 = new ZBounds();
            if (point.x == this.currentRegion.numCols && point.y == this.currentRegion.numRows) {
                this.singleImageHilite = false;
                this.singleImageItem = null;
            } else {
                int n3 = point.x - n2;
                while (n3 <= point.x + n2) {
                    int n4 = point.y - n2;
                    while (n4 <= point.y + n2) {
                        try {
                            zBounds3.add(this.currentRegion.imageItemsGrid[n4][n3].getThumb().getGlobalBounds());
                            this.singleImageItem = this.currentRegion.imageItemsGrid[point.y][point.x];
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        ++n4;
                    }
                    ++n3;
                }
                if (n2 == 0) {
                    this.singleImageHilite = true;
                } else {
                    this.singleImageHilite = false;
                    this.singleImageItem = null;
                }
            }
            int n5 = this.photomesa.state.getImagePadding();
            int n6 = n5 / 4;
            Rectangle2D rectangle2D = this.hiliteRect.getRect();
            ZBounds zBounds4 = new ZBounds(zBounds3.getX() - (double)n6, zBounds3.getY() - (double)n6, zBounds3.getWidth() + (double)(2 * n6), zBounds3.getHeight() + (double)(2 * n6));
            if (rectangle2D == null || !rectangle2D.equals(zBounds4)) {
                this.setHiliteBounds(zBounds4);
            }
            this.hiliteEmpty = zBounds3.isEmpty();
        }
    }

    void updateThumbs(boolean bl) {
        this.updateThumbs(bl, null);
    }

    void updateThumbs(boolean bl, Progress progress) {
        ImageItem imageItem;
        Serializable serializable;
        Object object;
        Object object2;
        Vector<ImageItem> vector;
        int n = 0;
        Object var5_4 = null;
        ZCamera zCamera = this.getCamera();
        Vector vector2 = new Vector();
        int n2 = 0;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (bl) {
            vector = this.getVisibleImageItems();
        } else {
            vector = new Vector<ImageItem>();
            object2 = this.photomesa.regions.iterator();
            while (object2.hasNext()) {
                object = (Region)object2.next();
                serializable = ((Region)object).getImageItems();
                Iterator iterator = serializable.iterator();
                while (iterator.hasNext()) {
                    imageItem = (ImageItem)iterator.next();
                    vector.add(imageItem);
                }
                n2 += serializable.size();
                vector.add(null);
            }
        }
        if (progress != null) {
            progress.setLabel("Displaying " + n2 + " images");
            progress.setMaximum(n2);
        }
        try {
            this.photomesa.processQueuedEvents();
            object = vector.iterator();
            while (object.hasNext()) {
                int n3;
                imageItem = (ImageItem)object.next();
                if (progress != null) {
                    progress.setValue(n++);
                }
                if (imageItem != null) {
                    this.updateThumb(imageItem);
                } else {
                    this.photomesa.processQueuedEvents();
                }
                if (eventQueue.peekEvent(501) == null && eventQueue.peekEvent(401) == null || (serializable = eventQueue.peekEvent(401)) instanceof KeyEvent && (n3 = ((KeyEvent)(object2 = (KeyEvent)serializable)).getKeyCode()) == 32) {
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void updateThumb(ImageItem imageItem) {
        double d = PhotoMesa.THUMB_WIDTHS[0];
        double d2 = d / this.photomesa.state.getAspectRatio();
        double d3 = this.photomesa.state.getAspectRatio();
        double d4 = this.getCamera().getMagnification();
        PMImage pMImage = imageItem.getThumb();
        ZVisualLeaf zVisualLeaf = (ZVisualLeaf)pMImage.getParents()[0];
        ZTransformGroup zTransformGroup = zVisualLeaf.editor().getTransformGroup();
        int n = this.photomesa.getThumbLevel(pMImage.getMagnification() * d4);
        if (imageItem.getThumbLevel() != n) {
            ZBounds zBounds = zVisualLeaf.getGlobalBounds();
            imageItem.loadThumb(n);
            double d5 = pMImage.getWidth();
            double d6 = pMImage.getHeight();
            double d7 = d5 / d6 > d3 ? d / d5 : d2 / d6;
            zTransformGroup.scale(d7 / zTransformGroup.getScale() * imageItem.scale);
            zTransformGroup.position((Point2D)new Point2D.Double(0.5, 0.5), (Point2D)new Point2D.Double(0.5, 0.5), zBounds, 0, this.getDrawingSurface());
        }
        pMImage.setPenWidth((double)this.photomesa.state.getThumbPenWidth() / (zTransformGroup.getScale() * d4));
    }

    void updateThumbBorderWidth() {
        this.clearSelection();
        Iterator iterator = this.photomesa.regions.iterator();
        while (iterator.hasNext()) {
            Region region = (Region)iterator.next();
            Vector vector = region.getImageItems();
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                ImageItem imageItem = (ImageItem)iterator2.next();
                PMImage pMImage = imageItem.getThumb();
                pMImage.setPenWidth(this.photomesa.state.getThumbPenWidth());
            }
        }
    }

    Vector getVisibleImageItems() {
        Vector<ImageItem> vector = new Vector<ImageItem>();
        ZCamera zCamera = this.getCamera();
        ZBounds zBounds = zCamera.getViewBounds();
        ZBoundsFindFilter zBoundsFindFilter = new ZBoundsFindFilter(zBounds);
        ArrayList arrayList = zCamera.findNodes(zBoundsFindFilter);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ZVisualLeaf zVisualLeaf = (ZVisualLeaf)iterator.next();
            PMImage pMImage = (PMImage)zVisualLeaf.getFirstVisualComponent();
            ImageItem imageItem = pMImage.getImageItem();
            if (imageItem != null) {
                vector.add(imageItem);
                continue;
            }
            System.out.println("visual component not an imageitem: " + pMImage);
        }
        return vector;
    }

    void goLeft() {
        ZCamera zCamera = this.getCamera();
        ZBounds zBounds = zCamera.getViewBounds();
        ZBounds zBounds2 = this.getLayer().getBounds();
        zBounds2.add(this.getBottomLayer().getBounds());
        if (this.hiresImageLoaded) {
            int n;
            ImageItem imageItem;
            int n2 = this.hiresImageCol;
            int n3 = this.hiresImageRow;
            boolean bl = false;
            do {
                if (this.hiresImageCol > 0) {
                    --this.hiresImageCol;
                    continue;
                }
                if (this.hiresImageRow > 0) {
                    this.hiresImageCol = this.currentRegion.numCols - 1;
                    --this.hiresImageRow;
                    continue;
                }
                bl = true;
            } while ((imageItem = this.currentRegion.imageItemsGrid[this.hiresImageRow][this.hiresImageCol]) == null && !bl);
            if (bl) {
                n = this.currentRegion.numRows - 1;
                while (n >= 0) {
                    int n4 = this.currentRegion.numCols - 1;
                    while (n4 >= 0) {
                        imageItem = this.currentRegion.imageItemsGrid[n][n4];
                        if (imageItem != null) {
                            this.hiresImageRow = n;
                            this.hiresImageCol = n4;
                            break;
                        }
                        --n4;
                    }
                    if (imageItem != null) break;
                    --n;
                }
            }
            n = 1;
            if (Math.abs(this.hiresImageCol - n2) + Math.abs(this.hiresImageRow - n3) <= 1) {
                n = 0;
            }
            this.unloadHiResImage();
            if (n != 0) {
                ZBounds zBounds3 = imageItem.getThumb().getGlobalBounds();
                zBounds.add(zBounds3);
                this.center(zBounds, false);
            }
            this.showHiResImage(imageItem);
        } else {
            double d = zBounds.getX();
            double d2 = zBounds.getY();
            double d3 = zBounds.getWidth();
            double d4 = zBounds.getHeight();
            double d5 = d;
            double d6 = d2;
            if (d5 <= zBounds2.getX() + 1.0 && d6 > zBounds2.getY() + 1.0) {
                d5 = zBounds2.getX() + zBounds2.getWidth() - d3;
                if ((d6 -= zBounds.getHeight()) < zBounds2.getY()) {
                    d6 = zBounds2.getY();
                }
            } else if ((d5 -= d3 * 0.5) < zBounds2.getX()) {
                d5 = zBounds2.getX();
            }
            ZBounds zBounds4 = new ZBounds();
            zBounds4.setRect(d5, d6, d3, d4);
            zBounds.setRect(d, d2, d3, d4);
            if (!zBounds.intersects(d5, d6, d3, d4)) {
                zBounds.add(zBounds4);
                this.center(zBounds, false);
            }
            this.center(zBounds4);
        }
    }

    void goRight() {
        ZCamera zCamera = this.getCamera();
        ZBounds zBounds = zCamera.getViewBounds();
        ZBounds zBounds2 = this.getLayer().getBounds();
        zBounds2.add(this.getBottomLayer().getBounds());
        if (this.hiresImageLoaded) {
            int n;
            ImageItem imageItem;
            int n2 = this.hiresImageCol;
            int n3 = this.hiresImageRow;
            boolean bl = false;
            do {
                if (this.hiresImageCol < this.currentRegion.numCols - 1) {
                    ++this.hiresImageCol;
                    continue;
                }
                if (this.hiresImageRow < this.currentRegion.numRows - 1) {
                    this.hiresImageCol = 0;
                    ++this.hiresImageRow;
                    continue;
                }
                bl = true;
            } while ((imageItem = this.currentRegion.imageItemsGrid[this.hiresImageRow][this.hiresImageCol]) == null && !bl);
            if (bl) {
                n = 0;
                while (n < this.currentRegion.numRows) {
                    int n4 = 0;
                    while (n4 < this.currentRegion.numCols) {
                        imageItem = this.currentRegion.imageItemsGrid[n][n4];
                        if (imageItem != null) {
                            this.hiresImageRow = n;
                            this.hiresImageCol = n4;
                            break;
                        }
                        ++n4;
                    }
                    if (imageItem != null) break;
                    ++n;
                }
            }
            n = 1;
            if (Math.abs(this.hiresImageCol - n2) + Math.abs(this.hiresImageRow - n3) <= 1) {
                n = 0;
            }
            this.unloadHiResImage();
            if (n != 0) {
                ZBounds zBounds3 = imageItem.getThumb().getGlobalBounds();
                zBounds.add(zBounds3);
                this.center(zBounds, false);
            }
            this.showHiResImage(imageItem);
        } else {
            double d = zBounds.getX();
            double d2 = zBounds.getY();
            double d3 = zBounds.getWidth();
            double d4 = zBounds.getHeight();
            double d5 = d;
            double d6 = d2;
            if (d5 >= zBounds2.getX() + zBounds2.getWidth() - d3 - 1.0 && d6 < zBounds2.getY() + zBounds2.getHeight() - d4 - 1.0) {
                d5 = zBounds2.getX();
                if ((d6 += zBounds.getHeight()) + d4 > zBounds2.getY() + zBounds2.getHeight()) {
                    d6 = zBounds2.getY() + zBounds2.getHeight() - d4;
                }
            } else if ((d5 += d3 * 0.5) + d3 > zBounds2.getX() + zBounds2.getWidth()) {
                d5 = zBounds2.getX() + zBounds2.getWidth() - d3;
            }
            ZBounds zBounds4 = new ZBounds();
            zBounds4.setRect(d5, d6, d3, d4);
            zBounds.setRect(d, d2, d3, d4);
            if (!zBounds.intersects(d5, d6, d3, d4)) {
                zBounds.add(zBounds4);
                this.center(zBounds, false);
            }
            this.center(zBounds4);
        }
    }

    void goUp() {
        ZCamera zCamera = this.getCamera();
        ZBounds zBounds = zCamera.getViewBounds();
        ZBounds zBounds2 = this.getLayer().getBounds();
        zBounds2.add(this.getBottomLayer().getBounds());
        if (this.hiresImageLoaded) {
            int n;
            ImageItem imageItem;
            int n2 = this.hiresImageCol;
            int n3 = this.hiresImageRow;
            boolean bl = false;
            do {
                if (this.hiresImageRow > 0) {
                    --this.hiresImageRow;
                    continue;
                }
                if (this.hiresImageCol > 0) {
                    this.hiresImageRow = this.currentRegion.numRows - 1;
                    --this.hiresImageCol;
                    continue;
                }
                bl = true;
            } while ((imageItem = this.currentRegion.imageItemsGrid[this.hiresImageRow][this.hiresImageCol]) == null && !bl);
            if (bl) {
                n = this.currentRegion.numCols - 1;
                while (n >= 0) {
                    int n4 = this.currentRegion.numRows - 1;
                    while (n4 >= 0) {
                        imageItem = this.currentRegion.imageItemsGrid[n4][n];
                        if (imageItem != null) {
                            this.hiresImageRow = n4;
                            this.hiresImageCol = n;
                            break;
                        }
                        --n4;
                    }
                    if (imageItem != null) break;
                    --n;
                }
            }
            n = 1;
            if (Math.abs(this.hiresImageCol - n2) + Math.abs(this.hiresImageRow - n3) <= 1) {
                n = 0;
            }
            this.unloadHiResImage();
            if (n != 0) {
                ZBounds zBounds3 = imageItem.getThumb().getGlobalBounds();
                zBounds.add(zBounds3);
                this.center(zBounds, false);
            }
            this.showHiResImage(imageItem);
        } else {
            double d = zBounds.getX();
            double d2 = zBounds.getY();
            double d3 = zBounds.getWidth();
            double d4 = zBounds.getHeight();
            double d5 = d;
            double d6 = d2;
            if (d6 <= zBounds2.getY() + 1.0 && d5 > zBounds2.getX() + 1.0) {
                d6 = zBounds2.getY() + zBounds2.getHeight() - d4;
                if ((d5 -= zBounds.getWidth()) < zBounds2.getX()) {
                    d5 = zBounds2.getX();
                }
            } else if ((d6 -= d4 * 0.5) < zBounds2.getY()) {
                d6 = zBounds2.getY();
            }
            ZBounds zBounds4 = new ZBounds();
            zBounds4.setRect(d5, d6, d3, d4);
            zBounds.setRect(d, d2, d3, d4);
            if (!zBounds.intersects(d5, d6, d3, d4)) {
                zBounds.add(zBounds4);
                this.center(zBounds, false);
            }
            this.center(zBounds4);
        }
    }

    void goDown() {
        ZCamera zCamera = this.getCamera();
        ZBounds zBounds = zCamera.getViewBounds();
        ZBounds zBounds2 = this.getLayer().getBounds();
        zBounds2.add(this.getBottomLayer().getBounds());
        if (this.hiresImageLoaded) {
            int n;
            ImageItem imageItem;
            int n2 = this.hiresImageCol;
            int n3 = this.hiresImageRow;
            boolean bl = false;
            do {
                if (this.hiresImageRow < this.currentRegion.numRows - 1) {
                    ++this.hiresImageRow;
                    continue;
                }
                if (this.hiresImageCol < this.currentRegion.numCols - 1) {
                    this.hiresImageRow = 0;
                    ++this.hiresImageCol;
                    continue;
                }
                bl = true;
            } while ((imageItem = this.currentRegion.imageItemsGrid[this.hiresImageRow][this.hiresImageCol]) == null && !bl);
            if (bl) {
                n = 0;
                while (n < this.currentRegion.numCols) {
                    int n4 = 0;
                    while (n4 < this.currentRegion.numRows) {
                        imageItem = this.currentRegion.imageItemsGrid[n4][n];
                        if (imageItem != null) {
                            this.hiresImageRow = n4;
                            this.hiresImageCol = n;
                            break;
                        }
                        ++n4;
                    }
                    if (imageItem != null) break;
                    ++n;
                }
            }
            n = 1;
            if (Math.abs(this.hiresImageCol - n2) + Math.abs(this.hiresImageRow - n3) <= 1) {
                n = 0;
            }
            this.unloadHiResImage();
            if (n != 0) {
                ZBounds zBounds3 = imageItem.getThumb().getGlobalBounds();
                zBounds.add(zBounds3);
                this.center(zBounds, false);
            }
            this.showHiResImage(imageItem);
        } else {
            double d = zBounds.getX();
            double d2 = zBounds.getY();
            double d3 = zBounds.getWidth();
            double d4 = zBounds.getHeight();
            double d5 = d;
            double d6 = d2;
            if (d6 >= zBounds2.getY() + zBounds2.getHeight() - d4 - 1.0 && d5 < zBounds2.getX() + zBounds2.getWidth() - d3 - 1.0) {
                d6 = zBounds2.getY();
                if ((d5 += zBounds.getWidth()) + d3 > zBounds2.getX() + zBounds2.getWidth()) {
                    d5 = zBounds2.getX() + zBounds2.getWidth() - d3;
                }
            } else if ((d6 += d4 * 0.5) + d4 > zBounds2.getY() + zBounds2.getHeight()) {
                d6 = zBounds2.getY() + zBounds2.getHeight() - d4;
            }
            ZBounds zBounds4 = new ZBounds();
            zBounds4.setRect(d5, d6, d3, d4);
            zBounds.setRect(d, d2, d3, d4);
            if (!zBounds.intersects(d5, d6, d3, d4)) {
                zBounds.add(zBounds4);
                this.center(zBounds, false);
            }
            this.center(zBounds4);
        }
    }
}

