/*
 * Decompiled with CFR 0.152.
 */
import edu.umd.cs.jazz.ZSceneGraphObject;
import edu.umd.cs.jazz.event.ZFilteredEventHandler;
import edu.umd.cs.jazz.event.ZMouseEvent;
import edu.umd.cs.jazz.event.ZMouseFilter;
import edu.umd.cs.jazz.util.ZBounds;
import edu.umd.cs.jazz.util.ZSceneGraphPath;
import java.awt.Point;
import java.awt.geom.Point2D;

class HiResEventHandler
extends ZFilteredEventHandler {
    ImagePane imagePane;
    boolean dragging = false;
    Point pressLocation = null;

    public HiResEventHandler(ImagePane imagePane, ZSceneGraphObject zSceneGraphObject) {
        super(zSceneGraphObject);
        this.imagePane = imagePane;
    }

    public ZMouseFilter getMouseFilter() {
        if (this.fMouseFilter == null) {
            this.fMouseFilter = new ZMouseFilter();
            this.fMouseFilter.setOrMask(28);
        }
        return this.fMouseFilter;
    }

    protected void filteredMousePressed(ZMouseEvent zMouseEvent) {
        this.dragging = false;
        this.pressLocation = zMouseEvent.getPoint();
    }

    protected void filteredMouseDragged(ZMouseEvent zMouseEvent) {
        this.dragging = true;
    }

    public void filteredMouseReleased(ZMouseEvent zMouseEvent) {
        if (this.imagePane.eventHandlers.isInteracting()) {
            return;
        }
        if (this.dragging && this.pressLocation.distance(zMouseEvent.getPoint()) <= 3.0) {
            this.dragging = false;
        }
        if ((zMouseEvent.getModifiers() & 0x10) == 16) {
            ZSceneGraphPath zSceneGraphPath = zMouseEvent.getPath();
            PMImage pMImage = (PMImage)zSceneGraphPath.getObject();
            if (pMImage != null) {
                ImageItem imageItem = pMImage.getImageItem();
                if (!this.imagePane.hiresImageLoaded) {
                    this.imagePane.magnificationPush();
                }
                if (this.imagePane.hiresImageLoaded && imageItem != this.imagePane.hiresImageItem) {
                    this.imagePane.unloadHiResImage();
                }
                if (imageItem != this.imagePane.hiresImageItem) {
                    this.imagePane.showHiResImage(imageItem);
                } else if (imageItem == this.imagePane.hiresImageItem && !this.dragging) {
                    Point2D.Double double_ = new Point2D.Double();
                    ((Point2D)double_).setLocation(zMouseEvent.getX(), zMouseEvent.getY());
                    zSceneGraphPath.screenToGlobal(double_);
                    ZBounds zBounds = this.imagePane.getCamera().getViewBounds();
                    double d = zBounds.getWidth();
                    double d2 = zBounds.getHeight();
                    double d3 = zBounds.getX();
                    double d4 = zBounds.getY();
                    ZBounds zBounds2 = new ZBounds(((Point2D)double_).getX() - d / 4.0, ((Point2D)double_).getY() - d2 / 4.0, d / 2.0, d2 / 2.0);
                    this.imagePane.magnificationPush();
                    this.imagePane.center(zBounds2, false);
                }
            }
        } else if (((zMouseEvent.getModifiers() & 4) != 4 || !this.imagePane.photomesa.state.getRightButtonMenu() && this.imagePane.eventHandlers.getEventMode() != 2) && this.imagePane.hiresImageLoaded) {
            ZBounds zBounds = this.imagePane.hiresImageItem.getThumb().getGlobalBounds();
            ZBounds zBounds3 = this.imagePane.getCamera().getViewBounds();
            double d = this.imagePane.hiresImageItem.imageWidth;
            double d5 = this.imagePane.hiresImageItem.imageHeight;
            double d6 = this.imagePane.getCamera().getBoundsReference().getWidth();
            double d7 = this.imagePane.getCamera().getBoundsReference().getHeight();
            if (zBounds3.getWidth() >= zBounds.getWidth() && zBounds3.getHeight() >= zBounds.getHeight()) {
                this.imagePane.unloadHiResImage();
            }
            this.imagePane.zoomOutStep();
            if (this.imagePane.eventHandlers.getEventMode() != 1) {
                this.imagePane.eventHandlers.panHandler.getMouseFilter().rejectAllEventTypes();
            }
        }
    }
}

