/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util.startup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;
import org.gerhardb.lib.util.startup.AppPreferences;

public class AppPreferencesFactory
implements PreferencesFactory {
    private static AppPreferences myPreferences = new AppPreferences();
    public static final String PROP_FILE_LOOKUP = "jibs.props";
    private static boolean iNeedToBeInitialized = true;

    public AppPreferencesFactory() {
        System.out.println("FilePreferencesFactory Starting Up");
    }

    public Preferences userRoot() {
        return myPreferences;
    }

    public Preferences systemRoot() {
        return myPreferences;
    }

    public static synchronized void initializeProps() throws BackingStoreException {
        if (iNeedToBeInitialized) {
            String propFileName = System.getProperty(PROP_FILE_LOOKUP);
            System.out.println(">>>>>>>>>>>>>>> JibsPreferencesFactory Reading Properties from: " + propFileName);
            File savePropFile = new File(propFileName);
            if (savePropFile != null) {
                if (savePropFile.exists()) {
                    try {
                        BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(savePropFile));
                        Preferences.importPreferences(inStream);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BackingStoreException(ex);
                    }
                } else {
                    System.out.println("!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\nJIBS was unable to read:\n" + propFileName + "\n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
                }
            } else {
                throw new BackingStoreException("BackingStore may not be null");
            }
            iNeedToBeInitialized = false;
        }
    }

    public static synchronized void finalizeProps() throws BackingStoreException {
        System.out.println(">>>>>>>>>> JibsPreferencesFactory Writing Properties");
        String propFileName = System.getProperty(PROP_FILE_LOOKUP);
        System.out.println("JibsPreferencesFactory.finalizeProps().propFileName:" + propFileName);
        if (propFileName != null) {
            File savePropFile = new File(propFileName);
            try {
                BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(savePropFile));
                myPreferences.exportSubtree(outStream);
            }
            catch (Exception ex) {
                throw new BackingStoreException(ex);
            }
        }
    }

    public static void InfoToConsole() {
        System.out.println("------------------------------------------------");
        System.out.println("AppPreferencesFactory.InfoToConsole()");
        System.out.println("java.util.prefs.PreferencesFactory: " + System.getProperty("java.util.prefs.PreferencesFactory"));
        System.out.println("PROP_FILE_LOOKUP: " + System.getProperty(PROP_FILE_LOOKUP));
        Preferences prefsUserRoot = Preferences.userRoot();
        System.out.println("Preferences.userRoot(): " + prefsUserRoot.getClass());
        Preferences pathManagerNode = prefsUserRoot.node("/org/gerhardb/jibs/viewer/PathManager");
        System.out.println("treeDirectory: " + pathManagerNode.get("treeDirectory", "howdy"));
        System.out.println("------------------------------------------------");
    }
}

