/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.ModalProgressDialogFast;

public class ModalProgressDialogFast {
    private Window myTopWindow;
    String myTitle;
    String myMessage;
    String myCancelBtnText;
    BoundedRangeModel myRange;
    Thread myTaskThread;
    boolean iWasDeactivated = false;
    boolean iWasUnistalled = false;
    public static final Icon WAIT_ICON = Icons.icon(23);
    private JDialog myDialog;
    private Date showTime;
    private String finishedSync = "sync";
    boolean iAmFinished = false;
    KeyboardFocusManager myKeyboardFocusManager;
    private final Component mouseBlocker = new JPanel(){
        {
            this.setOpaque(false);
            this.enableEvents(16L);
        }

        protected void processMouseEvent(MouseEvent event) {
            event.consume();
        }
    };
    private final ComponentListener mouseBlockerSynchronizer = new ComponentAdapter(){

        public void componentResized(ComponentEvent event) {
            ModalProgressDialogFast.this.mouseBlocker.setSize(event.getComponent().getSize());
        }
    };
    private final VetoableChangeListener windowFocusPreventer = new VetoableChangeListener(){
        private final Runnable refocuser = new Runnable(){

            public void run() {
                if (ModalProgressDialogFast.this.myDialog != null) {
                    ModalProgressDialogFast.this.myDialog.requestFocus();
                } else {
                    ModalProgressDialogFast.this.myTopWindow.requestFocus();
                }
            }
        };

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            String property = event.getPropertyName();
            if (property.equals("focusedWindow") && event.getNewValue() == ModalProgressDialogFast.this.myTopWindow) {
                EventQueue.invokeLater(this.refocuser);
                String string = ModalProgressDialogFast.this.finishedSync;
                synchronized (string) {
                    if (!ModalProgressDialogFast.this.iAmFinished) {
                        throw new PropertyVetoException("Window may not take focus while it has a modal dialog showing", event);
                    }
                }
            }
        }
    };

    public ModalProgressDialogFast(Window topWindow, String title, String message, String cancelBtnText, BoundedRangeModel range, Runnable runMe) {
        this.myTaskThread = new Thread(runMe);
        this.myTopWindow = topWindow;
        this.myTitle = title;
        this.myMessage = message;
        this.myCancelBtnText = cancelBtnText;
        this.myRange = range;
        this.install();
        this.activate();
        Thread dialogThread = new Thread(){

            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        ModalProgressDialogFast.this.myDialog.setVisible(true);
                        ModalProgressDialogFast.this.showTime = new Date();
                    }
                });
            }
        };
        dialogThread.start();
    }

    public void start() {
        this.myTaskThread.start();
    }

    public void interrupt() {
        if (this.myDialog != null) {
            this.myTaskThread.interrupt();
        }
    }

    public void done() {
        try {
            this.uninstallGlassPane();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.deactivateDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void activate() {
        String string = this.finishedSync;
        synchronized (string) {
            if (this.iAmFinished) {
                return;
            }
        }
        AbstractAction cancelAction = new AbstractAction(UIManager.getString("OptionPane.cancelButtonText")){

            public void actionPerformed(ActionEvent event) {
                ModalProgressDialogFast.this.myTaskThread.interrupt();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.setText(this.myCancelBtnText);
        cancelButton.setDefaultCapable(true);
        String actionID = "cancel";
        cancelButton.getActionMap().put(actionID, cancelAction);
        InputMap inputMap = cancelButton.getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("ESCAPE"), actionID);
        inputMap.put(KeyStroke.getKeyStroke("CANCEL"), actionID);
        inputMap.put(KeyStroke.getKeyStroke("STOP"), actionID);
        JPanel option = new JPanel(new BorderLayout());
        option.add((Component)new JProgressBar(this.myRange), "North");
        option.add((Component)cancelButton, "South");
        JOptionPane optionPane = new JOptionPane(" ", -1, -1, WAIT_ICON, new Object[]{option}, cancelButton);
        optionPane.setMessage(this.myMessage);
        this.myDialog = optionPane.createDialog(this.myTopWindow, this.myTitle);
        this.myDialog.setModal(false);
        this.myDialog.setDefaultCloseOperation(2);
        this.myDialog.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent event) {
                long flags = event.getChangeFlags();
                Component component = event.getComponent();
                if ((flags & 4L) != 0L && !component.isShowing()) {
                    ModalProgressDialogFast.this.myTaskThread.interrupt();
                }
            }
        });
    }

    public synchronized void deactivateDialog() {
        this.iAmFinished = true;
        if (this.iWasDeactivated) {
            return;
        }
        this.iWasDeactivated = true;
        long time = 0L;
        if (this.showTime != null) {
            time = new Date().getTime() - this.showTime.getTime();
        }
        if (time < 1000L) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.myTaskThread.interrupt();
            }
        }
        this.myDialog.setVisible(false);
    }

    public void install() {
        this.myTopWindow.requestFocus();
        this.myKeyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        this.myTopWindow.setCursor(Cursor.getPredefinedCursor(3));
        this.myTopWindow.addComponentListener(this.mouseBlockerSynchronizer);
        if (this.myTopWindow instanceof RootPaneContainer) {
            JLayeredPane l = ((RootPaneContainer)((Object)this.myTopWindow)).getLayeredPane();
            this.mouseBlocker.setSize(l.getSize());
            l.add(this.mouseBlocker, new Integer(Integer.MAX_VALUE));
        } else {
            this.myTopWindow.setEnabled(false);
        }
    }

    public synchronized void uninstallGlassPane() {
        this.iAmFinished = true;
        if (this.iWasUnistalled) {
            return;
        }
        this.iWasUnistalled = true;
        this.myKeyboardFocusManager.removeVetoableChangeListener("focusedWindow", this.windowFocusPreventer);
        this.myTopWindow.removeComponentListener(this.mouseBlockerSynchronizer);
        if (this.myTopWindow instanceof RootPaneContainer) {
            JLayeredPane l = ((RootPaneContainer)((Object)this.myTopWindow)).getLayeredPane();
            l.remove(this.mouseBlocker);
        } else {
            this.myTopWindow.setEnabled(true);
        }
        this.myTopWindow.setCursor(Cursor.getPredefinedCursor(0));
    }

    public static void main(String[] args) {
        final DefaultBoundedRangeModel range = new DefaultBoundedRangeModel();
        range.setMaximum(10);
        JButton hitMe = new JButton("Hit Me!");
        final JLabel wacked = new JLabel("Not Wacked Yet");
        JButton start = new JButton("Start");
        final JLabel countLbl = new JLabel("Inactive at moment");
        JPanelRows contents = new JPanelRows();
        JPanel row = contents.topRow();
        row.add(hitMe);
        row.add(wacked);
        row = contents.nextRow();
        row.add(start);
        row.add(countLbl);
        final JFrame testFrame = new JFrame("File Tree Test");
        testFrame.getContentPane().add(new JScrollPane(contents));
        testFrame.setSize(300, 300);
        testFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        SwingUtils.centerOnScreen(testFrame);
        hitMe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (wacked.getBackground().equals(Color.GREEN)) {
                    wacked.setBackground(Color.RED);
                    wacked.setOpaque(true);
                    wacked.setForeground(Color.YELLOW);
                    wacked.setText("WACKED");
                } else {
                    wacked.setBackground(Color.GREEN);
                    wacked.setOpaque(true);
                    wacked.setForeground(Color.BLUE);
                    wacked.setText("unwacked at moment");
                }
            }
        });
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                class TestMoveIt
                implements Runnable {
                    ModalProgressDialogFast dialog;
                    private final /* synthetic */ JFrame val$testFrame;
                    private final /* synthetic */ BoundedRangeModel val$range;
                    private final /* synthetic */ JLabel val$countLbl;

                    TestMoveIt(JFrame jFrame, BoundedRangeModel boundedRangeModel, JLabel jLabel) {
                        this.val$testFrame = jFrame;
                        this.val$range = boundedRangeModel;
                        this.val$countLbl = jLabel;
                        this.dialog = new ModalProgressDialogFast(this.val$testFrame, "Moving Files", "The files are being moved...", "Stop Move", this.val$range, this);
                    }

                    public void run() {
                        class ShowProgress {
                            private final /* synthetic */ JLabel val$countLbl;

                            ShowProgress(String msg, JLabel jLabel) {
                                this.val$countLbl = jLabel;
                                SwingUtilities.invokeLater(new Runnable(this, msg){
                                    private final /* synthetic */ String val$msg;
                                    private final /* synthetic */ ShowProgress this$0;
                                    {
                                        this.this$0 = showProgress;
                                        this.val$msg = string;
                                    }

                                    public void run() {
                                        ShowProgress.access$700(this.this$0).setText(this.val$msg);
                                    }
                                });
                            }

                            static /* synthetic */ JLabel access$700(ShowProgress x0) {
                                return x0.val$countLbl;
                            }
                        }
                        int length = this.val$range.getMaximum() + 1;
                        for (int i = 0; i < length; ++i) {
                            this.val$range.setValue(i);
                            new ShowProgress("Doing: " + i, this.val$countLbl);
                            try {
                                Thread.sleep(111L);
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                            if (Thread.currentThread().isInterrupted()) break;
                        }
                        new ShowProgress("All Done!", this.val$countLbl);
                        this.dialog.done();
                    }
                }
                new TestMoveIt(testFrame, range, countLbl);
            }
        });
        testFrame.setVisible(true);
    }
}

