/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import com.saic.isd.swing.filechooser.SimpleFileFilter;
import com.saic.isd.util.report.Report;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RepaintManager;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import javax.swing.text.html.HTMLEditorKit;
import org.gerhardb.lib.util.startup.AppStarter;

public class PrintableText
implements Printable {
    JTextComponent myText;

    public PrintableText(JTextComponent text) {
        this.myText = text;
    }

    public int print(Graphics g, PageFormat pform, int pageNumber) {
        View view;
        double pageOffset = (double)pageNumber * pform.getImageableHeight();
        if (pageOffset > (double)(view = this.myText.getUI().getRootView(this.myText)).getPreferredSpan(1)) {
            return 1;
        }
        ((Graphics2D)g).translate(0.0, -pageOffset);
        Rectangle rect = new Rectangle();
        rect.setRect(pform.getImageableX(), pform.getImageableY(), pform.getImageableWidth(), pform.getImageableHeight() + pageOffset);
        view.paint(g, rect);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printContent() {
        System.out.println("00000000000000000000000000000000000");
        PrinterJob pjob = PrinterJob.getPrinterJob();
        RepaintManager.currentManager(this.myText).setDoubleBufferingEnabled(false);
        pjob.setPrintable(this);
        Cursor oldCursor = this.myText.getCursor();
        this.myText.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (pjob.printDialog()) {
                pjob.print();
            }
        }
        catch (PrinterException pe) {
            System.err.println("PrinterException has occurred:" + pe.getMessage());
        }
        finally {
            this.myText.setCursor(oldCursor);
        }
    }

    public void copy() {
        String contents = this.myText.getText();
        StringSelection clip = new StringSelection(contents);
        Clipboard clipboard = this.myText.getToolkit().getSystemClipboard();
        clipboard.setContents(clip, clip);
    }

    public void file() {
        String contents = this.myText.getText();
        JFileChooser chooser = new JFileChooser(PrintableText.getUserHomeDirectory());
        SimpleFileFilter filter = new SimpleFileFilter("html", AppStarter.getString("report"));
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(this.myText);
        if (returnVal == 0) {
            File file = filter.attachExtension(chooser.getSelectedFile());
            try {
                FileWriter stream = new FileWriter(file);
                stream.write(contents);
                stream.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this.myText, ex.getMessage(), AppStarter.getString("save.failed"), 0);
            }
        }
    }

    public static File getUserHomeDirectory() {
        StringBuffer buf = new StringBuffer(80);
        buf.append(System.getProperty("user.home"));
        buf.append(File.separator);
        buf.append("data");
        File rtnMe = new File(buf.toString());
        if (!rtnMe.exists()) {
            rtnMe.mkdirs();
        } else if (rtnMe.isFile()) {
            rtnMe = rtnMe.getParentFile();
        }
        return rtnMe;
    }

    public void previewHTML(Component owner) {
        String title = AppStarter.getString("print.preview");
        if (owner instanceof Frame) {
            PrintableText.preview(new JDialog((Frame)owner, title, false), this.myText.getText(), new HTMLEditorKit());
        } else if (owner instanceof Dialog) {
            PrintableText.preview(new JDialog((Dialog)owner, title, false), this.myText.getText(), new HTMLEditorKit());
        } else {
            PrintableText.preview(new JDialog((Dialog)null, title, false), this.myText.getText(), new HTMLEditorKit());
        }
    }

    public static void preview(JDialog dialog, String printMe, EditorKit kit) {
        final JDialog previewDlg = dialog;
        JEditorPane pane = new JEditorPane();
        pane.setEditorKit(kit);
        pane.setText(printMe);
        pane.validate();
        pane.setEditable(false);
        final String prtThis = printMe;
        final EditorKit theKit = kit;
        JButton okBtn = new JButton(AppStarter.getString("print"));
        okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PrintableText.print(prtThis, theKit);
            }
        });
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                previewDlg.dispose();
            }
        });
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        Container contentPane = previewDlg.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JScrollPane(pane), "Center");
        contentPane.add((Component)btnPanel, "South");
        previewDlg.setSize(800, 600);
        previewDlg.setVisible(true);
    }

    public static void print(String printMe, EditorKit kit) {
        JEditorPane pane = new JEditorPane();
        pane.setEditorKit(kit);
        pane.setText(printMe);
        pane.validate();
        PrintableText pt = new PrintableText(pane);
        pt.printContent();
    }

    public static void main(String[] args) {
        Report.showReport("Test PrintableText", "Sample Report", "Hello World!");
    }
}

