/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import javax.swing.JPanel;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.print.PreviewablePage;

class PreviewPanel
extends JPanel {
    public PreviewPanel(PreviewablePage page) {
        super.setBackground(Color.LIGHT_GRAY);
        super.setLayout(new PreviewLayout(page));
        super.add(page);
    }

    class PreviewLayout
    implements LayoutManager {
        PreviewablePage myPreviewablePage;

        PreviewLayout(PreviewablePage page) {
            this.myPreviewablePage = page;
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void layoutContainer(Container parent) {
            int availableWidth = parent.getWidth();
            int availableHeight = parent.getHeight();
            PageFormat pf = this.myPreviewablePage.getCurrentPageFormat();
            float theta = ImageChangeUtil.calcTheta((int)pf.getWidth(), (int)pf.getHeight(), availableWidth, availableHeight);
            double shrunkWidth = pf.getWidth() * (double)theta;
            double shrunkHeight = pf.getHeight() * (double)theta;
            int x = (int)(((double)availableWidth - shrunkWidth) / 2.0);
            int y = (int)(((double)availableHeight - shrunkHeight) / 2.0);
            this.myPreviewablePage.setBounds(x, y, (int)shrunkWidth, (int)shrunkHeight);
            if (pf.getOrientation() == 0) {
                Paper shrunkenPaper = new Paper();
                shrunkenPaper.setSize(shrunkHeight, shrunkWidth);
                double shrunkX = pf.getImageableX() * (double)theta;
                double shrunkY = pf.getImageableY() * (double)theta;
                double imageWidth = pf.getImageableWidth() * (double)theta;
                double imageHeight = pf.getImageableHeight() * (double)theta;
                shrunkenPaper.setImageableArea(shrunkY, shrunkX, imageHeight, imageWidth);
                PageFormat shrunkenPageFormat = new PageFormat();
                shrunkenPageFormat.setPaper(shrunkenPaper);
                shrunkenPageFormat.setOrientation(pf.getOrientation());
                this.myPreviewablePage.myShrunkenPageFormat = shrunkenPageFormat;
            } else {
                Paper shrunkenPaper = new Paper();
                shrunkenPaper.setSize(shrunkWidth, shrunkHeight);
                double shrunkX = pf.getImageableX() * (double)theta;
                double shrunkY = pf.getImageableY() * (double)theta;
                double imageWidth = pf.getImageableWidth() * (double)theta;
                double imageHeight = pf.getImageableHeight() * (double)theta;
                shrunkenPaper.setImageableArea(shrunkX, shrunkY, imageWidth, imageHeight);
                PageFormat shrunkenPageFormat = new PageFormat();
                shrunkenPageFormat.setPaper(shrunkenPaper);
                shrunkenPageFormat.setOrientation(pf.getOrientation());
                this.myPreviewablePage.myShrunkenPageFormat = shrunkenPageFormat;
            }
            this.myPreviewablePage.repaint();
        }

        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(100, 100);
        }

        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(500, 500);
        }

        public void removeLayoutComponent(Component comp) {
        }
    }
}

