/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.playlist;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import org.gerhardb.lib.dirtree.filelist.FileListSelectionModel;
import org.gerhardb.lib.playlist.KeypadOps;
import org.gerhardb.lib.playlist.Scroller;

public class ScrollerKeyListener
implements KeyListener {
    KeypadOps myKeypadOps = null;
    StringBuffer myNumberJumpBuffer = new StringBuffer(12);
    boolean iAmCollectingNumbers = false;
    boolean iAmCollectingNegativeNumbers = false;
    private Scroller myScroller;
    private FileListSelectionModel mySelectionModel;
    private boolean iAmSelecting = false;
    private boolean iAmDeselecting = false;
    private boolean iMadeASelection = false;
    private int anchorIndexForCtrlS = -1;

    ScrollerKeyListener(Scroller scroller) {
        this.myScroller = scroller;
    }

    public void setKeypadOps(KeypadOps kpo) {
        this.myKeypadOps = kpo;
    }

    public void setListSelectionModel(FileListSelectionModel sm) {
        this.mySelectionModel = sm;
    }

    public void keyPressed(KeyEvent event) {
        if (event.isConsumed()) {
            return;
        }
        switch (event.getKeyCode()) {
            case 17: {
                this.iAmCollectingNumbers = true;
                return;
            }
            case 18: {
                this.iAmCollectingNumbers = true;
                this.iAmCollectingNegativeNumbers = true;
                return;
            }
            case 83: {
                if (!(event.isControlDown() || event.isAltDown() || event.isMetaDown())) {
                    this.iAmSelecting = true;
                    this.iAmDeselecting = false;
                    this.iMadeASelection = false;
                    this.anchorIndexForCtrlS = this.myScroller.getValueZeroBased();
                    break;
                }
                return;
            }
            case 68: {
                if (!(event.isControlDown() || event.isAltDown() || event.isMetaDown())) {
                    this.iAmDeselecting = true;
                    this.iAmSelecting = false;
                    this.iMadeASelection = false;
                    this.anchorIndexForCtrlS = this.myScroller.getValueZeroBased();
                    break;
                }
                return;
            }
        }
    }

    public void keyReleased(KeyEvent event) {
        if (event.isConsumed()) {
            return;
        }
        if (this.myScroller.myShowViewKeyListener != null) {
            this.myScroller.myShowViewKeyListener.keyReleased(event);
            if (event.isConsumed()) {
                return;
            }
        }
        if (this.iAmCollectingNumbers) {
            if (this.iAmCollectingNegativeNumbers) {
                switch (event.getKeyCode()) {
                    case 45: {
                        if (this.myNumberJumpBuffer.length() != 0) break;
                        this.myNumberJumpBuffer.append("-");
                        break;
                    }
                    case 109: {
                        if (this.myNumberJumpBuffer.length() != 0) break;
                        this.myNumberJumpBuffer.append("-");
                    }
                }
            }
            switch (event.getKeyCode()) {
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: {
                    this.myNumberJumpBuffer.append(KeyEvent.getKeyText(event.getKeyCode() - 48));
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.myNumberJumpBuffer.append(KeyEvent.getKeyText(event.getKeyCode()));
                    return;
                }
            }
        }
        switch (event.getKeyCode()) {
            case 34: {
                this.myScroller.pageDown();
                this.updateSelectionInterval();
                break;
            }
            case 33: {
                this.myScroller.pageUp();
                this.updateSelectionInterval();
                break;
            }
            case 36: {
                this.myScroller.home();
                this.updateSelectionInterval();
                break;
            }
            case 35: {
                this.myScroller.end();
                this.updateSelectionInterval();
                break;
            }
            case 37: 
            case 38: {
                this.myScroller.up();
                this.updateSelectionInterval();
                break;
            }
            case 39: 
            case 40: {
                this.myScroller.down();
                this.updateSelectionInterval();
                break;
            }
            case 32: {
                if (event.isControlDown()) {
                    this.myScroller.up();
                    this.updateSelectionInterval();
                    break;
                }
                this.myScroller.down();
                this.updateSelectionInterval();
                break;
            }
            case 10: {
                break;
            }
            case 127: {
                if (this.myKeypadOps.isFullScreen()) {
                    this.myKeypadOps.clickTrash();
                    break;
                }
            }
            case 155: {
                if (!this.myKeypadOps.isFullScreen()) break;
                if (event.isControlDown()) {
                    this.myKeypadOps.clickPark();
                    break;
                }
                if (event.isShiftDown() || event.isAltDown()) break;
                this.myKeypadOps.clickRepeat();
                break;
            }
            case 77: {
                if (event.isControlDown()) {
                    this.myKeypadOps.clickDirectoryList();
                    break;
                }
            }
            case 83: {
                if (!this.iMadeASelection) {
                    this.updateSelectionInterval();
                }
                this.iAmSelecting = false;
                break;
            }
            case 68: {
                if (!this.iMadeASelection) {
                    this.updateSelectionInterval();
                }
                this.iAmDeselecting = false;
                break;
            }
            case 106: {
                this.myScroller.jumpTo(this.myScroller.myIndex + 10);
                break;
            }
            case 111: {
                this.myScroller.jumpTo(this.myScroller.myIndex - 10);
                break;
            }
            case 109: {
                if (event.isAltDown()) break;
                this.myScroller.up();
                break;
            }
            case 107: {
                if (event.isAltDown()) break;
                this.myScroller.down();
                break;
            }
            case 99: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myScroller.pageDown();
                break;
            }
            case 105: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myScroller.pageUp();
                break;
            }
            case 103: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myScroller.home();
                break;
            }
            case 97: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myScroller.end();
                break;
            }
            case 100: 
            case 104: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myScroller.up();
                break;
            }
            case 98: 
            case 102: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myScroller.down();
                break;
            }
            case 224: 
            case 226: {
                this.myScroller.up();
                break;
            }
            case 225: 
            case 227: {
                this.myScroller.down();
                break;
            }
            case 96: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myKeypadOps.clickPark();
                break;
            }
            case 110: {
                if (event.isAltDown() || event.isControlDown()) break;
                this.myKeypadOps.clickTrash();
                break;
            }
            case 17: {
                if (this.myNumberJumpBuffer.length() > 0) {
                    String number = this.myNumberJumpBuffer.toString();
                    try {
                        int jumpTo = Integer.parseInt(number);
                        this.myScroller.jumpTo(jumpTo - 1);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.myNumberJumpBuffer = new StringBuffer(12);
                }
                this.iAmCollectingNumbers = false;
                break;
            }
            case 18: {
                if (this.myNumberJumpBuffer.length() > 0) {
                    String number = this.myNumberJumpBuffer.toString();
                    try {
                        int jumpBy = Integer.parseInt(number);
                        this.myScroller.jumpTo(this.myScroller.myIndex + jumpBy);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    this.myNumberJumpBuffer = new StringBuffer(12);
                }
                this.iAmCollectingNumbers = false;
                this.iAmCollectingNegativeNumbers = false;
                break;
            }
        }
        event.consume();
    }

    public void keyTyped(KeyEvent event) {
    }

    void updateSelectionInterval() {
        if (this.iAmSelecting) {
            this.iMadeASelection = true;
            int curItem = this.myScroller.getValueZeroBased();
            this.mySelectionModel.addSelectionInterval(this.anchorIndexForCtrlS, curItem);
        } else if (this.iAmDeselecting) {
            this.iMadeASelection = true;
            int curItem = this.myScroller.getValueZeroBased();
            this.mySelectionModel.removeSelectionInterval(this.anchorIndexForCtrlS, curItem);
        }
    }
}

