/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.tree.TreeNode;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.IScrollDirTree;
import org.gerhardb.lib.dirtree.IUndo;
import org.gerhardb.lib.dirtree.rdp.DirectoryListPopup;
import org.gerhardb.lib.dirtree.rdp.MoveManager;
import org.gerhardb.lib.dirtree.rdp.PathManager;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.dirtree.rdp.TreeManager;
import org.gerhardb.lib.playlist.KeypadOps;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.Misc;
import org.gerhardb.lib.util.ModalProgressDialogFlex;
import org.gerhardb.lib.util.startup.ActiveActions;
import org.gerhardb.lib.util.startup.AppStarter;

public class RDPmanager
implements KeypadOps {
    Preferences myPrefs;
    private static final String DIRECTORY_LIST_KEY = "DIRECTORY_LIST_KEY";
    private static final int waitTime = 0;
    private static final boolean updateRepeateButtonBecauseDeleteOrParkNotPressed = true;
    private static final boolean doNotUpdateRepeateButton = false;
    DirectoryTreeNode myRepeatNode = null;
    DirectoryTreeNode myDeleteNode = null;
    DirectoryTreeNode myParkNode = null;
    File myDeleteFile = new File("");
    File myParkFile = new File("");
    File myRepeatFile = new File("");
    String myDeleteDirAsString;
    String myParkDirAsString;
    String myRepeatDirAsString;
    JButton myRepeatBtn;
    JButton myDeleteBtn;
    JButton myParkBtn;
    JButton myDirectoryListBtn;
    MoveManager myMoveManager;
    ArrayList myDirectoryList = new ArrayList(30);
    RDPplugins myPlugins;
    IUndo myIUndo;
    IScrollDirTree myIScrollDirTree;
    TreeManager myTreeManager;

    public RDPmanager(RDPplugins ss, IUndo iu, IScrollDirTree is, String appStartID) {
        this.myPlugins = ss;
        this.myIUndo = iu;
        this.myIScrollDirTree = is;
        this.myPrefs = Preferences.userRoot().node("/" + appStartID + "/org/gerhardb/jibs/viewer/frame/RDPmanager");
        this.myMoveManager = new MoveManager(this);
        try {
            byte[] byteArray = null;
            byteArray = this.myPrefs.getByteArray(DIRECTORY_LIST_KEY, byteArray);
            Object object = Misc.toObject(byteArray);
            if (object != null && object instanceof ArrayList) {
                this.myDirectoryList = (ArrayList)object;
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public String getAppIDandTargetType() {
        return this.myTreeManager.myCoordinator.myLSTplugins.getAppIDandTargetType();
    }

    public void addActions(ActiveActions aa) {
        this.myDeleteBtn = this.makeDeleteButton(aa);
        this.myParkBtn = this.makeParkButton(aa);
        this.myRepeatBtn = this.makeRepeatButton(aa);
        this.myDirectoryListBtn = this.makeDirectoryListButton(aa);
        this.myMoveManager.addActions(aa);
    }

    public RDPplugins getRDPplugins() {
        return this.myPlugins;
    }

    public IUndo getIUndo() {
        return this.myIUndo;
    }

    public IScrollDirTree getIScrollDirTree() {
        return this.myIScrollDirTree;
    }

    public void showStats(DirectoryTreeNode node, boolean countImageFilesInNodes) {
        this.myPlugins.showStats(node, countImageFilesInNodes);
    }

    public void clickPark() {
        this.myParkBtn.doClick(0);
    }

    public void clickTrash() {
        this.myDeleteBtn.doClick(0);
    }

    public void clickRepeat() {
        this.myRepeatBtn.doClick(0);
    }

    public void clickDirectoryList() {
        if (this.isFullScreen()) {
            new DirectoryListPopup((Frame)this.myPlugins.getTopFrame(), this, this.myPlugins.getExtendedDirectoryTree());
        } else {
            this.myDirectoryListBtn.doClick(0);
        }
    }

    public boolean isFullScreen() {
        return this.myPlugins.isFullScreen();
    }

    public void setWaitCursor(boolean b) {
        this.myPlugins.setWaitCursor(b);
    }

    public MoveManager getMoveManager() {
        return this.myMoveManager;
    }

    public void updateDirNameIfNeeded(String oldName, String newName, DirectoryTreeNode node) {
        File oldFileName = new File(oldName);
        if (this.myRepeatFile != null && this.myRepeatFile.equals(oldFileName)) {
            this.setRepeatDir(node);
        }
        if (this.myDeleteFile != null && this.myDeleteFile.equals(oldFileName)) {
            PathManager.checkDirectory(newName, this.myPlugins.getTopFrame());
            this.loadParkAndDeleteNodes();
        }
        if (this.myParkFile != null && this.myParkFile.equals(oldFileName)) {
            this.myPlugins.getPathManager().setDirectory(2, newName);
            this.loadParkAndDeleteNodes();
        }
    }

    public boolean isParkActive() {
        return this.myParkNode != null;
    }

    public boolean isDeleteActive() {
        return this.myDeleteNode != null;
    }

    public void movePressed() {
        Object[] filesPicked = this.myIScrollDirTree.getFileList().getSelectedValues();
        int confirmation = this.myMoveManager.confirmMove(AppStarter.getString("RDPmanager.3"), this.myParkNode, this.myParkDirAsString, filesPicked);
        switch (confirmation) {
            case 0: {
                return;
            }
            case 1: {
                if (this.myParkNode != null) {
                    this.myMoveManager.moveCurrentFile(this.myParkNode);
                } else if (this.myParkDirAsString != null) {
                    this.myMoveManager.moveCurrentFile(this.myParkFile);
                }
                return;
            }
            case 2: {
                this.myMoveManager.moveOrCopySeveral(true, this.myParkNode, this.myParkDirAsString, filesPicked, true);
                return;
            }
        }
    }

    public void setRepeatDir(DirectoryTreeNode dirNode) {
        if (dirNode != null && this.myRepeatNode != dirNode) {
            this.myRepeatNode = dirNode;
            this.myRepeatDirAsString = this.myRepeatNode.getAbsolutePath();
            this.myRepeatFile = new File(this.myRepeatDirAsString);
            this.myRepeatBtn.getAction().setEnabled(true);
            this.myRepeatBtn.getAction().putValue("ShortDescription", "<html>" + AppStarter.getString("SortScreen.menu.file.repeat.moved") + "<br>" + this.myRepeatDirAsString + "</html>");
        }
    }

    public void loadParkAndDeleteNodes() {
        this.myDeleteDirAsString = null;
        this.myDeleteFile = null;
        this.myDeleteNode = null;
        this.myDeleteDirAsString = this.myPlugins.getPathManager().getDirectoryAbsolute(1);
        if (this.myDeleteDirAsString == null) {
            this.myDeleteBtn.getAction().setEnabled(false);
            this.myDeleteBtn.getAction().putValue("ShortDescription", AppStarter.getString("SortScreen.menu.file.trash.tip"));
        } else {
            this.myDeleteFile = new File(this.myDeleteDirAsString);
            this.myDeleteBtn.getAction().setEnabled(true);
            this.myDeleteBtn.getAction().putValue("ShortDescription", "<html>" + AppStarter.getString("SortScreen.menu.file.trash.tip") + "<br>" + this.myDeleteDirAsString + "</html>");
        }
        this.myParkDirAsString = null;
        this.myParkFile = null;
        this.myParkNode = null;
        this.myParkDirAsString = this.myPlugins.getPathManager().getDirectoryAbsolute(2);
        if (this.myParkDirAsString == null) {
            this.myParkBtn.getAction().setEnabled(false);
            this.myParkBtn.getAction().putValue("ShortDescription", AppStarter.getString("SortScreen.menu.file.park.tip"));
        } else {
            this.myParkFile = new File(this.myParkDirAsString);
            this.myParkBtn.getAction().setEnabled(true);
            this.myParkBtn.getAction().putValue("ShortDescription", "<html>" + AppStarter.getString("SortScreen.menu.file.park.tip") + "<br>" + this.myParkDirAsString + "</html>");
        }
        this.rescan();
    }

    public void rescan() {
        this.myDeleteNode = null;
        this.myParkNode = null;
        this.myRepeatNode = null;
        DirectoryTreeNode root = this.myTreeManager.myRootNode;
        if (root == null) {
            System.out.println(">>>>>>>>................>>>>>>>>>>>>>> RDPManager.rescan() got a null!!!  FIX ME!!!");
            return;
        }
        this.scanADirectory(root);
        Enumeration<TreeNode> breadth = root.breadthFirstEnumeration();
        while (breadth.hasMoreElements()) {
            TreeNode obj = breadth.nextElement();
            DirectoryTreeNode node = (DirectoryTreeNode)obj;
            this.scanADirectory(node);
            if (this.myDeleteNode == null || this.myParkNode == null || this.myRepeatNode == null) continue;
            break;
        }
    }

    public void addToRememberedMoveList(DirectoryTreeNode toDirNode) {
        if (toDirNode == null) {
            return;
        }
        String toDirPath = toDirNode.getAbsolutePath();
        this.addDirectoryToList(toDirPath);
    }

    public void addDirectoryToList(String toDirPath) {
        File toDir = new File(toDirPath);
        if (!toDir.exists() || toDir.isFile()) {
            return;
        }
        int index = this.myDirectoryList.indexOf(toDir);
        if (index > -1) {
            this.myDirectoryList.remove(index);
        }
        this.myDirectoryList.add(0, toDir);
        this.flushList(false);
    }

    public void addButtonsToToolbar(JToolBar toolbar) {
        toolbar.add(this.myDeleteBtn);
        toolbar.add(this.myParkBtn);
        toolbar.add(this.myRepeatBtn);
        toolbar.add(this.myDirectoryListBtn);
    }

    public void deletePressed() {
        Object[] filesPicked = this.myIScrollDirTree.getFileList().getSelectedValues();
        int confirmation = this.myMoveManager.confirmMove(AppStarter.getString("RDPmanager.19"), this.myDeleteNode, this.myDeleteDirAsString, filesPicked);
        switch (confirmation) {
            case 0: {
                return;
            }
            case 1: {
                if (this.myDeleteNode != null) {
                    this.myMoveManager.moveCurrentFile(this.myDeleteNode);
                } else if (this.myDeleteDirAsString != null) {
                    this.myMoveManager.moveCurrentFile(this.myDeleteFile);
                }
                return;
            }
            case 2: {
                this.myMoveManager.moveOrCopySeveral(true, this.myDeleteNode, this.myDeleteDirAsString, filesPicked, false);
                return;
            }
        }
    }

    public void repeatPressed() {
        Object[] filesPicked = this.myIScrollDirTree.getFileList().getSelectedValues();
        int confirmation = this.myMoveManager.confirmMove(AppStarter.getString("RDPmanager.21"), this.myRepeatNode, this.myRepeatDirAsString, filesPicked);
        switch (confirmation) {
            case 0: {
                return;
            }
            case 1: {
                if (this.myRepeatNode != null) {
                    this.myMoveManager.moveCurrentFile(this.myRepeatNode);
                } else if (this.myRepeatDirAsString != null) {
                    this.myMoveManager.moveCurrentFile(this.myRepeatFile);
                }
                return;
            }
            case 2: {
                this.myMoveManager.moveOrCopySeveral(true, this.myRepeatNode, this.myRepeatDirAsString, filesPicked, false);
                return;
            }
        }
    }

    public void directoryListPressed() {
        new DirectoryListPopup((Frame)this.myPlugins.getTopFrame(), this, this.myPlugins.getExtendedDirectoryTree());
    }

    public void emptyTrash() {
        if (this.myDeleteDirAsString == null) {
            return;
        }
        File deleteDir = new File(this.myDeleteDirAsString);
        if (!deleteDir.isDirectory()) {
            return;
        }
        File[] delList = deleteDir.listFiles();
        if (delList != null) {
            DefaultBoundedRangeModel range = new DefaultBoundedRangeModel();
            EmptyTrash doIt = new EmptyTrash(delList, range);
            ModalProgressDialogFlex.popUp(this.myPlugins.getTopFrame(), AppStarter.getString("RDPmanager.23"), delList.length + " " + AppStarter.getString("RDPmanager.24"), AppStarter.getString("RDPmanager.25"), range, doIt, 750L);
        }
    }

    public void moveFilesToDirectory(Object obj, DirectoryTree tree) {
        DirectoryTreeNode node;
        if (obj == null || !(obj instanceof File)) {
            System.out.println("moveFilesToDirectory got a non file");
            return;
        }
        File toDirectory = (File)obj;
        if (!toDirectory.isDirectory()) {
            System.out.println("moveFilesToDirectory got a non directory file");
            return;
        }
        Object[] filesPicked = this.myIScrollDirTree.getFileList().getSelectedValues();
        if (tree != null && (node = tree.findANode(toDirectory)) != null) {
            if (filesPicked.length > 0) {
                this.myMoveManager.moveOrCopySeveral(true, node, toDirectory.getAbsolutePath(), filesPicked, true);
            } else {
                this.myMoveManager.moveCurrentFile(node);
            }
            this.addToRememberedMoveList(node);
            return;
        }
        if (filesPicked.length > 0) {
            this.myMoveManager.moveOrCopySeveral(true, null, toDirectory.getAbsolutePath(), filesPicked, false);
        } else {
            this.myMoveManager.moveCurrentFile(toDirectory);
        }
        this.addDirectoryToList(toDirectory.toString());
    }

    public void flushList(boolean clearListFirst) {
        if (clearListFirst) {
            this.myDirectoryList = new ArrayList(20);
        }
        try {
            this.myPrefs.putByteArray(DIRECTORY_LIST_KEY, Misc.toByteArray(this.myDirectoryList));
            this.myPrefs.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void scanADirectory(DirectoryTreeNode node) {
        File nodeFile = node.getFile();
        if (nodeFile != null) {
            if (this.myDeleteNode == null && nodeFile.equals(this.myDeleteFile)) {
                this.myDeleteNode = node;
            }
            if (this.myParkNode == null && nodeFile.equals(this.myParkFile)) {
                this.myParkNode = node;
            }
            if (this.myRepeatNode == null && nodeFile.equals(this.myRepeatFile)) {
                this.myRepeatNode = node;
            }
        }
    }

    public JButton makeRepeatButton(ActiveActions aa) {
        Action menuAction = aa.getAction("file", "repeat");
        RepeatToolbarAction toolbarAction = new RepeatToolbarAction();
        toolbarAction.putValue("Name", menuAction.getValue("Name"));
        toolbarAction.putValue("ShortDescription", menuAction.getValue("ShortDescription"));
        return ActiveActions.makeToolBarButton(toolbarAction);
    }

    public JButton makeParkButton(ActiveActions aa) {
        Action menuAction = aa.getAction("file", "park");
        ParkToolbarAction toolbarAction = new ParkToolbarAction();
        toolbarAction.putValue("Name", menuAction.getValue("Name"));
        toolbarAction.putValue("ShortDescription", menuAction.getValue("ShortDescription"));
        return ActiveActions.makeToolBarButton(toolbarAction);
    }

    public JButton makeDeleteButton(ActiveActions aa) {
        Action menuAction = aa.getAction("file", "trash");
        DeleteToolbarAction toolbarAction = new DeleteToolbarAction();
        toolbarAction.putValue("Name", menuAction.getValue("Name"));
        toolbarAction.putValue("ShortDescription", menuAction.getValue("ShortDescription"));
        return ActiveActions.makeToolBarButton(toolbarAction);
    }

    public JButton makeDirectoryListButton(ActiveActions aa) {
        Action menuAction = aa.getAction("file", "directoryList");
        DirectoryListToolbarAction toolbarAction = new DirectoryListToolbarAction();
        toolbarAction.putValue("Name", menuAction.getValue("Name"));
        toolbarAction.putValue("ShortDescription", menuAction.getValue("ShortDescription"));
        return ActiveActions.makeToolBarButton(toolbarAction);
    }

    class EmptyTrash
    implements Runnable {
        File[] myDelList;
        BoundedRangeModel myRange;

        private EmptyTrash(File[] delList, BoundedRangeModel range) {
            this.myDelList = delList;
            this.myRange = range;
        }

        public void run() {
            this.myRange.setMaximum(this.myDelList.length);
            for (int i = 0; i < this.myDelList.length; ++i) {
                try {
                    this.myDelList[i].delete();
                    this.myRange.setValue(i);
                    continue;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(RDPmanager.this.myPlugins.getTopFrame(), AppStarter.getString("RDPmanager.26") + this.myDelList[i] + "\n" + ex.getMessage(), AppStarter.getString("RDPmanager.28"), 2);
                }
            }
            if (RDPmanager.this.myDeleteNode != null) {
                RDPmanager.this.myDeleteNode.recount();
                RDPmanager.this.myPlugins.getExtendedDirectoryTree().treeDidChange();
                RDPmanager.this.myPlugins.reloadScroller();
            }
        }
    }

    class DirectoryListToolbarAction
    extends AbstractAction {
        DirectoryListToolbarAction() {
            super(null, Icons.icon(29));
        }

        public void actionPerformed(ActionEvent ae) {
            RDPmanager.this.directoryListPressed();
        }
    }

    class RepeatToolbarAction
    extends AbstractAction {
        RepeatToolbarAction() {
            super(null, Icons.icon(15));
        }

        public void actionPerformed(ActionEvent ae) {
            RDPmanager.this.repeatPressed();
        }
    }

    class ParkToolbarAction
    extends AbstractAction {
        ParkToolbarAction() {
            super(null, Icons.icon(14));
        }

        public void actionPerformed(ActionEvent ae) {
            RDPmanager.this.movePressed();
        }
    }

    class DeleteToolbarAction
    extends AbstractAction {
        DeleteToolbarAction() {
            super(null, Icons.icon(3));
        }

        public void actionPerformed(ActionEvent ae) {
            RDPmanager.this.deletePressed();
        }
    }
}

