/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree.rdp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.rdp.RDPmanager;
import org.gerhardb.lib.io.DirectoriesOnlyFileFilter;

public class DirectoryListPanel
extends JPanel {
    String RECENT = "recent";
    RDPmanager myRDP;
    DefaultListModel myFiles = new DefaultListModel();
    JList myFileList = new JList(this.myFiles);
    JButton myMoveBtn = new JButton("Move Files");
    Window myParentWindow;
    DirectoryTree myTree;
    JRadioButton myAlphaBtn = new JRadioButton("Alphabetic");
    JRadioButton myRecentBtn = new JRadioButton("Most Recent");

    public DirectoryListPanel(Window window, RDPmanager rdp, DirectoryTree tree) {
        super(new BorderLayout());
        this.myParentWindow = window;
        this.myRDP = rdp;
        this.myTree = tree;
        boolean recent = this.myRDP.myPrefs.getBoolean(this.RECENT, true);
        this.populateList(recent);
        if (recent) {
            this.myRecentBtn.setSelected(true);
        } else {
            this.myAlphaBtn.setSelected(true);
        }
        this.myFileList.setSelectionMode(0);
        this.layoutComponents();
    }

    public JButton getDefaultButton() {
        return this.myMoveBtn;
    }

    private void populateList(boolean recent) {
        Iterator<Object> loop = null;
        if (recent) {
            loop = this.myRDP.myDirectoryList.iterator();
        } else {
            Object[] theList = this.myRDP.myDirectoryList.toArray();
            Arrays.sort(theList);
            loop = Arrays.asList(theList).iterator();
        }
        while (loop.hasNext()) {
            this.myFiles.addElement(loop.next());
        }
        this.myMoveBtn.setEnabled(false);
        if (this.myFiles.size() > 0) {
            this.myFileList.setSelectedIndex(0);
            this.myMoveBtn.setEnabled(true);
        }
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 300));
        this.myMoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Object obj = DirectoryListPanel.this.myFiles.get(DirectoryListPanel.this.myFileList.getSelectedIndex());
                if (obj instanceof File) {
                    File dirToMove = (File)obj;
                    DirectoryListPanel.this.myRDP.moveFilesToDirectory(dirToMove, DirectoryListPanel.this.myTree);
                    DirectoryListPanel.this.myParentWindow.dispose();
                }
            }
        });
        this.myMoveBtn.setMnemonic(77);
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoryListPanel.this.myParentWindow.dispose();
            }
        });
        JButton browseBtn = new JButton("Browse");
        browseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                String defaultDir;
                String dir;
                if (DirectoryListPanel.this.myFiles.size() > 0) {
                    DirectoryListPanel.this.myFiles.firstElement();
                }
                if ((dir = DirectoriesOnlyFileFilter.lookupDir("Select a directory", (defaultDir = DirectoryListPanel.this.myRDP.getRDPplugins().getPathManager().getDirectoryAbsolute(0)).toString(), DirectoryListPanel.this)) != null) {
                    DirectoryListPanel.this.myRDP.addDirectoryToList(dir);
                    DirectoryListPanel.this.myFiles.clear();
                    DirectoryListPanel.this.populateList(DirectoryListPanel.this.myRecentBtn.isSelected());
                    int index = DirectoryListPanel.this.myFiles.indexOf(new File(dir));
                    DirectoryListPanel.this.myFileList.setSelectedIndex(index);
                }
            }
        });
        JButton clearBtn = new JButton("Clear");
        clearBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoryListPanel.this.myFiles.clear();
                DirectoryListPanel.this.myRDP.flushList(true);
                DirectoryListPanel.this.myMoveBtn.setEnabled(false);
            }
        });
        this.myAlphaBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoryListPanel.this.myRDP.myPrefs.putBoolean(DirectoryListPanel.this.RECENT, false);
                try {
                    DirectoryListPanel.this.myRDP.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                DirectoryListPanel.this.myFiles.clear();
                DirectoryListPanel.this.populateList(false);
            }
        });
        this.myRecentBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DirectoryListPanel.this.myRDP.myPrefs.putBoolean(DirectoryListPanel.this.RECENT, true);
                try {
                    DirectoryListPanel.this.myRDP.myPrefs.flush();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                DirectoryListPanel.this.myFiles.clear();
                DirectoryListPanel.this.populateList(true);
            }
        });
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.myRecentBtn);
        btnGroup.add(this.myAlphaBtn);
        JPanel topRight = new JPanel(new FlowLayout());
        topRight.add(browseBtn);
        topRight.add(clearBtn);
        JPanel topLeft = new JPanel(new FlowLayout());
        topLeft.add(this.myRecentBtn);
        topLeft.add(this.myAlphaBtn);
        JPanel top = new JPanel(new BorderLayout());
        top.add((Component)topRight, "West");
        top.add((Component)topLeft, "East");
        JScrollPane middle = new JScrollPane(this.myFileList);
        JPanel bottom = new JPanel();
        bottom.add(this.myMoveBtn);
        bottom.add(cancelBtn);
        super.add((Component)top, "North");
        super.add((Component)middle, "Center");
        super.add((Component)bottom, "South");
    }
}

