/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.lib.dirtree;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.dirtree.ExtendedDirectoryTree;
import org.gerhardb.lib.util.startup.AppStarter;

public class ExtendedDirectoryTreePopUp
extends JPopupMenu {
    protected ExtendedDirectoryTree myTree = null;
    protected TreePath myTreePath = null;
    protected DirectoryTreeNode myDirectoryNode = null;
    protected boolean iCountImageFilesInNodes;

    public ExtendedDirectoryTreePopUp(ExtendedDirectoryTree dirTree, TreePath path, boolean countImageFilesInNodes) {
        File[] kids;
        this.myTree = dirTree;
        this.myTreePath = path;
        this.iCountImageFilesInNodes = countImageFilesInNodes;
        Object[] selPath = this.myTreePath.getPath();
        Object node = selPath[selPath.length - 1];
        if (node instanceof DirectoryTreeNode) {
            this.myDirectoryNode = (DirectoryTreeNode)node;
        }
        JPanel center = new JPanel(new FlowLayout(1));
        if (this.myDirectoryNode == null) {
            center.add((Component)new JLabel(AppStarter.getString("FileTreePopUp.0")), 0);
        } else {
            center.add((Component)new JLabel(this.myDirectoryNode.getName()), 0);
        }
        this.insert(center, 0);
        this.addSeparator();
        JMenuItem showOneDirectoryItem = this.add(AppStarter.getString("FileTreePopUp.1"));
        JMenuItem showTree = this.add(AppStarter.getString("FileTreePopUp.2"));
        JMenuItem showSelectedDirectories = this.add(AppStarter.getString("FileTreePopUp.3"));
        JMenuItem showNonImageFiles = this.add(AppStarter.getString("FileTreePopUp.12"));
        JMenuItem showTreeStats = this.add(AppStarter.getString("SortScreen.menu.tools.treestats.label"));
        JMenuItem reloadTree = this.add(AppStarter.getString("FileTreePopUp.4"));
        this.addSeparator();
        JMenuItem newDirItem = this.add(AppStarter.getString("FileTreePopUp.5"));
        JMenuItem renameDirItem = this.add(AppStarter.getString("FileTreePopUp.6"));
        JMenuItem deleteDirItem = this.add(AppStarter.getString("FileTreePopUp.7"));
        this.addExtensions();
        if (this.myDirectoryNode == null) {
            showOneDirectoryItem.setEnabled(false);
            showNonImageFiles.setEnabled(false);
            newDirItem.setEnabled(false);
            renameDirItem.setEnabled(false);
            deleteDirItem.setEnabled(false);
            return;
        }
        showTree.setEnabled(false);
        if (this.myDirectoryNode.getChildCount() > 0) {
            showTree.setEnabled(true);
        }
        showSelectedDirectories.setEnabled(false);
        showTreeStats.setEnabled(true);
        reloadTree.setEnabled(true);
        if (this.myTree.getSelectionCount() > 0) {
            showSelectedDirectories.setEnabled(true);
        }
        if ((kids = this.myDirectoryNode.getFile().listFiles()) != null && kids.length > 0) {
            deleteDirItem.setEnabled(false);
            deleteDirItem.setToolTipText(AppStarter.getString("FileTreePopUp.11"));
        }
        showOneDirectoryItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(ExtendedDirectoryTreePopUp.this.myDirectoryNode, false);
            }
        });
        showNonImageFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(ExtendedDirectoryTreePopUp.this.myDirectoryNode, true);
            }
        });
        showTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                Enumeration<TreeNode> depth = ExtendedDirectoryTreePopUp.this.myDirectoryNode.depthFirstEnumeration();
                ArrayList<TreeNode> list = new ArrayList<TreeNode>();
                while (depth.hasMoreElements()) {
                    list.add(depth.nextElement());
                }
                DirectoryTreeNode[] nodes = new DirectoryTreeNode[list.size()];
                list.toArray(nodes);
                ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(nodes, false);
            }
        });
        showSelectedDirectories.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TreePath[] paths = ExtendedDirectoryTreePopUp.this.myTree.getSelectionPaths();
                DirectoryTreeNode[] nodes = new DirectoryTreeNode[paths.length];
                for (int i = 0; i < paths.length; ++i) {
                    nodes[i] = (DirectoryTreeNode)paths[i].getLastPathComponent();
                }
                ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(nodes, false);
            }
        });
        showTreeStats.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myTree.showStats(ExtendedDirectoryTreePopUp.this.myDirectoryNode, ExtendedDirectoryTreePopUp.this.iCountImageFilesInNodes);
            }
        });
        reloadTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myDirectoryNode.reloadNodes();
            }
        });
        newDirItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myDirectoryNode.newSubDir();
            }
        });
        renameDirItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myDirectoryNode.renameDir();
            }
        });
        deleteDirItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ExtendedDirectoryTreePopUp.this.myDirectoryNode.deleteDir();
            }
        });
    }

    protected void addExtensions() {
    }
}

