/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JMenuItem;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.shows.classic.Single;
import org.gerhardb.jibs.viewer.sorter.TilePanel;
import org.gerhardb.lib.image.ImageChangeUtil;

public class SingleResize
extends Single {
    private static final Color RESIZE_COLOR = Color.red;

    public SingleResize(IFrame mf) {
        super(mf);
        KeyAdapter adapter = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 113: {
                        SingleResize.this.myViewerFrame.gotoFullScreen(false);
                        event.consume();
                        return;
                    }
                }
            }

            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        if ((event.getModifiersEx() & 0x80) == 128) {
                            SingleResize.this.revert();
                        }
                        if ((event.getModifiersEx() & 0x200) == 512) {
                            SingleResize.this.revert();
                        }
                        event.consume();
                        return;
                    }
                }
            }
        };
        super.addKeyListener(adapter);
        this.myViewerFrame.getScroller().setShowViewKeyListener(null);
        this.myViewerFrame.getScroller().setEndMessages(true);
    }

    protected boolean iCanResize() {
        return false;
    }

    public void showImage(Graphics g) {
        int centerHeight;
        Color backgroundColor = OK_COLOR;
        BufferedImage showMe = this.mySaver.getCurrentImage();
        if (showMe == null) {
            showMe = this.myViewerFrame.getScroller().getBeyondBounds();
            if (showMe == null) {
                super.showNoPicture(g);
                return;
            }
            backgroundColor = EMPTY_COLOR;
        }
        BufferedImage originalImage = showMe;
        showMe = ImageChangeUtil.fitAspectDown(showMe, super.getWidth(), super.getHeight());
        if (originalImage.getWidth() > showMe.getWidth() || originalImage.getHeight() > showMe.getHeight()) {
            backgroundColor = RESIZE_COLOR;
        }
        this.myShownWidth = showMe.getWidth();
        this.myShownHeight = showMe.getHeight();
        super.setBackground(backgroundColor);
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        int centerWidth = (super.getWidth() - showMe.getWidth()) / 2;
        if (centerWidth < 0) {
            centerWidth = 0;
        }
        if ((centerHeight = (super.getHeight() - showMe.getHeight()) / 2) < 0) {
            centerHeight = 0;
        }
        g2.drawImage(showMe, null, centerWidth, centerHeight);
        File file = this.myViewerFrame.getScroller().getCurrentFile();
        if (file != null) {
            TilePanel.clsTilePanel.clip(file, g2, super.getWidth(), super.getHeight());
        }
        this.myViewerFrame.statusCurrentPage();
    }

    public JMenuItem makePreferencesItem() {
        return null;
    }

    public void showImage() {
        this.repaint();
    }
}

