/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.io.File;
import java.util.ArrayList;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.lib.dirtree.filelist.LinklessDragListener;

public class SingleDrag
implements Transferable {
    public static final DataFlavor SINGLE_DRAG_DATA_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=org.gerhardb.jibs.viewer.shows.classic.SingleDrag", "Local SinglDrag");
    protected DataFlavor[] myDataFlavors = new DataFlavor[]{DataFlavor.javaFileListFlavor, SINGLE_DRAG_DATA_FLAVOR};
    private IFrame myTopFrame;

    public SingleDrag(Component comp, IFrame frame) {
        this.myTopFrame = frame;
        DragSource ds = new DragSource();
        DSListener dsl = new DSListener();
        LinklessDragListener dgl = new LinklessDragListener(dsl, this, ds);
        ds.createDefaultDragGestureRecognizer(comp, 3, dgl);
    }

    public File getFileToTransfer() {
        return this.myTopFrame.getScroller().getCurrentFile();
    }

    public Object getTransferData(DataFlavor flavor) {
        if (DataFlavor.javaFileListFlavor.equals(flavor)) {
            ArrayList<File> fileList = new ArrayList<File>(1);
            fileList.add(this.getFileToTransfer());
            return new ArrayList(fileList);
        }
        if (SINGLE_DRAG_DATA_FLAVOR.equals(flavor)) {
            return this;
        }
        return null;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.myDataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < this.myDataFlavors.length; ++i) {
            if (!this.myDataFlavors[i].equals(flavor)) continue;
            return true;
        }
        return false;
    }

    class DSListener
    extends DragSourceAdapter {
        DSListener() {
        }

        public void dragDropEnd(DragSourceDropEvent event) {
            if (event.getDropSuccess()) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        int returnToIndex = SingleDrag.this.myTopFrame.getScroller().getValueZeroBased();
                        SingleDrag.this.myTopFrame.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                        SingleDrag.this.myTopFrame.getScroller().reloadScroller(returnToIndex);
                        SingleDrag.this.myTopFrame.getFrame().setCursor(Cursor.getPredefinedCursor(0));
                    }
                });
            }
        }

        public void dropActionChanged(DragSourceDragEvent event) {
            switch (event.getUserAction()) {
                case 2: {
                    event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                    break;
                }
                case 1: {
                    event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
                    break;
                }
            }
        }
    }
}

