/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.IRevert;
import org.gerhardb.jibs.viewer.ISave;
import org.gerhardb.jibs.viewer.IShow;
import org.gerhardb.jibs.viewer.PicInfoDialog;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.shows.classic.SingleDrag;
import org.gerhardb.jibs.viewer.shows.classic.SingleSaver;
import org.gerhardb.jibs.viewer.sorter.TileConstants;
import org.gerhardb.lib.dirtree.filelist.FileList;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.playlist.ScrollerChangeEvent;
import org.gerhardb.lib.util.Range;

public abstract class Single
extends JPanel
implements IShow,
IRevert,
DropTargetListener {
    protected static final Color OK_COLOR = Color.black;
    protected static final Color EMPTY_COLOR = Color.cyan;
    protected static final Color NFG_COLOR = Color.green;
    protected IFrame myViewerFrame;
    protected FileList myFileList;
    protected int myShownWidth;
    protected int myShownHeight;
    protected SingleSaver mySaver;
    private boolean iShowText = false;
    private JComponent myTextPane;
    private JEditorPane myEditorPane;

    public Single(IFrame mf) {
        super(true);
        this.myViewerFrame = mf;
        this.myFileList = this.myViewerFrame.getFileList();
        this.mySaver = new SingleSaver(this.myViewerFrame.getActions().getSaverActions(), mf.getFrame(), this, this.myViewerFrame.getScroller());
        this.myViewerFrame.getFileList().getFileListSelectionModel().setMouseAlwaysAdds(false);
        this.myViewerFrame.getFileList().getFileListSelectionModel().clearSelection();
        super.setFocusable(true);
        this.resetFocus();
        super.addMouseListener(new PictureMouseListener());
        new SingleDrag(this, mf);
        new DropTarget(this, this);
        this.myEditorPane = new JEditorPane();
        this.myEditorPane.setEditable(false);
        this.myEditorPane.setDisabledTextColor(Color.black);
        this.myEditorPane.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.myTextPane = new JScrollPane(this.myEditorPane, 22, 31);
        this.setLayout(new BorderLayout());
    }

    public void paint(Graphics g) {
        this.iShowText = this.showText();
        if (!this.iShowText) {
            this.removeAll();
            this.showImage(g);
        }
    }

    abstract void showImage(Graphics var1);

    public void revert() {
        this.myViewerFrame.gotoFullScreen(false);
    }

    public boolean isFullScreen() {
        return false;
    }

    public ISave getSaver() {
        return this.mySaver;
    }

    public JComponent getImageDisplay() {
        return this;
    }

    public void connect() {
        this.myViewerFrame.getScroller().addScrollerListener(this);
        super.addKeyListener(this.myViewerFrame.getScroller().getScrollerKeyListener());
    }

    public void disconnect() {
        this.myViewerFrame.getScroller().removeScrollerListener(this);
        super.removeKeyListener(this.myViewerFrame.getScroller().getScrollerKeyListener());
    }

    public void jumpTo(File file) {
        this.reloadScroller();
        this.myViewerFrame.getScroller().jumpTo(file);
        this.showPageFromScroller();
    }

    public void reloadScroller() {
        this.myViewerFrame.getScroller().reloadScroller();
    }

    public void reloadScroller(int index) {
        this.myViewerFrame.getScroller().reloadScroller(index);
    }

    public void resetFocus() {
        this.myViewerFrame.getScroller().setAutoFocus(this);
    }

    public void swapPictureFocus() {
        if (this.myFileList.hasFocus()) {
            this.myViewerFrame.getScroller().forceFocus();
        } else {
            this.myFileList.grabFocus();
        }
    }

    public void showPageFromScroller() {
        this.showImage();
        this.myViewerFrame.statusCurrentPage();
        if (this.myFileList.isVisible()) {
            this.myFileList.sliderAdjusted();
        }
    }

    public void startSlideShow() {
        this.myViewerFrame.getScroller().startSlideShow(ViewerPreferences.continuousShow());
    }

    public void info(StringBuffer sb) {
    }

    public Range showingIndexes() {
        int index = this.myViewerFrame.getScroller().getValueZeroBased();
        return new Range(index, index);
    }

    public void scrollerChanged(ScrollerChangeEvent ce) {
        switch (ce.getEventType()) {
            case 0: {
                if (this.myViewerFrame.getScroller().getValueIsAdjusting()) break;
                this.showImage();
                break;
            }
            case 1: {
                if (this.myViewerFrame.getScroller().getValueIsAdjusting()) break;
                this.showPageFromScroller();
                break;
            }
            case 2: 
            case 3: {
                if (this.myViewerFrame.getScroller().getMaximumZeroBased() < 0) {
                    this.repaint();
                }
                this.showPageFromScroller();
            }
        }
    }

    private boolean showText() {
        boolean foundTextFile = false;
        File currentFile = this.myViewerFrame.getScroller().getCurrentFile();
        if (currentFile != null && currentFile.exists()) {
            String lowerCaseName = currentFile.getName().toLowerCase();
            for (int i = 0; i < ImageFactory.TEXT_ENDINGS.length; ++i) {
                if (!lowerCaseName.endsWith(ImageFactory.TEXT_ENDINGS[i])) continue;
                foundTextFile = true;
                break;
            }
        }
        if (foundTextFile) {
            if (!this.iShowText) {
                this.add((Component)this.myTextPane, "Center");
            }
            String url = "file:///" + currentFile;
            try {
                this.myEditorPane.setPage(url);
                this.myEditorPane.setCaretPosition(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.myEditorPane.repaint();
            return true;
        }
        return false;
    }

    protected boolean iCanResize() {
        return true;
    }

    protected void showNoPicture(Graphics g) {
        super.setBackground(NFG_COLOR);
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Font font = new Font("Default", 0, 24);
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        TextLayout text = new TextLayout(Jibs.getString("Single.1"), font, fontRenderContext);
        int xCenter = this.getWidth() / 2;
        int yCenter = this.getHeight() / 2;
        int textX = xCenter - (int)text.getBounds().getWidth() / 2;
        int textY = (int)((float)yCenter - text.getDescent());
        text.draw(g2, textX, textY);
    }

    private void evaluateDrag(DropTargetDragEvent event) {
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        if (flavors == TileConstants.CLS_DATA_FLAVORS) {
            event.acceptDrag(2);
        } else {
            event.rejectDrag();
        }
    }

    public void dragEnter(DropTargetDragEvent event) {
        this.evaluateDrag(event);
    }

    public void dropActionChanged(DropTargetDragEvent event) {
        this.evaluateDrag(event);
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void drop(DropTargetDropEvent event) {
        if (event.isLocalTransfer()) {
            DataFlavor[] flavors = event.getCurrentDataFlavors();
            if (flavors == TileConstants.CLS_DATA_FLAVORS) {
                event.dropComplete(true);
            } else {
                event.dropComplete(false);
            }
        }
    }

    private class PictureMouseListener
    extends MouseAdapter {
        private PictureMouseListener() {
        }

        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2) {
                Single.this.myViewerFrame.gotoFullScreen(false);
            } else if (2 == event.getButton() || 3 == event.getButton()) {
                if (Single.this.myViewerFrame.getScroller().isBeyond()) {
                    return;
                }
                new PicInfoDialog(Single.this.myViewerFrame.getScroller().getCurrentFile(), Single.this.myViewerFrame.getFrame(), Single.this, Single.this, Single.this.myViewerFrame.getActions().getToolBarButton("file", "trash"), Single.this.myViewerFrame.getActions().getToolBarButton("file", "park"), false, Single.this.myShownWidth, Single.this.myShownHeight, true, Single.this.myViewerFrame.getScroller());
            } else {
                Single.this.myViewerFrame.getScroller().requestFocus();
            }
        }
    }
}

