/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad.ranker;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JProgressBar;

public class RankByWordCounts {
    ArrayList myFileList;
    String[] myTokenList = null;
    private boolean iStop;
    JProgressBar myProgress;

    RankByWordCounts(JProgressBar progress) {
        this.myProgress = progress;
    }

    void stop() {
        this.iStop = true;
    }

    void rank(String wordCountFileName, String scoringFileName, String outFileName, boolean html) throws Exception {
        this.myProgress.setString("");
        this.myProgress.setValue(0);
        this.logln("wordCountFileName: " + wordCountFileName, true);
        this.logln("scoringFileName: " + scoringFileName, true);
        this.logln("outFileName: " + outFileName, true);
        this.iStop = false;
        if (wordCountFileName.equals(outFileName)) {
            throw new Exception("File names must be different.");
        }
        File scoringFile = new File(scoringFileName);
        File wordCoutnFile = new File(wordCountFileName);
        File outFile = new File(outFileName);
        if (!scoringFile.exists()) {
            throw new Exception("Scoring File must exist: " + scoringFile);
        }
        if (!wordCoutnFile.exists()) {
            throw new Exception("Word Count File must exist: " + wordCoutnFile);
        }
        ScoreARow rowScorer = new ScoreARow(scoringFile);
        int[][] wordCounts = this.readWordCounts(wordCoutnFile);
        Object[] ranking = new IndexedScore[wordCounts.length];
        this.myProgress.setMaximum((int)((double)ranking.length * 1.1));
        for (int row = 0; row < wordCounts.length; ++row) {
            if (this.iStop) {
                return;
            }
            ranking[row] = rowScorer.score(row, wordCounts[row]);
            this.myProgress.setValue(row);
        }
        Arrays.sort(ranking);
        this.myProgress.setValue(ranking.length + (int)((double)ranking.length * 0.02));
        this.writeCVS(outFile, wordCounts, (IndexedScore[])ranking);
        this.myProgress.setValue(ranking.length + (int)((double)ranking.length * 0.06));
        if (html) {
            this.writeHTML(wordCoutnFile, outFileName, wordCounts, (IndexedScore[])ranking);
        }
        this.myProgress.setValue(ranking.length + (int)((double)ranking.length * 0.1));
        this.logln("");
        this.logln("---------------------------------------------------");
        this.logln("Done", true);
        this.myProgress.setString("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[][] readWordCounts(File inFile) throws Exception {
        String errMsg = null;
        this.logln("\n---------------------------------------------------");
        this.logln("Reading in count file: " + inFile);
        this.myFileList = new ArrayList(200);
        BufferedReader buffRead = null;
        int[][] rtnMe = new int[0][0];
        try {
            buffRead = new BufferedReader(new FileReader(inFile));
            String aLine = buffRead.readLine();
            boolean grabTokensFromFirstLine = true;
            while (aLine != null) {
                this.logln(aLine);
                if (this.iStop) {
                    int[][] nArray = rtnMe;
                    return nArray;
                }
                String[] splitFileNameFromHeaders = aLine.split("=!:,");
                this.myFileList.add(splitFileNameFromHeaders[0].trim());
                if (grabTokensFromFirstLine) {
                    grabTokensFromFirstLine = false;
                    if (splitFileNameFromHeaders.length > 1) {
                        int i;
                        String[] countHeadings = splitFileNameFromHeaders[1].split(",");
                        this.myTokenList = new String[countHeadings.length + 1];
                        this.myTokenList[0] = splitFileNameFromHeaders[0].trim();
                        for (i = 0; i < countHeadings.length; ++i) {
                            this.myTokenList[i + 1] = countHeadings[i].trim();
                        }
                        System.out.print("LIST OF TOKENS: ");
                        for (i = 0; i < this.myTokenList.length; ++i) {
                            if (i > 0) {
                                System.out.print(", ");
                            }
                            System.out.print(this.myTokenList[i]);
                        }
                        System.out.println("");
                    } else {
                        this.myTokenList = new String[1];
                        this.myTokenList[0] = splitFileNameFromHeaders[0].trim();
                    }
                }
                aLine = buffRead.readLine();
            }
            buffRead.close();
            rtnMe = new int[this.myFileList.size() - 1][this.myTokenList.length + 1];
            buffRead = new BufferedReader(new FileReader(inFile));
            aLine = buffRead.readLine();
            aLine = buffRead.readLine();
            int aValue = 0;
            int rowCount = 0;
            while (aLine != null) {
                rtnMe[rowCount][0] = rowCount + 1;
                String[] splitFileNameFromCounts = aLine.split("=!:,");
                if (splitFileNameFromCounts.length > 1) {
                    this.logln("splitFileNameFromCounts[1]: " + splitFileNameFromCounts[1]);
                    String[] tokens = splitFileNameFromCounts[1].split(",");
                    for (int i = 0; i < tokens.length; ++i) {
                        aValue = 0;
                        if (tokens[i] != null && tokens[i].length() != 0) {
                            try {
                                aValue = Integer.parseInt(tokens[i].trim());
                            }
                            catch (Exception ex) {
                                throw new Exception("Cound not get count from: " + tokens[i].trim() + ": " + ex.getMessage());
                            }
                        }
                        rtnMe[rowCount][i + 1] = aValue;
                    }
                }
                aLine = buffRead.readLine();
                ++rowCount;
            }
            buffRead.close();
        }
        catch (Exception ex) {
            errMsg = ex.getMessage();
            ex.printStackTrace();
        }
        finally {
            try {
                buffRead.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (errMsg != null) {
            throw new Exception(errMsg);
        }
        return rtnMe;
    }

    void writeHTML(File inFile, String outFileName, int[][] wordCounts, IndexedScore[] ranking) throws Exception {
        int increment = 50;
        int stop = 0;
        int page = 1;
        int i = 0;
        while (i < ranking.length) {
            stop = i + increment;
            this.writeHTML(inFile, outFileName, wordCounts, ranking, i, stop, page);
            ++page;
            i = stop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHTML(File inFile, String outFileName, int[][] wordCounts, IndexedScore[] ranking, int start, int stop, int page) throws Exception {
        String errMsg = null;
        File outHTML = new File(outFileName + "_" + page + ".html");
        if (stop >= ranking.length) {
            stop = ranking.length;
        }
        PrintWriter outWriter = null;
        try {
            outWriter = new PrintWriter(new BufferedWriter(new FileWriter(outHTML)));
            outWriter.println("");
            outWriter.println("");
            outWriter.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            outWriter.println("<html>");
            outWriter.println("<head>");
            outWriter.print("<title>");
            outWriter.print(inFile.toString());
            outWriter.println("</title>");
            outWriter.println("</head>");
            outWriter.println("<body>");
            int nextPage = 0;
            if (stop < ranking.length) {
                nextPage = page + 1;
            }
            this.page(outWriter, outFileName, page, nextPage);
            outWriter.println("<table border=\"1\">");
            outWriter.println("<tr>");
            outWriter.print("<th>");
            outWriter.print("#");
            outWriter.println("</th>");
            outWriter.print("<th>");
            outWriter.print(this.myTokenList[0]);
            outWriter.println("</th>");
            outWriter.print("<th>");
            outWriter.print("Index");
            outWriter.println("</th>");
            outWriter.println("<th>");
            outWriter.print("Score");
            outWriter.println("</th>");
            for (int i = 1; i < this.myTokenList.length; ++i) {
                outWriter.print("<th>");
                outWriter.print(this.myTokenList[i]);
                outWriter.println("</th>");
            }
            outWriter.println("</tr>");
            for (int rows = start; rows < stop; ++rows) {
                outWriter.println("<tr>");
                outWriter.print("<td>");
                outWriter.print(rows + 1);
                outWriter.println("</td>");
                outWriter.println("<td>");
                outWriter.print("<a href=\"file:///");
                outWriter.print(this.myFileList.get(ranking[rows].myIndex));
                outWriter.print("\" target=\"_blank\" >");
                outWriter.print(this.myFileList.get(ranking[rows].myIndex));
                outWriter.print("</a>");
                outWriter.println("</td>");
                int lookedUpRow = ranking[rows].myIndex - 1;
                outWriter.println("<td>");
                outWriter.print(wordCounts[lookedUpRow][0]);
                outWriter.println("</td>");
                int lastColumn = wordCounts[rows].length - 1;
                outWriter.println("<td>");
                outWriter.print(wordCounts[lookedUpRow][lastColumn]);
                outWriter.println("</td>");
                for (int i = 1; i < lastColumn; ++i) {
                    outWriter.println("<td>");
                    outWriter.print(wordCounts[lookedUpRow][i]);
                    outWriter.println("</td>");
                }
                outWriter.println("</tr>");
            }
            outWriter.println("</table>");
            outWriter.println("Page: " + page);
            this.page(outWriter, outFileName, page, nextPage);
            outWriter.println("</body>");
            outWriter.println("</html>");
        }
        catch (Exception ex) {
            errMsg = ex.getMessage();
            ex.printStackTrace();
        }
        finally {
            try {
                outWriter.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (errMsg != null) {
            throw new Exception(errMsg);
        }
    }

    void page(PrintWriter outWriter, String outFileName, int page, int nextPage) {
        outWriter.println("Page: " + page + " &nbsp; &nbsp; &nbsp; &nbsp;");
        if (page > 1) {
            int priorPage = page - 1;
            outWriter.print("<a href=\"file:///");
            outWriter.print(outFileName + "_" + priorPage + ".html");
            outWriter.print("\" >Previous</a>");
        }
        outWriter.print(" &nbsp; &nbsp; &nbsp; &nbsp; ");
        if (nextPage > 0) {
            outWriter.print("<a href=\"file:///");
            outWriter.print(outFileName + "_" + nextPage + ".html");
            outWriter.print("\" >Next</a>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCVS(File outFile, int[][] wordCounts, IndexedScore[] ranking) throws Exception {
        String errMsg = null;
        PrintWriter outWriter = null;
        try {
            outWriter = new PrintWriter(new BufferedWriter(new FileWriter(outFile)));
            outWriter.print(this.myTokenList[0]);
            outWriter.print(',');
            outWriter.print("Index");
            outWriter.print(',');
            outWriter.print("Score");
            for (int i = 1; i < this.myTokenList.length; ++i) {
                outWriter.print(',');
                outWriter.print(this.myTokenList[i]);
            }
            outWriter.println("");
            for (int rows = 0; rows < ranking.length; ++rows) {
                outWriter.print(this.myFileList.get(ranking[rows].myIndex));
                int lookedUpRow = ranking[rows].myIndex - 1;
                outWriter.print(',');
                outWriter.print(wordCounts[lookedUpRow][0]);
                outWriter.print(',');
                int lastColumn = wordCounts[rows].length - 1;
                outWriter.print(wordCounts[lookedUpRow][lastColumn]);
                for (int col = 1; col < lastColumn; ++col) {
                    outWriter.print(',');
                    outWriter.print(wordCounts[lookedUpRow][col]);
                }
                outWriter.println("");
            }
        }
        catch (Exception ex) {
            errMsg = ex.getMessage();
            ex.printStackTrace();
        }
        finally {
            try {
                outWriter.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (errMsg != null) {
            throw new Exception(errMsg);
        }
    }

    void logln(String logMe) {
        this.logln(logMe, false);
    }

    void logln(String logMe, boolean force) {
        if (force) {
            System.out.println(logMe);
        }
    }

    public static void main(String[] args) throws Exception {
        String path = "D:/dev/test";
        RankByWordCounts ranker = new RankByWordCounts(new JProgressBar());
        ranker.rank(path + "/JIBS_Word_Count.csv", path + "/scoring.txt", path + "/JIBS_RANKED_Word_Count.csv", true);
    }

    class ScoringFactors {
        String myLabel;
        boolean iAmAGroup = false;
        private String[] myScoringWordsOrGroups;
        private ScoreForCount[] myScoring;
        boolean iNeedArranging = true;

        ScoringFactors(int count, String aLine) throws Exception {
            RankByWordCounts.this.logln("\nLine: " + count);
            RankByWordCounts.this.logln("Input:  " + aLine);
            String[] tokens = aLine.split(":");
            if (tokens.length > 3) {
                throw new Exception("This line has more than two \":\":" + aLine);
            }
            String words = null;
            String scores = null;
            if (tokens.length == 3) {
                this.myLabel = tokens[0].trim();
                words = tokens[1].trim();
                scores = tokens[2].trim();
            } else if (tokens.length == 2) {
                this.myLabel = "jibs-" + count;
                words = tokens[0].trim();
                scores = tokens[1].trim();
            }
            if (words == null || words.length() == 0) {
                throw new Exception("No words found in:" + aLine);
            }
            if (words.startsWith("(") && words.endsWith(")")) {
                this.iAmAGroup = true;
                words = words.substring(1, words.length() - 1);
                this.myScoringWordsOrGroups = words.split(",");
            } else {
                this.iAmAGroup = false;
                this.myScoringWordsOrGroups = words.split(",");
            }
            for (int i = 0; i < this.myScoringWordsOrGroups.length; ++i) {
                this.myScoringWordsOrGroups[i] = this.myScoringWordsOrGroups[i].trim();
            }
            if (scores == null || scores.length() == 0) {
                throw new Exception("No scores found in:" + aLine);
            }
            String[] scoreTokens = scores.split(",");
            this.myScoring = new ScoreForCount[scoreTokens.length];
            for (int i = 0; i < scoreTokens.length; ++i) {
                this.myScoring[i] = new ScoreForCount(scoreTokens[i]);
            }
            Arrays.sort(this.myScoring);
            RankByWordCounts.this.logln("Output: " + this);
        }

        int score(int[] wordCounts, HashMap scoresByFactor) throws Exception {
            if (this.iAmAGroup) {
                return this.scoreAGroup(scoresByFactor);
            }
            return this.scoreAWord(wordCounts, scoresByFactor);
        }

        int scoreAWord(int[] wordCounts, HashMap scoresByFactor) throws Exception {
            int wordCount = 0;
            for (int word = 0; word < this.myScoringWordsOrGroups.length; ++word) {
                String scoringWord = this.myScoringWordsOrGroups[word];
                for (int tokenCounter = 1; tokenCounter < RankByWordCounts.this.myTokenList.length; ++tokenCounter) {
                    String tokenWord = RankByWordCounts.this.myTokenList[tokenCounter];
                    RankByWordCounts.this.logln("Checking: " + scoringWord + " against " + tokenWord);
                    if (!tokenWord.equals(scoringWord)) continue;
                    wordCount += wordCounts[tokenCounter];
                    RankByWordCounts.this.logln("FOUND COUNT OF: " + wordCounts[tokenCounter] + " for " + tokenWord);
                }
            }
            int score = 0;
            for (int scoring = 0; scoring < this.myScoring.length; ++scoring) {
                if (wordCount <= this.myScoring[scoring].myCount) continue;
                score = this.myScoring[scoring].myScore;
                break;
            }
            LabelAndCount was = new LabelAndCount(this.myLabel, wordCount);
            scoresByFactor.put(was.myLabel, was);
            RankByWordCounts.this.logln("Factor: " + this.myLabel + "  Word Count: " + wordCount + " Score: " + score);
            return score;
        }

        int scoreAGroup(HashMap scoresByFactor) throws Exception {
            int wordInstancesForGroup = 0;
            for (int word = 0; word < this.myScoringWordsOrGroups.length; ++word) {
                LabelAndCount was = (LabelAndCount)scoresByFactor.get(this.myScoringWordsOrGroups[word]);
                if (was == null) {
                    throw new Exception("Could not find score for label: " + this.myScoringWordsOrGroups[word]);
                }
                if (was.myCount > 0) {
                    ++wordInstancesForGroup;
                }
                RankByWordCounts.this.logln("For word: " + this.myScoringWordsOrGroups[word] + " found: " + was + "  cummulative word count: " + wordInstancesForGroup);
            }
            int groupScore = 0;
            for (int scoring = 0; scoring < this.myScoring.length; ++scoring) {
                if (wordInstancesForGroup <= this.myScoring[scoring].myCount) continue;
                groupScore = this.myScoring[scoring].myScore;
                break;
            }
            LabelAndCount was = new LabelAndCount(this.myLabel, wordInstancesForGroup);
            scoresByFactor.put(was.myLabel, was);
            RankByWordCounts.this.logln("Group: " + this.myLabel + " has " + wordInstancesForGroup + " words which scored: " + groupScore);
            return groupScore;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScoringFactors) {
                ScoringFactors other = (ScoringFactors)obj;
                if (other.myLabel == this.myLabel) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.myLabel.hashCode();
        }

        public String toString() {
            int i;
            StringBuffer buff = new StringBuffer(100);
            buff.append(this.myLabel);
            buff.append(":");
            if (this.iAmAGroup) {
                buff.append("(");
            }
            for (i = 0; i < this.myScoringWordsOrGroups.length; ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(this.myScoringWordsOrGroups[i]);
            }
            if (this.iAmAGroup) {
                buff.append(")");
            }
            buff.append(":");
            for (i = 0; i < this.myScoring.length; ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(this.myScoring[i]);
            }
            return buff.toString();
        }
    }

    class ScoreForCount
    implements Comparable {
        int myCount = 0;
        int myScore = 0;

        ScoreForCount(String scoreToken) throws Exception {
            String[] split = scoreToken.split("->");
            if (split.length > 0) {
                try {
                    this.myCount = Integer.parseInt(split[0].trim());
                }
                catch (Exception ex) {
                    throw new Exception("Cound not get count from: " + scoreToken.trim() + ": " + ex.getMessage());
                }
            }
            if (split.length > 1) {
                try {
                    this.myScore = Integer.parseInt(split[1].trim());
                }
                catch (Exception ex) {
                    throw new Exception("Cound not get score from: " + scoreToken.trim() + ": " + ex.getMessage());
                }
            }
            if (split.length > 2) {
                RankByWordCounts.this.logln("More than one > found:" + scoreToken);
            }
        }

        public int compareTo(Object obj) {
            if (obj instanceof ScoreForCount) {
                ScoreForCount other = (ScoreForCount)obj;
                if (other.myCount > this.myCount) {
                    return 1;
                }
                if (other.myCount < this.myCount) {
                    return -1;
                }
            }
            return 0;
        }

        public String toString() {
            return this.myCount + "->" + this.myScore;
        }
    }

    class IndexedScore
    implements Comparable {
        int myIndex;
        int myRank;

        IndexedScore(int index, int rank) {
            this.myIndex = index;
            this.myRank = rank;
        }

        public int compareTo(Object obj) {
            if (obj instanceof IndexedScore) {
                IndexedScore other = (IndexedScore)obj;
                if (other.myRank > this.myRank) {
                    return 1;
                }
                if (other.myRank < this.myRank) {
                    return -1;
                }
            }
            return 0;
        }
    }

    class LabelAndCount {
        String myLabel;
        int myCount = 0;

        LabelAndCount(String label, int count) {
            this.myLabel = label;
            this.myCount = count;
        }

        public boolean equals(Object obj) {
            if (obj instanceof LabelAndCount) {
                LabelAndCount other = (LabelAndCount)obj;
                if (other.myLabel == this.myLabel) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.myLabel.hashCode();
        }

        public String toString() {
            StringBuffer buff = new StringBuffer(100);
            buff.append("LabelAndCount: ");
            buff.append(this.myLabel);
            buff.append("  ");
            buff.append(this.myCount);
            return buff.toString();
        }
    }

    class ScoreARow {
        ScoringFactors[] myFactors;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ScoreARow(File scoringFile) throws Exception {
            if (RankByWordCounts.this.iStop) {
                return;
            }
            String errMsg = null;
            RankByWordCounts.this.logln("\n---------------------------------------------------");
            RankByWordCounts.this.logln("Reading in scoring file: " + scoringFile);
            BufferedReader buffRead = null;
            HashMap<String, ScoringFactors> factors = new HashMap<String, ScoringFactors>(50);
            try {
                buffRead = new BufferedReader(new FileReader(scoringFile));
                String aLine = buffRead.readLine();
                int count = 0;
                while (aLine != null) {
                    if (!(aLine = aLine.trim()).startsWith("#") && aLine.length() > 0) {
                        ScoringFactors ws = new ScoringFactors(count, aLine);
                        factors.put(ws.myLabel, ws);
                    }
                    ++count;
                    aLine = buffRead.readLine();
                }
                buffRead.close();
            }
            catch (Exception ex) {
                errMsg = ex.getMessage();
                ex.printStackTrace();
            }
            finally {
                try {
                    buffRead.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (errMsg != null) {
                throw new Exception(errMsg);
            }
            ArrayList<ScoringFactors> orderedFactors = new ArrayList<ScoringFactors>(factors.size());
            Iterator factorList = factors.values().iterator();
            while (factorList.hasNext()) {
                ScoringFactors aFactor = (ScoringFactors)factorList.next();
                if (aFactor.iAmAGroup) continue;
                orderedFactors.add(aFactor);
                aFactor.iNeedArranging = false;
            }
            boolean processMoreGroups = true;
            int count = 0;
            while (processMoreGroups) {
                processMoreGroups = this.processGroups(factors, orderedFactors);
                if (++count <= 20) continue;
                throw new Exception("Could not resolve cyclic dependencies in 20 tries.");
            }
            this.myFactors = orderedFactors.toArray(new ScoringFactors[factors.size()]);
        }

        boolean processGroups(HashMap factors, ArrayList orderedFactors) throws Exception {
            Iterator factorList = factors.values().iterator();
            boolean someGroupsNotAdded = false;
            while (factorList.hasNext()) {
                ScoringFactors aFactor = (ScoringFactors)factorList.next();
                if (!aFactor.iAmAGroup || !aFactor.iNeedArranging) continue;
                boolean iCanBeAdded = true;
                for (int i = 0; i < aFactor.myScoringWordsOrGroups.length; ++i) {
                    ScoringFactors calledFactor = (ScoringFactors)factors.get(aFactor.myScoringWordsOrGroups[i]);
                    if (calledFactor == null) {
                        throw new Exception("In group " + aFactor.myLabel + ", cound not find label for: " + aFactor.myScoringWordsOrGroups[i]);
                    }
                    if (!calledFactor.iNeedArranging) continue;
                    iCanBeAdded = false;
                    someGroupsNotAdded = true;
                    break;
                }
                if (!iCanBeAdded) continue;
                orderedFactors.add(aFactor);
                aFactor.iNeedArranging = false;
            }
            return someGroupsNotAdded;
        }

        IndexedScore score(int row, int[] wordCounts) throws Exception {
            RankByWordCounts.this.logln("");
            RankByWordCounts.this.logln("---------------------------------------------------");
            RankByWordCounts.this.logln("Row: " + wordCounts[0] + " " + RankByWordCounts.this.myFileList.get(row + 1));
            for (int i = 1; i < RankByWordCounts.this.myTokenList.length; ++i) {
                RankByWordCounts.this.logln(RankByWordCounts.this.myTokenList[i] + ": " + wordCounts[i]);
            }
            RankByWordCounts.this.logln("");
            int score = 0;
            HashMap scoresByFactor = new HashMap(this.myFactors.length);
            for (int factorCounter = 0; factorCounter < this.myFactors.length; ++factorCounter) {
                RankByWordCounts.this.logln("FACTORS: " + this.myFactors[factorCounter]);
                RankByWordCounts.this.logln("CUMULATIVE SCORE: " + (score += this.myFactors[factorCounter].score(wordCounts, scoresByFactor)) + "\n");
            }
            wordCounts[wordCounts.length - 1] = score;
            return new IndexedScore(wordCounts[0], score);
        }
    }
}

