/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textPad.ranker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.textPad.ranker.RankByWordCounts;
import org.gerhardb.jibs.textPad.ranker.WordCount;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;

public class CountAndRankPanel
extends JPanelRows {
    private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/textPad/RankUI");
    private static final String ROOT_DIR = "ROOT_DIR";
    private static final String SCORING_FILE = "SCORING_FILE";
    private static final String WORD_COUNT_FILE = "WORD_COUNT_FILE";
    private static final String OUTPUT_FILE = "OUTPUT_FILE";
    private static final String OUTPUT_HTML = "OUTPUT_HTML";
    JProgressBar myProgress = new JProgressBar();
    WordCount myWordCount = new WordCount(this.myProgress);
    RankByWordCounts myRankByWordCounts = new RankByWordCounts(this.myProgress);
    JTextField myRootDir = new JTextField(50);
    JTextField scoringFileFld = new JTextField(50);
    JTextField wordCountFileFld = new JTextField(50);
    JTextField outputFileFld = new JTextField(50);
    JCheckBox outputHTML = new JCheckBox("Output HTML Rankings");
    JButton stopCountingBtn = new JButton("Stop Counting");
    JButton stopRankingBtn = new JButton("Stop Ranking");
    JButton goCountBtn = new JButton("Count Words");
    JButton goRankBtn = new JButton("Do Ranking");

    public CountAndRankPanel() {
        this.layoutComponents();
    }

    void exit() {
        try {
            clsPrefs.put(ROOT_DIR, this.myRootDir.getText());
            clsPrefs.put(SCORING_FILE, this.scoringFileFld.getText());
            clsPrefs.put(WORD_COUNT_FILE, this.wordCountFileFld.getText());
            clsPrefs.put(OUTPUT_FILE, this.outputFileFld.getText());
            clsPrefs.putBoolean(OUTPUT_HTML, this.outputHTML.isSelected());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void layoutComponents() {
        try {
            this.myRootDir.setText(clsPrefs.get(ROOT_DIR, System.getProperty("user.home")));
            this.wordCountFileFld.setText(clsPrefs.get(WORD_COUNT_FILE, System.getProperty("user.home")));
            this.scoringFileFld.setText(clsPrefs.get(SCORING_FILE, System.getProperty("user.home")));
            this.outputFileFld.setText(clsPrefs.get(OUTPUT_FILE, System.getProperty("user.home")));
            this.outputHTML.setSelected(clsPrefs.getBoolean(OUTPUT_HTML, true));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.myProgress.setMinimum(0);
        this.myProgress.setIndeterminate(false);
        this.myProgress.setStringPainted(true);
        this.myProgress.setString("");
        JButton rootBtn = new JButton("...");
        rootBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountAndRankPanel.this.selectRoot();
            }
        });
        this.goCountBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Runnable runMe = new Runnable(){

                    public void run() {
                        CountAndRankPanel.this.countWords();
                    }
                };
                new Thread(runMe).start();
            }
        });
        this.goRankBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Runnable runMe = new Runnable(){

                    public void run() {
                        CountAndRankPanel.this.doRank();
                    }
                };
                new Thread(runMe).start();
            }
        });
        this.stopCountingBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountAndRankPanel.this.myRankByWordCounts.stop();
            }
        });
        this.stopRankingBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountAndRankPanel.this.myRankByWordCounts.stop();
            }
        });
        this.stopCountingBtn.setEnabled(false);
        this.stopRankingBtn.setEnabled(false);
        JPanel nextRow = this.topRow();
        nextRow.add(new JLabel("Directory: "));
        nextRow.add(this.myRootDir);
        nextRow.add(rootBtn);
        nextRow = this.nextRow();
        nextRow.add(new JLabel("Scoring file: "));
        nextRow.add(this.scoringFileFld);
        nextRow.add(this.makeFileButton(this.scoringFileFld, SCORING_FILE));
        nextRow = this.nextRow(1);
        nextRow.add(this.goCountBtn);
        nextRow.add(this.stopCountingBtn);
        nextRow = this.nextRow();
        nextRow.add(new JLabel("Word Count file: "));
        nextRow.add(this.wordCountFileFld);
        nextRow.add(this.makeFileButton(this.wordCountFileFld, WORD_COUNT_FILE));
        nextRow = this.nextRow(1);
        nextRow.add(this.goRankBtn);
        nextRow.add(this.stopRankingBtn);
        nextRow = this.nextRow();
        nextRow.add(new JLabel("Output file: "));
        nextRow.add(this.outputFileFld);
        nextRow.add(this.makeFileButton(this.outputFileFld, OUTPUT_FILE));
        nextRow = this.nextRow();
        nextRow.add(this.outputHTML);
        nextRow = this.nextRow(new BorderLayout());
        nextRow.add((Component)this.myProgress, "Center");
    }

    JButton makeFileButton(final JTextField field, final String prefsLabel) {
        JButton rtnMe = new JButton("...");
        rtnMe.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String file = field.getText();
                if (file == null) {
                    file = System.getProperty("user.home");
                }
                file = CountAndRankPanel.this.lookupFile("File with word counts", file);
                field.setText(file);
                try {
                    clsPrefs.put(prefsLabel, file);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        return rtnMe;
    }

    private String lookupFile(String msg, String prior) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(msg);
        chooser.setFileSelectionMode(2);
        File priorFile = new File(prior);
        if (priorFile.isFile() || !priorFile.exists()) {
            priorFile = priorFile.getParentFile();
        }
        chooser.setCurrentDirectory(priorFile);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0) {
            try {
                return chooser.getSelectedFile().getCanonicalPath();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    void selectRoot() {
        File picked;
        JFileChooserExtra chooser = new JFileChooserExtra(this.myRootDir.getText());
        chooser.setApproveButtonText("Select Root");
        chooser.setDialogTitle("Select root directory to do word count in");
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        int returnVal = chooser.showOpenDialog(this);
        if (returnVal == 0 && (picked = chooser.getSelectedFile()) != null) {
            this.myRootDir.setText(picked.toString());
            try {
                clsPrefs.put(ROOT_DIR, picked.toString());
                clsPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void countWords() {
        String rootString = this.myRootDir.getText();
        File rootDir = new File(rootString);
        String[] words = this.getWordListFromScoreFile(new File(this.scoringFileFld.getText()));
        File outputFile = new File(this.wordCountFileFld.getText());
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.goRankBtn.setEnabled(false);
            this.stopCountingBtn.setEnabled(true);
            this.myWordCount.count(words, rootDir, outputFile);
            this.stopCountingBtn.setEnabled(false);
            this.goRankBtn.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Problem", 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] getWordListFromScoreFile(File scoringFile) {
        if (scoringFile.exists() && scoringFile.isFile()) {
            String errMsg = null;
            HashMap<String, String> wordList = new HashMap<String, String>(50);
            System.out.println("\n---------------------------------------------------");
            System.out.println("Scanning scoring file: " + scoringFile);
            BufferedReader buffRead = null;
            try {
                buffRead = new BufferedReader(new FileReader(scoringFile));
                String aLine = buffRead.readLine();
                while (aLine != null) {
                    System.out.println(aLine);
                    aLine = aLine.trim();
                    if (!aLine.startsWith("#") && aLine.length() > 0) {
                        String[] tokens = aLine.split(":");
                        if (tokens.length > 3) {
                            throw new Exception("This line has more than two \":\":" + aLine);
                        }
                        String words = null;
                        if (tokens.length == 3) {
                            words = tokens[1].trim();
                        } else if (tokens.length == 2) {
                            words = tokens[0].trim();
                        }
                        if (words == null || words.length() == 0) {
                            throw new Exception("No words found in:" + aLine);
                        }
                        if (words.startsWith("(") && words.endsWith(")")) {
                            words = words.substring(1, words.length() - 1);
                        }
                        String[] wordsInThisLine = words.split(",");
                        for (int i = 0; i < wordsInThisLine.length; ++i) {
                            String aWord = wordsInThisLine[i].trim();
                            wordList.put(aWord, aWord);
                        }
                    }
                    aLine = buffRead.readLine();
                }
                buffRead.close();
            }
            catch (Exception ex) {
                errMsg = ex.getMessage();
                ex.printStackTrace();
            }
            finally {
                try {
                    buffRead.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (errMsg != null) {
                JOptionPane.showMessageDialog(this, errMsg, "Problem", 0);
                return new String[0];
            }
            Object[] allWords = wordList.values().toArray(new String[wordList.values().size()]);
            Arrays.sort(allWords);
            return allWords;
        }
        JOptionPane.showMessageDialog(this, "Could not find file: " + scoringFile, "Problem", 0);
        return new String[0];
    }

    private void doRank() {
        try {
            this.goCountBtn.setEnabled(false);
            this.stopRankingBtn.setEnabled(true);
            this.myRankByWordCounts.rank(this.wordCountFileFld.getText(), this.scoringFileFld.getText(), this.outputFileFld.getText(), this.outputHTML.isSelected());
            this.stopRankingBtn.setEnabled(false);
            this.goCountBtn.setEnabled(true);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), Jibs.getString("problem"), 0);
            ex.printStackTrace();
        }
    }
}

