/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.textCompare;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gerhardb.jibs.textCompare.TextCompareGUI;
import org.gerhardb.jibs.textCompare.TextCompareListItem;
import org.gerhardb.jibs.textCompare.TextCompareWorker;
import org.gerhardb.jibs.textCompare.TextFilePanel;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.util.Stoppable;

public class TextComparePanel
extends JPanel
implements DirListController.Clearable {
    TextCompareGUI myGUI;
    Stoppable myWorker;
    JProgressBar myProgressBar = new JProgressBar();
    JLabel myCurrentAction = new JLabel("Ready to start scan...");
    JButton myStartBtn = new JButton("Scan");
    JButton myStopBtn = new JButton("Stop");
    DefaultListModel myPossibleDuplicates = new DefaultListModel();
    JList myList = new JList(this.myPossibleDuplicates);
    TextFilePanel myLeftText = new TextFilePanel(this);
    TextFilePanel myRightText = new TextFilePanel(this);
    JPanel myComparePanel = new JPanel(new BorderLayout());
    private int myCurrentIndex = -1;

    public TextComparePanel(TextCompareGUI gui) {
        this.myGUI = gui;
        this.clear();
        this.myList.addListSelectionListener(new TCListListener());
        this.myList.setPrototypeCellValue(new TextCompareListItem("foo", "bar"));
        this.myComparePanel.add((Component)new JScrollPane(this.myLeftText), "West");
        this.myComparePanel.add((Component)new JScrollPane(this.myRightText), "East");
        this.myStartBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextComparePanel.this.clear();
                TextComparePanel.this.doWork();
            }
        });
        this.myStopBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextComparePanel.this.myWorker.stop();
                TextComparePanel.this.myStopBtn.setEnabled(false);
            }
        });
        this.layoutGridBag();
    }

    void layoutGridBag() {
        this.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.anchor = 18;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.ipadx = 0;
        c.ipady = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.fill = 2;
        c.gridx = 0;
        this.add((Component)this.myStartBtn, c);
        c.gridx = 1;
        this.add((Component)this.myStopBtn, c);
        ++c.gridy;
        c.gridx = 0;
        c.gridwidth = 2;
        JPanel aPanel = new JPanel(new FlowLayout(0));
        aPanel.add(new JLabel("Progress:  "));
        aPanel.add(this.myCurrentAction);
        this.add((Component)aPanel, c);
        ++c.gridy;
        this.add((Component)this.myProgressBar, c);
        ++c.gridy;
        this.add((Component)new JLabel("  Duplicates:"), c);
        ++c.gridy;
        JScrollPane listSP = new JScrollPane(this.myList);
        listSP.setHorizontalScrollBarPolicy(32);
        listSP.setVerticalScrollBarPolicy(22);
        listSP.setPreferredSize(new Dimension(600, 120));
        this.add((Component)listSP, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        this.add((Component)this.myLeftText.getTextArea(), c);
        c.gridx = 1;
        this.add((Component)this.myRightText.getTextArea(), c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        c.gridx = 0;
        this.add((Component)this.myLeftText.getFilePanel(), c);
        c.gridx = 1;
        this.add((Component)this.myRightText.getFilePanel(), c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.myLeftText.getDeleteButton(), c);
        c.gridx = 1;
        this.add((Component)this.myRightText.getDeleteButton(), c);
    }

    void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            if (!file.delete()) {
                JOptionPane.showMessageDialog(this, "Could not delete: " + file, "File Delete", 0);
                return;
            }
            System.out.println("Deleted: " + file);
            this.myCurrentIndex = -1;
            this.myList.setSelectedIndex(-1);
            this.myLeftText.clear();
            this.myRightText.clear();
            for (int index = this.myPossibleDuplicates.getSize() - 1; index > -1; --index) {
                TextCompareListItem item = (TextCompareListItem)this.myPossibleDuplicates.get(index);
                System.out.println("Comparing: " + item);
                if (!item.getLeftFile().equals(file) && !item.getRightFile().equals(file)) continue;
                if (this.myPossibleDuplicates.remove(index) != null) {
                    System.out.println("Removed!");
                    continue;
                }
                System.out.println("Missing!");
            }
            this.myList.repaint();
            this.myList.setSelectedIndex(0);
            this.updateSelectedItem();
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "File Delete", 0);
        }
    }

    public void clear() {
        System.out.println("Clearing fields");
        this.myStartBtn.setEnabled(true);
        this.myStopBtn.setEnabled(false);
        this.myCurrentIndex = -1;
        this.myList.setSelectedIndex(-1);
        this.myProgressBar.getModel().setMaximum(50);
        this.myProgressBar.getModel().setValue(0);
        this.myLeftText.clear();
        this.myRightText.clear();
        this.myPossibleDuplicates.clear();
    }

    void updateSelectedItem() {
        int index = this.myList.getSelectedIndex();
        if (this.myCurrentIndex != index && index > -1) {
            this.myCurrentIndex = index;
            TextCompareListItem item = (TextCompareListItem)this.myPossibleDuplicates.get(this.myCurrentIndex);
            if (item != null) {
                try {
                    this.myLeftText.setFile(item.getLeftFile());
                    this.myRightText.setFile(item.getRightFile());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void doWork() {
        this.myWorker = new TextCompareWorker(this.myGUI.myWorkingList.getDirArray(), this.myPossibleDuplicates, this);
        Thread t = new Thread(this.myWorker);
        t.start();
    }

    class TCListListener
    implements ListSelectionListener {
        TCListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            TextComparePanel.this.updateSelectedItem();
        }
    }
}

