/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.games.missingTile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Random;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.games.missingTile.TilePanel;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;

public class MissingTile
extends JFrame {
    static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/games/MissingTile");
    static final String LAST_IMAGE = "lastImage";
    static final String LAST_DIRECTORY = "lastDirectory";
    private static final String TILE_COUNT = "tileCount";
    private static final String MOVES = " " + Jibs.getString("MissingTile.0");
    int myTileCount = 3;
    TilePanel myTilePanel;
    int myTestCount = 0;
    JButton myPlayBtn = new JButton(Jibs.getString("MissingTile.1"));
    JButton myFinishBtn = new JButton(Jibs.getString("MissingTile.2"));
    JLabel myMovesMade = new JLabel("0" + MOVES);
    boolean iExitOnClose;

    public MissingTile(boolean exitOnClose) {
        super(Jibs.getString("MissingTile.4"));
        this.iExitOnClose = exitOnClose;
        if (this.iExitOnClose) {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
        }
        this.myTileCount = clsPrefs.getInt(TILE_COUNT, this.myTileCount);
        this.setIconImage(Icons.icon(26).getImage());
        this.layoutComponents();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                MissingTile.this.pack();
                MissingTile.this.setVisible(true);
                SwingUtils.centerOnScreen(MissingTile.this);
                MissingTile.this.showLastPicture();
            }
        });
    }

    private void showLastPicture() {
        String imageName = clsPrefs.get(LAST_IMAGE, null);
        if (imageName != null) {
            try {
                IOImage ioImage = ImageFactory.getImageFactory().makeImage(new File(imageName));
                this.myTilePanel.setImage(ioImage.getImage());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void layoutComponents() {
        this.setSize(new Dimension(600, 600));
        JButton testBtn = new JButton("Test");
        testBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MissingTile.this.quit();
                ++MissingTile.this.myTestCount;
                MissingTile.this.myTilePanel.emptySeed(MissingTile.this.myTestCount);
                if (MissingTile.this.myTestCount >= MissingTile.this.myTilePanel.myTiles.length) {
                    MissingTile.this.myTestCount = 0;
                }
            }
        });
        JButton scrambleBtn = new JButton(Jibs.getString("MissingTile.6"));
        scrambleBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MissingTile.this.myTilePanel.scramble();
            }
        });
        this.myFinishBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MissingTile.this.finish();
            }
        });
        this.myPlayBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (MissingTile.this.myTilePanel.isGameInProgress) {
                    MissingTile.this.quit();
                } else {
                    MissingTile.this.pickEmpty();
                }
            }
        });
        JMenu fileMenu = new JMenu(Jibs.getString("MissingTile.21"));
        fileMenu.setMnemonic('F');
        class CloseAction
        extends AbstractAction {
            CloseAction() {
                if (MissingTile.this.iExitOnClose) {
                    super.putValue("Name", Jibs.getString("MissingTile.19"));
                    super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("X"));
                } else {
                    super.putValue("Name", Jibs.getString("MissingTile.20"));
                    super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("C"));
                }
            }

            public void actionPerformed(ActionEvent e) {
                if (MissingTile.this.iExitOnClose) {
                    System.exit(0);
                } else {
                    MissingTile.this.dispose();
                }
            }
        }
        fileMenu.add(new JMenuItem(new CloseAction()));
        JMenu imageMenu = new JMenu(Jibs.getString("MissingTile.22"));
        imageMenu.setMnemonic('I');
        class ImageAction
        extends AbstractAction {
            ImageAction() {
                super.putValue("Name", Jibs.getString("MissingTile.16"));
                super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("S"));
            }

            public void actionPerformed(ActionEvent e) {
                int returnVal;
                MissingTile.this.quit();
                JFileChooser chooser = new JFileChooser();
                chooser.setDialogTitle("Select Image to Show");
                chooser.setFileSelectionMode(2);
                String dirName = clsPrefs.get(MissingTile.LAST_DIRECTORY, null);
                if (dirName != null) {
                    chooser.setCurrentDirectory(new File(dirName));
                }
                if ((returnVal = chooser.showOpenDialog(MissingTile.this)) == 0) {
                    try {
                        String imageName = chooser.getSelectedFile().getCanonicalPath();
                        if (imageName == null) {
                            return;
                        }
                        IOImage ioImage = ImageFactory.getImageFactory().makeImage(new File(imageName));
                        MissingTile.this.myTilePanel.setImage(ioImage.getImage());
                        clsPrefs.put(MissingTile.LAST_IMAGE, imageName);
                        clsPrefs.put(MissingTile.LAST_DIRECTORY, imageName);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(MissingTile.this, ex.getMessage(), Jibs.getString("MissingTile.17"), 0);
                    }
                }
                MissingTile.this.quit();
            }
        }
        imageMenu.add(new JMenuItem(new ImageAction()));
        class PasteAction
        extends AbstractAction {
            PasteAction() {
                super.putValue("Name", Jibs.getString("paste"));
                KeyStroke ks = KeyStroke.getKeyStroke("control V");
                super.putValue("AcceleratorKey", ks);
                super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("P"));
            }

            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(this);
                DataFlavor[] flavors = transferable.getTransferDataFlavors();
                for (int i = 0; i < flavors.length; ++i) {
                    if (!DataFlavor.imageFlavor.equals(flavors[i])) continue;
                    try {
                        Object obj = transferable.getTransferData(DataFlavor.imageFlavor);
                        if (obj == null || !(obj instanceof Image)) continue;
                        MissingTile.this.myTilePanel.setImage((Image)obj);
                        continue;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        imageMenu.add(new JMenuItem(new PasteAction()));
        class TestPatternAction
        extends AbstractAction {
            TestPatternAction() {
                super.putValue("Name", Jibs.getString("MissingTile.18"));
                super.putValue("MnemonicKey", ActionHelpers.getKeyCodeAsInteger("T"));
            }

            public void actionPerformed(ActionEvent e) {
                clsPrefs.remove(MissingTile.LAST_IMAGE);
                MissingTile.this.myTilePanel.setImage(null);
            }
        }
        imageMenu.add(new JMenuItem(new TestPatternAction()));
        JMenu tileMenu = new JMenu(Jibs.getString("MissingTile.23"));
        tileMenu.setMnemonic('T');
        ButtonGroup tileCountGrp = new ButtonGroup();
        for (int i = 3; i < 9; ++i) {
            class CountAction
            extends AbstractAction {
                int myCount;
                JRadioButton myButton;

                CountAction(int count) {
                    this.myCount = count;
                    super.putValue("Name", Integer.toString(this.myCount));
                }

                public void actionPerformed(ActionEvent e) {
                    MissingTile.this.myTileCount = this.myCount;
                    clsPrefs.putInt(MissingTile.TILE_COUNT, this.myCount);
                    this.myButton.setSelected(clsPrefs.getInt(MissingTile.TILE_COUNT, 0) == MissingTile.this.myTileCount);
                    MissingTile.this.myTilePanel = new TilePanel(MissingTile.this, MissingTile.this.myTileCount);
                    MissingTile.this.getContentPane().add((Component)MissingTile.this.myTilePanel, "Center");
                    MissingTile.this.showLastPicture();
                    MissingTile.this.quit();
                }

                private void setButton(JRadioButton button) {
                    this.myButton = button;
                }
            }
            CountAction a = new CountAction(i);
            JRadioButton button = new JRadioButton(a);
            switch (i) {
                case 3: {
                    button.setMnemonic(51);
                    break;
                }
                case 4: {
                    button.setMnemonic(52);
                    break;
                }
                case 5: {
                    button.setMnemonic(53);
                    break;
                }
                case 6: {
                    button.setMnemonic(54);
                    break;
                }
                case 7: {
                    button.setMnemonic(55);
                    break;
                }
                case 8: {
                    button.setMnemonic(56);
                    break;
                }
                case 9: {
                    button.setMnemonic(57);
                }
            }
            a.setButton(button);
            tileMenu.add(button);
            tileCountGrp.add(button);
            button.setSelected(i == this.myTileCount);
        }
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(imageMenu);
        menuBar.add(tileMenu);
        this.setJMenuBar(menuBar);
        JPanelRows bottomPanel = new JPanelRows(1);
        JPanel row = bottomPanel.topRow();
        row.add(this.myMovesMade);
        row = bottomPanel.nextRow();
        row.add(this.myPlayBtn);
        row.add(scrambleBtn);
        this.myTilePanel = new TilePanel(this, this.myTileCount);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.myTilePanel, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.myFinishBtn.setEnabled(this.myTilePanel.isGameInProgress);
    }

    void finish() {
        this.quit();
    }

    void pickEmpty() {
        int seed = 1;
        Random random = new Random();
        int candidate = random.nextInt(this.myTilePanel.myTiles.length);
        if (candidate > 0) {
            seed = candidate;
        }
        this.myTilePanel.emptySeed(seed);
        this.myPlayBtn.setText(Jibs.getString("MissingTile.7"));
        this.myFinishBtn.setEnabled(this.myTilePanel.isGameInProgress);
    }

    void quit() {
        this.myPlayBtn.setText(Jibs.getString("MissingTile.8"));
        this.myTilePanel.resetGame();
        this.myTilePanel.repaint();
        this.myFinishBtn.setEnabled(this.myTilePanel.isGameInProgress);
    }

    void victory() {
        this.myPlayBtn.setText(Jibs.getString("MissingTile.9"));
        this.myFinishBtn.setEnabled(this.myTilePanel.isGameInProgress);
        this.myTilePanel.resetGame();
        this.myFinishBtn.setEnabled(this.myTilePanel.isGameInProgress);
        JOptionPane.showMessageDialog(this, Jibs.getString("MissingTile.10"), Jibs.getString("MissingTile.11"), 1);
    }

    void updateMovesMade(int moves) {
        this.myMovesMade.setText(Integer.toString(moves) + MOVES);
    }

    public static void main(String[] args) {
        new MissingTile(true);
    }
}

