/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.gerhardb.jibs.explorer.BoxPanel;
import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs6.diskUsage.JibsDiskUsage;
import org.gerhardb.lib.dirtree.DTNReader;
import org.gerhardb.lib.dirtree.DTNReaderWriter;
import org.gerhardb.lib.dirtree.DirectoryTree;
import org.gerhardb.lib.dirtree.DirectoryTreeNode;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.playlist.IScroll;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.startup.AppStarter;
import org.gerhardb.lib.util.startup.Loading;

public class ExplorerBox
extends JFrame {
    boolean iExitOnClose;
    boolean iShowLabel;
    BoxPanel myBoxPanel;
    long myTotalDiskSpace;
    private static final String PRIOR_DIR = "priorDir";
    private static final String PREF_PATH = "/org/gerhardb/jibs/lib/filetree/ExplorerBox";
    private Preferences myPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/lib/filetree/ExplorerBox");
    private boolean iCountImages;
    JLabel myDirName = new JLabel("", 0);
    JLabel myDiretoryCount = new JLabel("", 0);
    JLabel mySubDiretoryCount = new JLabel("", 0);
    JLabel myTotalDiretoryCount = new JLabel("", 0);
    JLabel myTotalAllFileCount = new JLabel("", 0);
    JLabel myTotalImageFileCount = new JLabel("", 0);
    JLabel myTotalAllFileSize = new JLabel("", 0);
    JLabel myTotalImageFileSize = new JLabel("", 0);
    JLabel myNodeFileCount = new JLabel("", 0);
    JLabel myNodeImageFileCount = new JLabel("", 0);
    JLabel myNodeFileSize = new JLabel("", 0);
    JLabel myNodeImageFileSize = new JLabel("", 0);
    JLabel mySubDirFileCount = new JLabel("", 0);
    JLabel mySubDirImageFileCount = new JLabel("", 0);
    JLabel mySubDirFileSize = new JLabel("", 0);
    JLabel mySubDirImageFileSize = new JLabel("", 0);
    JLabel myDateLabel = new JLabel(AppStarter.getString("date"), 2);
    DTNReaderWriter myReaderWriter;
    IScroll myScroller;
    private boolean iCountHiddenDirectories;
    boolean iShowFreeSpace = false;
    File[] myDrives;
    boolean iSupressRootDirectories;

    public ExplorerBox(boolean standAlone, boolean label, IScroll scroller, DTNReaderWriter dtn, boolean countHiddenDirectories, boolean showFreeSpace) {
        this.iExitOnClose = standAlone;
        this.iShowLabel = label;
        this.myScroller = scroller;
        this.iCountHiddenDirectories = countHiddenDirectories;
        this.iShowFreeSpace = showFreeSpace;
        ViewerPreferences.init();
        this.setIconImage(Icons.icon(26).getImage());
        this.myReaderWriter = dtn;
        JMenu driveMenu = new JMenu("Open Drive");
        this.myDrives = JibsDiskUsage.listDrives();
        for (int i = 0; i < this.myDrives.length; ++i) {
            driveMenu.add(new JMenuItem(new OpenRoot(this.myDrives[i])));
        }
        JMenu fileMenu = new JMenu(AppStarter.getString("file"));
        fileMenu.add(new JMenuItem(new OpenAction()));
        fileMenu.add(driveMenu);
        fileMenu.add(new JMenuItem(new ReloadTreeAction()));
        fileMenu.add(new JMenuItem(new CloseAction()));
        JMenuBar bar = new JMenuBar();
        bar.add(fileMenu);
        super.setJMenuBar(bar);
        if (this.iExitOnClose) {
            super.setDefaultCloseOperation(3);
        }
        this.myBoxPanel = new BoxPanel(this);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.add((Component)this.myBoxPanel, "Center");
        contentPanel.add((Component)this.infoPanel(), "South");
        super.getContentPane().add(contentPanel);
        int size = 700;
        super.setSize(size, size);
        SwingUtils.centerOnScreen(this);
        super.setVisible(true);
    }

    public void setRootNode(DirectoryTreeNode rootNode) {
        this.myBoxPanel.setRootNode(rootNode);
        this.setTitle(rootNode.getAbsolutePath());
    }

    public void setRootDirectory(final File rootDirectory, boolean supressRootDirectories) throws Exception {
        if (!rootDirectory.exists() || !rootDirectory.isDirectory()) {
            return;
        }
        this.iSupressRootDirectories = supressRootDirectories;
        final Loading loader = new Loading(this);
        Runnable runMe = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                DirectoryTreeNode rootNode = null;
                Date lastRead = null;
                try {
                    if (ExplorerBox.this.iShowFreeSpace) {
                        ExplorerBox.this.myTotalDiskSpace = rootDirectory.getTotalSpace();
                    }
                    File jibsTreeFile = new File(rootDirectory + System.getProperty("file.separator") + ExplorerBox.this.myReaderWriter.getFileName());
                    DirectoryTree tree = new DirectoryTree(ExplorerBox.this, ImageFactory.getImageFactory().getFilter(), null, ExplorerBox.this.myScroller, ExplorerBox.this.iCountHiddenDirectories);
                    tree.setCountTargetFiles(ViewerPreferences.countImageFilesInNodes());
                    if (ExplorerBox.this.iSupressRootDirectories) {
                        tree.setExcludedDirectories(ExplorerBox.this.myDrives);
                    }
                    DTNReader reader = ExplorerBox.this.myReaderWriter.getReader(jibsTreeFile, tree, loader);
                    ExplorerBox.this.iCountImages = reader.getImagesCounted();
                    lastRead = reader.getLastReadDate();
                    rootNode = reader.getRootNode();
                    if (rootNode == null) {
                        System.out.println("DISK USAGE STARTUP: MANUAL POPULATION");
                        rootNode = new DirectoryTreeNode(tree, rootDirectory, loader);
                        rootNode.populate(loader);
                        lastRead = new Date();
                        try {
                            ExplorerBox.this.myReaderWriter.getWriter().store(rootNode);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    loader.dispose();
                }
                if (rootNode == null) {
                    JOptionPane.showMessageDialog(ExplorerBox.this, "Unexpected Problem", AppStarter.getString("problem"), 0);
                    return;
                }
                if (ExplorerBox.this.iShowFreeSpace) {
                    int answer;
                    long actualUsedDiskSpace = ExplorerBox.this.myTotalDiskSpace - rootDirectory.getFreeSpace();
                    long recordedUsedDiskSpace = rootNode.getTreeTotals().aggregateTotalFileSize;
                    float percentage = 0.05f;
                    long overLimit = (long)((float)actualUsedDiskSpace * (1.0f + percentage));
                    long underLimit = (long)((float)actualUsedDiskSpace * (1.0f - percentage));
                    if ((recordedUsedDiskSpace > overLimit || recordedUsedDiskSpace < underLimit) && (answer = JOptionPane.showConfirmDialog(ExplorerBox.this, "The recorded size differs by more than 5% from the current size.\nDo you want to rescan the drive?\n", "Rescan Drive", 0)) == 0) {
                        rootNode.reloadNodes(ExplorerBox.this, ExplorerBox.this.iSupressRootDirectories, ExplorerBox.this.myReaderWriter.getWriter());
                    }
                }
                ExplorerBox.this.setRootNode(rootNode);
                if (lastRead == null) {
                    ExplorerBox.this.myDateLabel.setText(AppStarter.getString("ExplorerBox.24"));
                    ExplorerBox.this.myDateLabel.setBackground(Color.RED);
                } else {
                    ExplorerBox.this.myDateLabel.setText(AppStarter.getString("ExplorerBox.25") + DTNReaderWriter.DATE_FORMAT.format(lastRead));
                    long diff = new Date().getTime() - lastRead.getTime();
                    if (diff > 604800000L) {
                        ExplorerBox.this.myDateLabel.setBackground(Color.RED);
                    } else if (diff > 259200000L) {
                        ExplorerBox.this.myDateLabel.setBackground(Color.YELLOW);
                    } else {
                        ExplorerBox.this.myDateLabel.setBackground(Color.GREEN);
                    }
                    ExplorerBox.this.myDateLabel.invalidate();
                }
            }
        };
        loader.start(runMe);
    }

    JPanel infoPanel() {
        JPanel topPanel = new JPanel(new FlowLayout(1));
        topPanel.add(this.myDirName);
        JPanel gridPanel = new JPanel(new GridLayout(4, 3));
        gridPanel.add(new JLabel(" "));
        gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.27"), 0));
        gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.28"), 0));
        gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.29"), 0));
        gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.30")));
        gridPanel.add(this.myTotalDiretoryCount);
        gridPanel.add(this.myDiretoryCount);
        gridPanel.add(this.mySubDiretoryCount);
        gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.31")));
        gridPanel.add(this.myTotalAllFileCount);
        gridPanel.add(this.myNodeFileCount);
        gridPanel.add(this.mySubDirFileCount);
        gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.32")));
        gridPanel.add(this.myTotalAllFileSize);
        gridPanel.add(this.myNodeFileSize);
        gridPanel.add(this.mySubDirFileSize);
        if (this.iCountImages) {
            gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.33")));
            gridPanel.add(this.myTotalImageFileCount);
            gridPanel.add(this.myNodeImageFileCount);
            gridPanel.add(this.mySubDirImageFileCount);
            gridPanel.add(new JLabel(AppStarter.getString("ExplorerBox.34")));
            gridPanel.add(this.myTotalImageFileSize);
            gridPanel.add(this.myNodeImageFileSize);
            gridPanel.add(this.mySubDirImageFileSize);
        }
        this.myDateLabel.setOpaque(true);
        JPanel rtnMe = new JPanel(new BorderLayout());
        rtnMe.add((Component)topPanel, "North");
        rtnMe.add((Component)gridPanel, "Center");
        if (this.iShowLabel) {
            rtnMe.add((Component)this.myDateLabel, "South");
        }
        return rtnMe;
    }

    class ReloadTreeAction
    extends AbstractAction {
        ReloadTreeAction() {
            super.putValue("Name", AppStarter.getString("FileTreePopUp.4"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExplorerBox.this.myBoxPanel.myRootNode.reloadNodes(ExplorerBox.this, ExplorerBox.this.iSupressRootDirectories, ExplorerBox.this.myReaderWriter.getWriter());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            if (ExplorerBox.this.iExitOnClose) {
                super.putValue("Name", AppStarter.getString("SortScreen.menu.file.exit.label"));
            } else {
                super.putValue("Name", AppStarter.getString("close"));
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (ExplorerBox.this.iExitOnClose) {
                System.exit(0);
            } else {
                ExplorerBox.this.dispose();
            }
        }
    }

    class OpenRoot
    extends AbstractAction {
        File myDrive;

        OpenRoot(File drive) {
            super.putValue("Name", drive.toString());
            this.myDrive = drive;
        }

        public void actionPerformed(ActionEvent e) {
            ExplorerBox.this.iShowFreeSpace = true;
            try {
                ExplorerBox.this.setRootDirectory(this.myDrive, true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        OpenAction() {
            super.putValue("Name", AppStarter.getString("ExplorerBox.23"));
        }

        public void actionPerformed(ActionEvent e) {
            ExplorerBox.this.iShowFreeSpace = false;
            try {
                String priorDir = ExplorerBox.this.myPrefs.get(ExplorerBox.PRIOR_DIR, null);
                String newDirName = FileUtil.lookupDir(AppStarter.getString("ExplorerBox.36"), priorDir, ExplorerBox.this);
                if (newDirName == null) {
                    return;
                }
                File newDir = new File(newDirName);
                ExplorerBox.this.setRootDirectory(newDir, false);
                ExplorerBox.this.myPrefs.put(ExplorerBox.PRIOR_DIR, newDirName);
                ExplorerBox.this.myPrefs.flush();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

