/*
 * Decompiled with CFR 0.152.
 */
package org.gerhardb.jibs.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.image.ImageFactory;

public class PicturePanel
extends JPanel
implements MouseListener {
    protected static final Color OK_COLOR = Color.black;
    protected static final Color EMPTY_COLOR = Color.cyan;
    protected static final Color NFG_COLOR = Color.green;
    BufferedImage myImage;
    int myOffsetWidth;
    int myOffsetHeight;
    float myOffsetWidthPercentage;
    float myOffsetHeightPercentage;
    boolean iNeedToRepositionScrollBars = false;
    protected int myShownWidth;
    protected int myShownHeight;
    private JScrollPane myScrollPane = new JScrollPane(this, 20, 30);

    public PicturePanel() {
        super.addMouseListener(this);
    }

    public void setPictureFile(File picFile) {
        if (picFile != null) {
            this.myImage = ImageFactory.getImageFactory().getImageEZ(picFile);
        }
    }

    public Component getImageDisplay() {
        return this.myScrollPane;
    }

    public void paint(Graphics g) {
        Color backgroundColor = OK_COLOR;
        super.setBackground(backgroundColor);
        super.paintComponent(g);
        BufferedImage showMe = this.myImage;
        if (showMe == null) {
            this.showNoPicture(g);
            return;
        }
        backgroundColor = EMPTY_COLOR;
        this.myShownWidth = showMe.getWidth();
        this.myShownHeight = showMe.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        this.myOffsetWidth = (int)((float)(this.getWidth() - this.myShownWidth) * this.myOffsetWidthPercentage);
        this.myOffsetHeight = (int)((float)(this.getHeight() - this.myShownHeight) * this.myOffsetHeightPercentage);
        Dimension size = new Dimension(this.myShownWidth, this.myShownHeight);
        this.setPreferredSize(size);
        this.revalidate();
        super.setBackground(backgroundColor);
        super.paintComponent(g);
        g2.drawImage(showMe, null, this.myOffsetWidth, this.myOffsetHeight);
        if (this.iNeedToRepositionScrollBars) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    PicturePanel.this.positionPicture();
                }
            });
            this.iNeedToRepositionScrollBars = false;
        }
    }

    protected void showNoPicture(Graphics g) {
        super.setBackground(NFG_COLOR);
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        Font font = new Font("Default", 0, 24);
        FontRenderContext fontRenderContext = g2.getFontRenderContext();
        TextLayout text = new TextLayout(Jibs.getString("PicturePanel.0"), font, fontRenderContext);
        int xCenter = this.getWidth() / 2;
        int yCenter = this.getHeight() / 2;
        int textX = xCenter - (int)text.getBounds().getWidth() / 2;
        int textY = (int)((float)yCenter - text.getDescent());
        text.draw(g2, textX, textY);
    }

    public void mouseClicked(MouseEvent event) {
        this.getToolkit().beep();
        if (event.getX() < this.myImage.getWidth() && event.getY() < this.myImage.getHeight()) {
            this.rasterSwap(event.getX(), event.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    void positionPicture() {
        JViewport vp = this.myScrollPane.getViewport();
        Rectangle vpRect = vp.getViewRect();
        Dimension vpExtent = vp.getExtentSize();
        Dimension vpViewSize = vp.getViewSize();
        JScrollBar hBar = this.myScrollPane.getHorizontalScrollBar();
        JScrollBar vBar = this.myScrollPane.getVerticalScrollBar();
        if (vpExtent.width != vpViewSize.width) {
            this.myOffsetWidth = (int)((float)(hBar.getMaximum() - (int)vpRect.getWidth()) * this.myOffsetWidthPercentage);
        }
        if (vpExtent.height != vpViewSize.height) {
            this.myOffsetHeight = (int)((float)(vBar.getMaximum() - (int)vpRect.getHeight()) * this.myOffsetHeightPercentage);
        }
        Point newPosition = new Point(this.myOffsetWidth, this.myOffsetHeight);
        vp.setViewPosition(newPosition);
    }

    void rasterSwapTest(int x, int y) {
        System.out.println("---------------------------------");
        BufferedImage pic = this.myImage;
        WritableRaster alphaRaster = pic.getAlphaRaster();
        if (alphaRaster == null) {
            System.out.println("Alpha is null");
        } else {
            System.out.println("Alpha");
        }
        System.out.println("---------------------------------");
        String[] props = pic.getPropertyNames();
        if (props != null) {
            for (int i = 0; i < props.length; ++i) {
                System.out.println("Property: " + props[i]);
            }
        }
        ColorModel colorModel = pic.getColorModel();
        System.out.println("Color Model: " + colorModel);
        WritableRaster raster = pic.getRaster();
        System.out.println("Number of Bands: " + raster.getNumBands());
        System.out.println("Number of Data Elements: " + raster.getNumDataElements());
        int[] pixel = raster.getPixel(x, y, (int[])null);
        System.out.println("Pixel Length: " + pixel.length);
        for (int i = 0; i < pixel.length; ++i) {
            System.out.println(pixel[i]);
        }
        System.out.println("Sample: " + raster.getSample(x, y, 0));
        SampleModel model = raster.getSampleModel();
        System.out.println("Sample Model: " + model);
        System.out.println("Trasfer Type: " + raster.getTransferType());
        int[] sampleBits = model.getSampleSize();
        for (int i = 0; i < sampleBits.length; ++i) {
            System.out.println(sampleBits[i]);
        }
        int rgb = pic.getRGB(x, y);
        System.out.println("rgb: " + rgb);
        System.out.println("alpha: " + colorModel.getAlpha(pixel[0]));
        System.out.println("red: " + colorModel.getRed(pixel[0]));
        System.out.println("green: " + colorModel.getGreen(pixel[0]));
        System.out.println("blue: " + colorModel.getBlue(pixel[0]));
        System.out.println("Transparent Pixel: " + ((IndexColorModel)colorModel).getTransparentPixel());
        System.out.println("Number of Color Components: " + colorModel.getNumColorComponents());
        System.out.println("Number of Components: " + colorModel.getNumComponents());
        int[] sizes = colorModel.getComponentSize();
        System.out.println("Red Component Size: " + sizes[0]);
        System.out.println("Green Component Size: " + sizes[1]);
        System.out.println("Blue Component Size: " + sizes[2]);
        IndexColorModel oldICM = (IndexColorModel)colorModel;
        int mapSize = oldICM.getMapSize();
        System.out.println("Map Size: " + mapSize);
        byte[] r = new byte[mapSize];
        byte[] g = new byte[mapSize];
        byte[] b = new byte[mapSize];
        byte[] a = new byte[mapSize];
        oldICM.getReds(r);
        oldICM.getGreens(g);
        oldICM.getBlues(b);
        oldICM.getAlphas(a);
        a[0] = 0;
        for (int i = 0; i < 16; ++i) {
            System.out.println(i + ": " + " r " + r[i] + " b " + b[i] + " g " + g[i] + " a " + a[i]);
        }
        IndexColorModel icm = oldICM;
        icm = new IndexColorModel(colorModel.getPixelSize(), 16, r, g, b, a);
        System.out.println("icm Transparent Pixel: " + icm.getTransparentPixel());
        WritableRaster newRaster = raster.createCompatibleWritableRaster();
        BufferedImage newPic = new BufferedImage(icm, newRaster, icm.isAlphaPremultiplied(), null);
        int[] transparent = new int[]{0};
        for (int xi = 0; xi < pic.getWidth(); ++xi) {
            for (int yi = 0; yi < pic.getHeight(); ++yi) {
                int currentRGB = pic.getRGB(xi, yi);
                if (currentRGB == rgb) {
                    newPic.setRGB(xi, yi, 0);
                    continue;
                }
                newPic.setRGB(xi, yi, currentRGB);
            }
        }
        try {
            ImageIO.write((RenderedImage)newPic, "gif", new File("d:/testpics/grindstoneTEST.gif"));
            System.out.println("Wrote GIF");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            ImageIO.write((RenderedImage)newPic, "png", new File("d:/testpics/grindstoneTEST.png"));
            System.out.println("Wrote PNG");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void rasterSwap(int x, int y) {
        System.out.println("RasterSwap---------------------------------");
        int rgb = this.myImage.getRGB(x, y);
        System.out.println("rgb: " + rgb);
        WritableRaster raster = this.myImage.getRaster();
        IndexColorModel oldICM = (IndexColorModel)this.myImage.getColorModel();
        int mapSize = oldICM.getMapSize();
        System.out.println("Map Size: " + mapSize);
        byte[] r = new byte[mapSize];
        byte[] g = new byte[mapSize];
        byte[] b = new byte[mapSize];
        byte[] a = new byte[mapSize];
        oldICM.getReds(r);
        oldICM.getGreens(g);
        oldICM.getBlues(b);
        oldICM.getAlphas(a);
        a[0] = 0;
        IndexColorModel icm = new IndexColorModel(oldICM.getPixelSize(), 256, r, g, b, a);
        WritableRaster newRaster = raster.createCompatibleWritableRaster();
        BufferedImage newPic = new BufferedImage(icm, newRaster, icm.isAlphaPremultiplied(), null);
        for (int xi = 0; xi < this.myImage.getWidth(); ++xi) {
            for (int yi = 0; yi < this.myImage.getHeight(); ++yi) {
                int currentRGB = this.myImage.getRGB(xi, yi);
                if (currentRGB == rgb) {
                    newPic.setRGB(xi, yi, 0);
                    continue;
                }
                newPic.setRGB(xi, yi, currentRGB);
            }
        }
        this.myImage = newPic;
        this.repaint();
    }
}

