/*
 * Decompiled with CFR 0.152.
 */
package com.saic.isd.printscreen;

import com.saic.isd.swing.filechooser.SimpleFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.gerhardb.lib.print.PrintableText;
import org.gerhardb.lib.util.startup.AppStarter;

public class Util {
    public static void printHtml(String printMe) {
        Util.print(printMe, new HTMLEditorKit());
    }

    public static void previewHTML(Component owner, String title, String printMe) {
        if (title == null) {
            title = AppStarter.getString("print.preview");
        }
        if (owner instanceof Frame) {
            Util.preview(new JDialog((Frame)owner, title, false), printMe, new HTMLEditorKit());
        } else if (owner instanceof Dialog) {
            Util.preview(new JDialog((Dialog)owner, title, false), printMe, new HTMLEditorKit());
        } else {
            Util.preview(new JDialog((Dialog)null, title, false), printMe, new HTMLEditorKit());
        }
    }

    public static void printText(String printMe) {
        Util.print(printMe, new StyledEditorKit());
    }

    public static void previewText(Component owner, String title, String printMe) {
        if (title == null) {
            title = AppStarter.getString("print.preview");
        }
        if (owner instanceof Frame) {
            Util.preview(new JDialog((Frame)owner, title, false), printMe, new StyledEditorKit());
        } else if (owner instanceof Dialog) {
            Util.preview(new JDialog((Dialog)owner, title, false), printMe, new StyledEditorKit());
        } else {
            Util.preview(null, printMe, new StyledEditorKit());
        }
    }

    public static void preview(JDialog dialog, String printMe, EditorKit kit) {
        final JDialog previewDlg = dialog;
        JEditorPane pane = new JEditorPane();
        pane.setEditorKit(kit);
        pane.setText(printMe);
        pane.validate();
        pane.setEditable(false);
        final String prtThis = printMe;
        final EditorKit theKit = kit;
        JButton okBtn = new JButton(AppStarter.getString("print"));
        okBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                Util.print(prtThis, theKit);
            }
        });
        JButton cancelBtn = new JButton(AppStarter.getString("cancel"));
        cancelBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                previewDlg.dispose();
            }
        });
        JPanel btnPanel = new JPanel(new FlowLayout(1));
        btnPanel.add(okBtn);
        btnPanel.add(cancelBtn);
        Container contentPane = previewDlg.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)new JScrollPane(pane), "Center");
        contentPane.add((Component)btnPanel, "South");
        previewDlg.setSize(800, 600);
        previewDlg.setVisible(true);
    }

    public static void print(String printMe, EditorKit kit) {
        JEditorPane pane = new JEditorPane();
        pane.setEditorKit(kit);
        pane.setText(printMe);
        pane.validate();
        PrintableText pt = new PrintableText(pane);
        pt.printContent();
    }

    public static HTMLDocument getHTMLDocument(String convertMe) throws IOException, BadLocationException {
        StringReader reader = new StringReader(convertMe);
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument rtnMe = (HTMLDocument)kit.createDefaultDocument();
        kit.read(reader, (Document)rtnMe, 0);
        return rtnMe;
    }

    public static InputStream stringToInputStream(String convertMe) {
        byte[] bytes = null;
        try {
            bytes = convertMe.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return new ByteArrayInputStream(bytes);
    }

    public static String getTextFromFile(File file) throws FileNotFoundException, IOException {
        BufferedReader buffRead = new BufferedReader(new FileReader(file));
        StringBuffer buff = new StringBuffer(5000);
        String appendMe = buffRead.readLine();
        while (appendMe != null) {
            buff.append(appendMe + "\n");
            appendMe = buffRead.readLine();
        }
        String html = buff.toString();
        return html;
    }

    public static void writeTextToFile(File file, String write) throws IOException {
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        writer.print(write);
        writer.flush();
        writer.close();
    }

    public static File getUserHomeDirectory() {
        StringBuffer buf = new StringBuffer(80);
        buf.append(System.getProperty("user.home"));
        buf.append(File.separator);
        buf.append("data");
        File rtnMe = new File(buf.toString());
        if (!rtnMe.exists()) {
            rtnMe.mkdirs();
        } else if (rtnMe.isFile()) {
            rtnMe = rtnMe.getParentFile();
        }
        return rtnMe;
    }

    public static void copyToClipboard(String contents) {
        StringSelection clip = new StringSelection(contents);
        Clipboard clipboard = new JLabel().getToolkit().getSystemClipboard();
        clipboard.setContents(clip, clip);
    }

    public static void saveToFile(String contents, SimpleFileFilter filter, Component component) {
        JFileChooser chooser = new JFileChooser(Util.getUserHomeDirectory());
        chooser.addChoosableFileFilter(filter);
        chooser.setFileFilter(filter);
        int returnVal = chooser.showSaveDialog(component);
        if (returnVal == 0) {
            File file = filter.attachExtension(chooser.getSelectedFile());
            try {
                FileWriter stream = new FileWriter(file);
                stream.write(contents);
                stream.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(component, ex.getMessage(), AppStarter.getString("problem"), 0);
            }
        }
    }
}

