/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalFileChooserUI;
import jdomain.util.gui.FileBrowser;
import jdomain.util.gui.IconViewer;

public class FileBrowserUI
extends MetalFileChooserUI
implements ChangeListener {
    private final FileBrowser chooser;
    public static final String FILE_BROWSER_UI = "jdomain.util.gui.FileBrowserUI";
    private static boolean usePreview = System.getProperty("nopreview") == null;
    private JCheckBox previewCheck;
    private IconViewer viewer;

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent instanceof FileBrowser) {
            return new FileBrowserUI((FileBrowser)jComponent);
        }
        return new MetalFileChooserUI((JFileChooser)jComponent);
    }

    public FileBrowserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
        this.chooser = usePreview && jFileChooser instanceof FileBrowser ? (FileBrowser)jFileChooser : null;
    }

    protected IconViewer getViewer() {
        return this.viewer;
    }

    public final void selectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.isFileBrowser()) {
            this.viewer.selectionChanged(propertyChangeEvent);
        }
    }

    private boolean isFileBrowser() {
        return this.chooser != null;
    }

    public void hideViewer() {
        if (this.isFileBrowser() && usePreview) {
            this.getModel().removeListDataListener(this.viewer);
            this.getBottomPanel().remove(this.viewer);
            this.updateDialog();
        }
    }

    public void rebuildViewer() {
        if (this.isFileBrowser()) {
            this.viewer.rebuild();
        }
    }

    public void installComponents(JFileChooser jFileChooser) {
        jFileChooser.setApproveButtonText("OK");
        jFileChooser.setApproveButtonToolTipText("OK");
        super.installComponents(jFileChooser);
        if (this.isFileBrowser()) {
            this.viewer = new IconViewer(this.getModel());
            this.previewCheck = new JCheckBox("Show Preview");
            JPanel jPanel = this.getBottomPanel();
            JPanel jPanel2 = this.getButtonPanel();
            JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
            jPanel.remove(jPanel2);
            jPanel.add(jPanel3);
            jPanel3.add((Component)this.previewCheck, "West");
            this.previewCheck.setVerticalAlignment(3);
            this.previewCheck.setBorder(new EmptyBorder(0, 0, 4, 0));
            jPanel3.add((Component)jPanel2, "East");
            this.previewCheck.setSelected(usePreview);
            this.previewCheck.addChangeListener(this);
            if (usePreview) {
                jPanel.add(this.viewer);
            }
        }
    }

    public void showViewer() {
        if (this.isFileBrowser() && usePreview) {
            this.getModel().addListDataListener(this.viewer);
            this.getBottomPanel().add(this.viewer);
            this.viewer.updateSelection();
            this.updateDialog();
        }
    }

    private void updateDialog() {
        if (this.chooser.getDialog() != null) {
            this.chooser.getDialog().pack();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.previewCheck.isSelected()) {
            this.showViewer();
        } else {
            this.hideViewer();
        }
    }
}

