/*
 * Decompiled with CFR 0.152.
 */
package jdomain.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import jdomain.util.Log;

public final class PropertyHelper {
    private static final String MISSING_VALUE = "???";
    private final ResourceBundle bundle;
    private final MessageFormat format;

    public PropertyHelper(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
        this.format = new MessageFormat("");
        this.format.setLocale(resourceBundle.getLocale());
    }

    public Object getObject(String string) {
        try {
            return this.bundle.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.warning("Property " + string + " not found.");
            return MISSING_VALUE;
        }
    }

    public String getString(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Log.warning("Property " + string + " not found.");
            return MISSING_VALUE;
        }
    }

    public String getString(String string, Object[] objectArray) {
        try {
            this.format.applyPattern(this.getString(string));
            return this.format.format(objectArray);
        }
        catch (Exception exception) {
            Log.exception(exception);
            return MISSING_VALUE;
        }
    }
}

