/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui.undo;

import java.awt.Rectangle;
import java.util.ArrayList;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.data.Pixel;
import jdomain.jdraw.gui.TextTool;
import jdomain.jdraw.gui.ToolPanel;
import jdomain.jdraw.gui.undo.DrawPixel;
import jdomain.jdraw.gui.undo.Undoable;

public final class DrawClip
extends Undoable {
    private final DrawPixel drawPixel;

    public DrawClip(int n, int n2, Clip clip) {
        this.drawPixel = this.getPixels(clip, n, n2);
    }

    private DrawPixel getPixels(Clip clip, int n, int n2) {
        int n3 = clip.getWidth();
        int n4 = clip.getHeight();
        ArrayList<Pixel> arrayList = new ArrayList<Pixel>();
        if (ToolPanel.INSTANCE.getCurrentTool() instanceof TextTool) {
            clip = TextTool.INSTANCE.createClip(n, n2, n3, n4);
        }
        Rectangle rectangle = this.frame.getBounds();
        int n5 = clip.getTransparentColour();
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                int n6;
                if (!rectangle.contains(j, i) || (n6 = clip.getPixel(j - n, i - n2)) == n5) continue;
                arrayList.add(new Pixel(j, i, this.frame.getPixel(j, i), n6));
            }
        }
        Pixel[] pixelArray = new Pixel[arrayList.size()];
        arrayList.toArray(pixelArray);
        return new DrawPixel(pixelArray);
    }

    public boolean isValid() {
        return this.drawPixel.isValid();
    }

    public void redo() {
        this.drawPixel.redo();
    }

    public void undo() {
        this.drawPixel.undo();
    }
}

