/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui.dnd;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.TooManyListenersException;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import jdomain.jdraw.gui.FrameSettingsDialog;
import jdomain.util.Assert;
import jdomain.util.Log;

public final class FrameDragger
implements DragSourceListener,
DragGestureListener,
DropTargetListener {
    private final JList frameList;
    private final DragSource source;
    private FrameSettingsDialog.FrameEntry entry;
    private int action;
    private int originalPosition;
    private boolean dndStarted = false;

    public FrameDragger(JList jList) {
        this.frameList = jList;
        this.source = new DragSource();
        this.source.createDefaultDragGestureRecognizer(jList, 3, this);
        DropTarget dropTarget = new DropTarget();
        dropTarget.setComponent(this.frameList);
        try {
            dropTarget.addDropTargetListener(this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            Log.exception(tooManyListenersException);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        this.dndStarted = false;
    }

    public void copyFrame(Point point) {
        DefaultListModel defaultListModel = (DefaultListModel)this.frameList.getModel();
        int n = this.getListIndex(point);
        this.frameList.clearSelection();
        if (n == -1) {
            defaultListModel.addElement(this.entry.createCopy());
            this.frameList.setSelectedIndex(defaultListModel.getSize() - 1);
        } else {
            defaultListModel.insertElementAt(this.entry.createCopy(), n + 1);
            this.frameList.setSelectedIndex(n + 1);
        }
    }

    public void moveFrame(Point point) {
        DefaultListModel defaultListModel = (DefaultListModel)this.frameList.getModel();
        int n = defaultListModel.getSize();
        if (n == 1) {
            return;
        }
        int n2 = this.getListIndex(point);
        if (n2 == -1) {
            n2 = n;
        }
        if (n2 != this.originalPosition) {
            this.frameList.clearSelection();
            defaultListModel.removeElement(this.entry);
            if (n2 == n) {
                --n2;
            }
            if (n2 == (n = defaultListModel.getSize())) {
                defaultListModel.addElement(this.entry.createIdenticalCopy());
                this.frameList.setSelectedIndex(n);
            } else {
                defaultListModel.insertElementAt(this.entry.createIdenticalCopy(), n2);
                this.frameList.setSelectedIndex(n2);
            }
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        this.action = dragSourceDragEvent.getUserAction();
        if (this.action == 1) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (this.action == 2) {
            dragSourceDragEvent.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        }
    }

    private final int getListIndex(Point point) {
        int n = this.frameList.getFixedCellHeight();
        Assert.isTrue(n != -1, "dnd: frame list must have fixed row height");
        int n2 = 0;
        int n3 = this.frameList.getModel().getSize();
        for (int i = 0; i < n3; ++i) {
            if (point.y >= n2 && point.y < n2 + n) {
                return i;
            }
            n2 += n;
        }
        return -1;
    }

    private FrameSettingsDialog.FrameEntry findFrameEntry(Point point) {
        this.originalPosition = this.getListIndex(point);
        return (FrameSettingsDialog.FrameEntry)this.frameList.getModel().getElementAt(this.originalPosition);
    }

    private void start(DragGestureEvent dragGestureEvent) {
        if (this.dndStarted) {
            Log.info("Drag'N Drop already started.");
            return;
        }
        this.dndStarted = true;
        this.entry = this.findFrameEntry(dragGestureEvent.getDragOrigin());
        Assert.notNull(this.entry, "dnd: no frame entry found");
        Cursor cursor = DragSource.DefaultMoveDrop;
        if (dragGestureEvent.getDragAction() == 1) {
            cursor = DragSource.DefaultCopyDrop;
        }
        this.source.startDrag(dragGestureEvent, cursor, this.entry, this);
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.action = dragGestureEvent.getDragAction();
        if (this.action == 1 || this.action == 2) {
            this.start(dragGestureEvent);
        } else if (Log.DEBUG) {
            Log.debug("drag gesture ignored");
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.action == 1) {
            this.copyFrame(dropTargetDropEvent.getLocation());
        } else if (this.action == 2) {
            this.moveFrame(dropTargetDropEvent.getLocation());
        } else {
            Log.warning("Drag action '" + this.action + "' not supported.");
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }
}

