/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gui;

import java.awt.Cursor;
import java.awt.Point;
import jdomain.jdraw.data.Clip;
import jdomain.jdraw.gui.ClipPanel;
import jdomain.jdraw.gui.FolderPanel;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.MouseHandler;
import jdomain.jdraw.gui.RectangularSelectionTool;
import jdomain.jdraw.gui.Tool;

public final class ClipTool
extends RectangularSelectionTool {
    private final ClipPanel clipPanel = new ClipPanel(true);

    protected void processSelection(int n) {
        if (this.isValidSelection()) {
            Clip clip = Tool.getCurrentFrame().createClip(this.upperLeft.x, this.upperLeft.y, this.width, this.height);
            this.clipPanel.setClip(this.upperLeft.x, this.upperLeft.y, clip);
        }
    }

    public void pressed(int n, Point point, int n2) {
        if (n == 0) {
            this.clipPanel.deactivate();
            this.setSwallowKeys(true);
            if (this.isDragged()) {
                this.lastAction = 1;
                if (point != null) {
                    this.drawRubberBand();
                    this.current = point;
                    this.drawRubberBand();
                }
            } else {
                this.lastAction = 2;
                this.start = point;
                this.current = null;
            }
        }
    }

    public void activate() {
        if (!this.isActive) {
            super.activate();
            MouseHandler.INSTANCE.addClip(this.clipPanel);
            FolderPanel.addGridListener(this.clipPanel);
        }
    }

    public void deactivate() {
        if (this.isActive) {
            super.deactivate();
            this.clipPanel.deactivate();
            MouseHandler.INSTANCE.deleteClip(this.clipPanel);
            MainFrame.INSTANCE.setCursor(Cursor.getDefaultCursor());
            this.clipPanel.deactivate();
            FolderPanel.removeGridListener(this.clipPanel);
        }
    }
}

