/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw.gio;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import jdomain.jdraw.data.ColourEntry;
import jdomain.jdraw.data.Frame;
import jdomain.jdraw.data.Palette;
import jdomain.jdraw.data.Picture;
import jdomain.util.Assert;
import jdomain.util.Log;
import jdomain.util.SimpleLogListener;

public final class ImageReader {
    private final ImageIcon icon;
    private Picture picture;
    private Palette pal;
    private Frame frame;
    private int width;
    private int height;
    private int[] grabbedPixels;
    private final ArrayList transColours = new ArrayList();

    private ImageReader(ImageIcon imageIcon) {
        this.icon = imageIcon;
    }

    public static Picture readImage(String string) {
        return ImageReader.readImage(new ImageIcon(string));
    }

    public static Picture readImage(ImageIcon imageIcon) {
        ImageReader imageReader = new ImageReader(imageIcon);
        try {
            Picture picture = imageReader.readImage();
            Palette palette = picture.getPalette();
            while (palette.size() < 2) {
                palette.addColour(Color.white);
            }
            picture.show();
            return picture;
        }
        catch (Exception exception) {
            Log.exception(exception);
            imageReader.picture = null;
            imageReader.pal = null;
            return null;
        }
    }

    private Picture readImage() throws Exception {
        Image image = this.icon.getImage();
        this.width = this.icon.getIconWidth();
        this.height = this.icon.getIconHeight();
        this.grabbedPixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.grabbedPixels, 0, this.width);
        try {
            if (!pixelGrabber.grabPixels()) {
                if (Log.DEBUG) {
                    Log.debug("gio: grabbing pixels failed");
                }
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            Log.exception(interruptedException);
            return null;
        }
        return this.createPicture(pixelGrabber);
    }

    private Picture createPicture(PixelGrabber pixelGrabber) {
        this.picture = new Picture(this.width, this.height);
        this.pal = new Palette(this.picture);
        this.picture.setPalette(this.pal);
        this.frame = this.picture.addFrame();
        int n = 0;
        for (int i = 0; i < this.height; ++i) {
            for (int j = 0; j < this.width; ++j) {
                int n2 = this.indexOfPixelColour(this.grabbedPixels[n]);
                this.frame.setPixelQuiet(j, i, n2);
                ++n;
            }
        }
        this.setTransparency();
        return this.picture;
    }

    private final int indexOfPixelColour(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = n >> 24 & 0xFF;
        Color color = new Color(n2, n3, n4, n5);
        int n6 = this.pal.findColour(color);
        if (n6 == -1) {
            n6 = this.pal.size();
            this.pal.addColour(color);
            if (n5 == 0) {
                this.transColours.add(color);
            }
        }
        ColourEntry colourEntry = this.pal.getColour(n6);
        colourEntry.increaseUsed();
        return n6;
    }

    private void setTransparency() {
        ColourEntry colourEntry;
        Color color;
        ColourEntry colourEntry2 = null;
        Iterator iterator = this.transColours.iterator();
        while (iterator.hasNext()) {
            color = (Color)iterator.next();
            colourEntry = this.pal.findMaxUsedColorEntryForColour(color);
            Assert.notNull(colourEntry, "colour not found");
            if (colourEntry2 != null && colourEntry2.getUsedCount() >= colourEntry.getUsedCount()) continue;
            colourEntry2 = colourEntry;
        }
        if (colourEntry2 != null) {
            iterator = this.transColours.iterator();
            while (iterator.hasNext()) {
                color = (Color)iterator.next();
                colourEntry = this.pal.findMaxUsedColorEntryForColour(color);
                if (colourEntry == colourEntry2) continue;
                this.pal.replaceColour(colourEntry.getIndex(), colourEntry2.getIndex());
                colourEntry.reset();
            }
            this.pal.purgeColours();
            this.picture.setTransparent(colourEntry2.getIndex());
        }
    }

    public static void main(String[] stringArray) {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Log.addLogListener(simpleLogListener);
        ImageReader.readImage("C:/Java/Projects/JDraw/penguin.png");
    }
}

