/*
 * Decompiled with CFR 0.152.
 */
package jdomain.jdraw;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jdomain.jdraw.Settings;
import jdomain.jdraw.action.LoadAction;
import jdomain.jdraw.data.Picture;
import jdomain.jdraw.gui.DrawBrowser;
import jdomain.jdraw.gui.DrawDialog;
import jdomain.jdraw.gui.DrawMenu;
import jdomain.jdraw.gui.MainFrame;
import jdomain.jdraw.gui.ToolPanel;
import jdomain.util.Log;
import jdomain.util.ResourceFinder;
import jdomain.util.ResourceLoader;
import jdomain.util.SimpleLogListener;
import jdomain.util.Util;
import jdomain.util.gui.GUIUtil;

public final class Main {
    private static final int SPLASH_DELAY = 1000;
    public static final String APP_NAME = "JDraw";
    public static final String VERSION_NUMBER = "v1.1.5";
    public static final String VERSION = "v1.1.5 - December 2005";
    public static final String EMAIL = "<font color=blue>jdraw@j-domain.de</font>";
    public static final String WWW = "<font color=blue>www.j-domain.de</font>";
    public static final String WWW_JDRAW = "<font color=blue>www.j-domain.de</font>/de/software/jdraw";
    public static final String SF_WWW_JDRAW = "jdraw.sourceforge.net";

    private Main() {
    }

    private static void setupUI(String[] stringArray) {
        LookAndFeel lookAndFeel = GUIUtil.findLF(stringArray);
        try {
            UIManager.setLookAndFeel(lookAndFeel);
            Object[] objectArray = new Object[]{"FileChooserUI", "jdomain.util.gui.FileBrowserUI", "TitledBorder.font", new FontUIResource(MainFrame.DEFAULT_FONT)};
            UIManager.getDefaults().putDefaults(objectArray);
        }
        catch (Exception exception) {
            Log.exception(exception);
        }
    }

    private static void preload() {
        String[] stringArray = new String[]{".gif", ".png"};
        String string = "jdomain/jdraw/images";
        ResourceFinder resourceFinder = new ResourceFinder(string, stringArray);
        String[] stringArray2 = resourceFinder.findResources();
        string = resourceFinder.getPath();
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray2[i].substring(stringArray2[i].lastIndexOf(string));
            string2 = string2.replace('\\', '/');
            ResourceLoader.getImage(string2);
        }
    }

    public static boolean isVisible(Picture picture) {
        return picture == MainFrame.INSTANCE.getPicture();
    }

    public static final void setPicture(Picture picture) {
        MainFrame.INSTANCE.setPicture(picture);
    }

    public static final void main(String[] stringArray) {
        ResourceLoader.scalingHint = 4;
        Main.setupUI(stringArray);
        DrawDialog drawDialog = new DrawDialog(null, "JDraw Splash", true);
        drawDialog.setModal(false);
        ImageIcon imageIcon = ResourceLoader.getImage("jdomain/jdraw/images/logo.png");
        drawDialog.getContentPane().add(new JLabel(imageIcon));
        drawDialog.open();
        Main.preload();
        Picture picture = null;
        int n = stringArray.length;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (stringArray[i] == null) continue;
                picture = LoadAction.readImage(stringArray[i]);
                break;
            }
        }
        if (picture == null) {
            picture = Picture.createDefaultPicture();
        }
        Main.setPicture(picture);
        ResourceLoader.getImage("jdomain/jdraw/images/background.gif");
        Util.delay(1000L);
        drawDialog.close();
        ((DrawMenu)MainFrame.INSTANCE.getJMenuBar()).buildLastFilesMenu();
        DrawBrowser.INSTANCE.setOpenDir(Settings.INSTANCE.getOpenDir());
        DrawBrowser.INSTANCE.setSaveDir(Settings.INSTANCE.getSaveDir());
        ToolPanel.INSTANCE.getCurrentTool().activate();
        MainFrame.INSTANCE.setVisible(true);
        Log.info("Happy drawing!");
    }

    static {
        SimpleLogListener simpleLogListener = new SimpleLogListener(System.out);
        Log.addLogListener(simpleLogListener);
        if (System.getProperty("log2file") != null) {
            try {
                String string = System.getProperty("user.home") + File.separatorChar + "jdraw.log";
                Log.addLogListener(new SimpleLogListener(new PrintStream(new FileOutputStream(string))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.exception(fileNotFoundException);
            }
        }
    }
}

