#include <stdio.h>
#include <pnm.h>
#include "Unshake.h"

  /* NB In Unshake coordinates are (x, y) rather than the convention
     (y, x) most easily implemented in C. There is a slight loss of efficiency
     in reading the images and writing them; effectively, the rasters which
     Unshake uses scan top-to-bottom, left-to right. This would be easy to
     change (exchange width and height throughout, and modify the routines
     fileToURas and URasToFile), but at the price of losing the
     Cartesian convention.  */

int fileToURas(char* URLString, struct UnshakeRaster* image) {
  
  int cols, rows, format, row, column;
  int r, g, b;
  uns_int*** array;
  xelval maxval;
  xel *tuplerow;
  
  FILE* infile;
  
  if ((infile = fopen(URLString, "r"))==(FILE*) NULL) {
    return UNS_NO_FILE;
  }  
  pnm_readpnminit(infile, &cols, &rows, &maxval, &format);

  if ((image->raster = new3DInt((uns_int***) NULL, 3, cols, rows))==(uns_int***) NULL) {
    return UNS_OOM;
  };
  image->colours = 3;
  image->width = cols;
  image->height = rows;
  
  tuplerow = pnm_allocrow(cols);
  
  array = image->raster;

  for (row = 0; row < rows; row++) {
    pnm_readpnmrow( infile, tuplerow, cols, maxval, format);
    for (column = 0; column < cols; column++) {
      r = PPM_GETR(tuplerow[column]);
      g = PPM_GETG(tuplerow[column]);
      b = PPM_GETB(tuplerow[column]);
      array[0][column][row] = r;
      array[1][column][row] = g;
      array[2][column][row] = b;
    }
  }
  
  pnm_freerow(tuplerow);
  
  return 0;
}

int filepToURas(FILE* infile, struct UnshakeRaster* image) {
  
  int cols, rows, format, row, column;
  int r, g, b;
  uns_int*** array;
  xelval maxval;
  xel *tuplerow;
  
  pnm_readpnminit(infile, &cols, &rows, &maxval, &format);

  if ((image->raster = new3DInt((uns_int***) NULL, 3, cols, rows))==(uns_int***) NULL) {
    return UNS_OOM;
  };
  image->colours = 3;
  image->width = cols;
  image->height = rows;
  
  tuplerow = pnm_allocrow(cols);
  
  array = image->raster;

  for (row = 0; row < rows; row++) {
    pnm_readpnmrow( infile, tuplerow, cols, maxval, format);
    for (column = 0; column < cols; column++) {
      r = PPM_GETR(tuplerow[column]);
      g = PPM_GETG(tuplerow[column]);
      b = PPM_GETB(tuplerow[column]);
      array[0][column][row] = r;
      array[1][column][row] = g;
      array[2][column][row] = b;
    }
  }
  
  pnm_freerow(tuplerow);
  
  return 0;
}

int saveURas(FILE* stream, struct UnshakeRaster* image) {

  int row, column, r, g, b;
  xel *tuplerow;

  pnm_writepnminit(stream, image->width, image->height, 255, UNS_PPM_FORMAT, 1 );

  tuplerow = pnm_allocrow(image->width);

  for (row = 0; row < image->height; row++) {
    for (column = 0; column < image->width; column++) {
      r = image->raster[0][column][row];
      g = image->raster[1][column][row];
      b = image->raster[2][column][row];
      PPM_ASSIGN(tuplerow[column], r, g, b);
    }
    pnm_writepnmrow( stream, tuplerow, image->width, 255, UNS_PPM_FORMAT, 1);
  }
  
  pnm_freerow(tuplerow);
  return 0;
}
