/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.test;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

class FadingCompositeContext
implements CompositeContext {
    private Composite realComposite;
    private ColorModel srcColorModel;
    private ColorModel dstColorModel;
    private RenderingHints hints;
    private float fadeFactor;

    FadingCompositeContext(Composite composite, ColorModel colorModel, ColorModel colorModel2, RenderingHints renderingHints, float f) {
        this.realComposite = composite;
        this.srcColorModel = colorModel;
        this.dstColorModel = colorModel2;
        this.hints = renderingHints;
        this.fadeFactor = f;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        this.realComposite.createContext(this.srcColorModel, this.dstColorModel, this.hints).compose(raster, raster2, writableRaster);
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        DataBufferInt dataBufferInt2 = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray2 = dataBufferInt2.getData();
        for (int i = 0; i < nArray2.length; ++i) {
            int n = nArray[i];
            int n2 = n >>> 24 & 0xFF;
            int n3 = n >>> 16 & 0xFF;
            int n4 = n >>> 8 & 0xFF;
            int n5 = n & 0xFF;
            int n6 = nArray2[i];
            int n7 = n6 >>> 24 & 0xFF;
            int n8 = n6 >>> 16 & 0xFF;
            int n9 = n6 >>> 8 & 0xFF;
            int n10 = n6 & 0xFF;
            int n11 = (int)((float)n2 + this.fadeFactor * (float)(n7 - n2));
            int n12 = (int)((float)n3 + this.fadeFactor * (float)(n8 - n3));
            int n13 = (int)((float)n4 + this.fadeFactor * (float)(n9 - n4));
            int n14 = (int)((float)n5 + this.fadeFactor * (float)(n10 - n5));
            nArray2[i] = n11 << 24 | n12 << 16 | n13 << 8 | n14;
        }
    }
}

