/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils.debug;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.List;
import pixelitor.AppLogic;
import pixelitor.ImageComponent;
import pixelitor.PixelitorWindow;
import pixelitor.history.History;
import pixelitor.io.OpenSaveManager;
import pixelitor.utils.debug.DebugNode;
import pixelitor.utils.debug.ImageComponentNode;
import pixelitor.utils.debug.SystemNode;

public class AppNode
extends DebugNode {
    public AppNode() {
        super("Pixelitor", PixelitorWindow.getInstance());
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        SystemNode systemNode = new SystemNode(graphicsDevice);
        this.add(systemNode);
        List<ImageComponent> list = AppLogic.getImageComponents();
        int n = list.size();
        this.addIntChild("Number of Open Images", n);
        ImageComponent imageComponent = AppLogic.getActiveImageComponent();
        for (int i = 0; i < n; ++i) {
            ImageComponent imageComponent2 = list.get(i);
            ImageComponentNode imageComponentNode = imageComponent2 == imageComponent ? new ImageComponentNode("ACTIVE Image - " + imageComponent2.getComp().getName(), imageComponent2) : new ImageComponentNode("Image - " + imageComponent2.getComp().getName(), imageComponent2);
            this.add(imageComponentNode);
        }
        this.addStringChild("Pixelitor Version", "1.1.2");
        this.addQuotedStringChild("Opening Directory", OpenSaveManager.getLastOpenDir().getAbsolutePath());
        this.addQuotedStringChild("Saving Directory", OpenSaveManager.getLastSaveDir().getAbsolutePath());
        this.addBooleanChild("Can Undo", History.canUndo());
        this.addBooleanChild("Can Redo", History.canRedo());
        this.addBooleanChild("Can Fade", History.canFade());
        this.addBooleanChild("Can Repeat", History.canRepeatOperation());
    }
}

