/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import com.jhlabs.composite.OverlayComposite;
import com.jhlabs.composite.ScreenComposite;
import com.jhlabs.image.BoxBlurFilter;
import com.jhlabs.image.EmbossFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.graphics.BlendComposite;
import pixelitor.ExceptionHandler;
import pixelitor.filters.Invert;

public class ImageUtils {
    public static final double DEG_315_IN_RADIANS = 0.7853981634;
    public static final float[] FRACTIONS_2_COLOR_UNIFORM = new float[]{0.0f, 1.0f};

    private ImageUtils() {
    }

    public static BufferedImage transformToCompatibleImage(BufferedImage bufferedImage) {
        assert (bufferedImage != null);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (bufferedImage.getColorModel().equals(graphicsConfiguration.getColorModel())) {
            return bufferedImage;
        }
        int n = 3;
        BufferedImage bufferedImage2 = graphicsConfiguration.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), n);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createCompatibleImage(int n, int n2) {
        assert (n > 0 && n2 > 0);
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        return bufferedImage;
    }

    public static BufferedImage getFasterScaledInstance(BufferedImage bufferedImage, int n, int n2, Object object, boolean bl) {
        int n3;
        int n4;
        boolean bl2;
        assert (bufferedImage != null);
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (n6 < n2 && n5 > n) {
            return ImageUtils.simpleResize(bufferedImage, n, n2, object);
        }
        if (n6 > n2 && n5 < n) {
            return ImageUtils.simpleResize(bufferedImage, n, n2, object);
        }
        int n7 = bufferedImage.getType();
        BufferedImage bufferedImage2 = bufferedImage;
        BufferedImage bufferedImage3 = null;
        Graphics2D graphics2D = null;
        boolean bl3 = bl2 = bufferedImage.getTransparency() != 1;
        if (bl) {
            n4 = bufferedImage.getWidth();
            n3 = bufferedImage.getHeight();
        } else {
            n4 = n;
            n3 = n2;
        }
        do {
            if (bl && n4 > n && (n4 /= 2) < n) {
                n4 = n;
            }
            if (bl && n3 > n2 && (n3 /= 2) < n2) {
                n3 = n2;
            }
            if (bufferedImage3 == null || bl2) {
                bufferedImage3 = new BufferedImage(n4, n3, n7);
                graphics2D = bufferedImage3.createGraphics();
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
            graphics2D.drawImage(bufferedImage2, 0, 0, n4, n3, 0, 0, n5, n6, null);
            n5 = n4;
            n6 = n3;
            bufferedImage2 = bufferedImage3;
        } while (n4 != n || n3 != n2);
        if (graphics2D != null) {
            graphics2D.dispose();
        }
        if (n != bufferedImage2.getWidth() || n2 != bufferedImage2.getHeight()) {
            bufferedImage3 = new BufferedImage(n, n2, n7);
            graphics2D = bufferedImage3.createGraphics();
            graphics2D.drawImage((Image)bufferedImage2, 0, 0, null);
            graphics2D.dispose();
            bufferedImage2 = bufferedImage3;
        }
        return bufferedImage2;
    }

    private static BufferedImage simpleResize(BufferedImage bufferedImage, int n, int n2, Object object) {
        assert (bufferedImage != null);
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static String intColorToString(int n) {
        Color color = new Color(n);
        return "[r=" + color.getRed() + ", g=" + color.getGreen() + ", b=" + color.getBlue() + ']';
    }

    public static Color sample9Points(BufferedImage bufferedImage, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        for (int i = n - 1; i < n + 2; ++i) {
            for (int j = n2 - 1; j < n2 + 2; ++j) {
                int n8 = ImageUtils.limitSamplingIndex(i, n6 - 1);
                int n9 = ImageUtils.limitSamplingIndex(j, n7 - 1);
                int n10 = bufferedImage.getRGB(n8, n9);
                int n11 = n10 >>> 16 & 0xFF;
                int n12 = n10 >>> 8 & 0xFF;
                int n13 = n10 & 0xFF;
                n3 += n11;
                n4 += n12;
                n5 += n13;
            }
        }
        return new Color(n3 / 9, n4 / 9, n5 / 9);
    }

    private static int limitSamplingIndex(int n, int n2) {
        int n3 = n;
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public static boolean hasPackedIntArray(BufferedImage bufferedImage) {
        assert (bufferedImage != null);
        int n = bufferedImage.getType();
        return n == 3 || n == 1 || n == 2;
    }

    public static int[] getPixelsAsArray(BufferedImage bufferedImage) {
        int[] nArray;
        assert (bufferedImage != null);
        boolean bl = ImageUtils.hasPackedIntArray(bufferedImage);
        if (bl) {
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            nArray = dataBufferInt.getData();
        } else {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            nArray = new int[n * n2];
            PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, nArray, 0, n);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                ExceptionHandler.showExceptionDialog(interruptedException);
            }
        }
        return nArray;
    }

    public static URL resourcePathToURL(String string) {
        assert (string != null);
        String string2 = "/images/" + string;
        URL uRL = ImageUtils.class.getResource(string2);
        if (uRL == null) {
            JOptionPane.showMessageDialog(null, string2 + " not found", "Error", 0);
        }
        return uRL;
    }

    public static BufferedImage loadBufferedImage(String string) {
        assert (string != null);
        URL uRL = ImageUtils.resourcePathToURL(string);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            ExceptionHandler.showExceptionDialog(iOException);
        }
        return bufferedImage;
    }

    public static int limitTo8Bits(int n) {
        if (n > 255) {
            return 255;
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public static short limitTo8Bits(short s) {
        if (s > 255) {
            return 255;
        }
        if (s < 0) {
            return 0;
        }
        return s;
    }

    public static BufferedImage convertToARGB_PRE(BufferedImage bufferedImage, boolean bl) {
        assert (bufferedImage != null);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        if (bl) {
            bufferedImage.flush();
        }
        return bufferedImage2;
    }

    public static BufferedImage convertToARGB(BufferedImage bufferedImage, boolean bl) {
        assert (bufferedImage != null);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        if (bl) {
            bufferedImage.flush();
        }
        return bufferedImage2;
    }

    public static BufferedImage convertToRGB(BufferedImage bufferedImage, boolean bl) {
        assert (bufferedImage != null);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        if (bl) {
            bufferedImage.flush();
        }
        return bufferedImage2;
    }

    public static Color getRandomColor(boolean bl) {
        Random random = new Random();
        int n = random.nextInt(256);
        int n2 = random.nextInt(256);
        int n3 = random.nextInt(256);
        if (bl) {
            int n4 = random.nextInt(256);
            return new Color(n, n2, n3, n4);
        }
        return new Color(n, n2, n3);
    }

    public static Color getHSBAverageColor(Color color, Color color2) {
        assert (color != null && color2 != null);
        int n = color.getRGB();
        int n2 = color2.getRGB();
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 >>> 16 & 0xFF;
        int n7 = n2 >>> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        float[] fArray = Color.RGBtoHSB(n3, n4, n5, null);
        float[] fArray2 = Color.RGBtoHSB(n6, n7, n8, null);
        float f = fArray[0];
        float f2 = fArray2[0];
        float f3 = ImageUtils.calculateHueAverage(f, f2);
        float f4 = (fArray[1] + fArray2[1]) / 2.0f;
        float f5 = (fArray[2] + fArray2[2]) / 2.0f;
        return Color.getHSBColor(f3, f4, f5);
    }

    private static float calculateHueAverage(float f, float f2) {
        float f3 = f - f2;
        if (f3 < 0.5f && f3 > -0.5f) {
            return (f + f2) / 2.0f;
        }
        if (f3 >= 0.5f) {
            float f4 = f + (1.0f - f + f2) / 2.0f;
            return f4;
        }
        if (f3 <= 0.5f) {
            float f5 = f2 + (1.0f - f2 + f) / 2.0f;
            return f5;
        }
        throw new IllegalStateException("should not get here");
    }

    public static Color getRGBAverageColor(Color color, Color color2) {
        assert (color != null && color2 != null);
        int n = color.getRGB();
        int n2 = color2.getRGB();
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n & 0xFF;
        int n6 = n2 >>> 16 & 0xFF;
        int n7 = n2 >>> 8 & 0xFF;
        int n8 = n2 & 0xFF;
        int n9 = (n3 + n6) / 2;
        int n10 = (n4 + n7) / 2;
        int n11 = (n5 + n8) / 2;
        return new Color(n9, n10, n11);
    }

    public static void drawImageWithClipping(Graphics graphics, BufferedImage bufferedImage) {
        assert (bufferedImage != null);
        Rectangle rectangle = graphics.getClipBounds();
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        int n3 = (int)rectangle.getWidth();
        int n4 = (int)rectangle.getHeight();
        int n5 = n + n3;
        int n6 = n2 + n4;
        graphics.drawImage(bufferedImage, n, n2, n5, n6, n, n2, n5, n6, null);
    }

    public static void serializeImage(ObjectOutputStream objectOutputStream, BufferedImage bufferedImage) throws IOException {
        int[] nArray;
        assert (bufferedImage != null);
        objectOutputStream.writeInt(bufferedImage.getWidth());
        objectOutputStream.writeInt(bufferedImage.getHeight());
        objectOutputStream.writeInt(bufferedImage.getType());
        for (int n : nArray = ImageUtils.getPixelsAsArray(bufferedImage)) {
            objectOutputStream.writeInt(n);
        }
    }

    public static BufferedImage deserializeImage(ObjectInputStream objectInputStream) throws IOException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = objectInputStream.readInt();
        }
        return bufferedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage createThumbnail(BufferedImage bufferedImage, int n) {
        int n2;
        float f;
        int n3;
        int n4;
        assert (bufferedImage != null);
        int n5 = bufferedImage.getWidth();
        if (n5 > (n4 = bufferedImage.getHeight())) {
            n3 = n;
            f = (float)n5 / (float)n4;
            n2 = (int)((float)n / f);
        } else {
            n2 = n;
            f = (float)n4 / (float)n5;
            n3 = (int)((float)n / f);
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        try {
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            graphics2D.drawImage(bufferedImage, 0, 0, n3, n2, null);
        }
        finally {
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage copyImage(BufferedImage bufferedImage) {
        assert (bufferedImage != null);
        WritableRaster writableRaster = null;
        try {
            writableRaster = bufferedImage.copyData(null);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ExceptionHandler.showOutOfMemoryDialog();
        }
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster, bufferedImage.isAlphaPremultiplied(), null);
    }

    public static BufferedImage copyAndTranslateSubimage(BufferedImage bufferedImage, Rectangle rectangle) {
        assert (bufferedImage != null);
        assert (rectangle != null);
        Rectangle rectangle2 = new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        if (rectangle3.width <= 0 || rectangle3.height <= 0) {
            throw new IllegalStateException("empty intersection: bounds = " + rectangle + ", imageBounds = " + rectangle2 + ", intersection = " + rectangle3);
        }
        Raster raster = bufferedImage.getData(rectangle3);
        Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, 0, 0, null);
        return new BufferedImage(bufferedImage.getColorModel(), (WritableRaster)raster2, bufferedImage.isAlphaPremultiplied(), null);
    }

    public static BufferedImage rasterToImage(Raster raster) {
        assert (raster != null);
        int n = raster.getMinX();
        int n2 = raster.getMinY();
        int n3 = raster.getWidth();
        int n4 = raster.getHeight();
        Raster raster2 = raster.createChild(n, n2, n3, n4, 0, 0, null);
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 3);
        bufferedImage.setData(raster2);
        return bufferedImage;
    }

    public static BufferedImage crop(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        assert (bufferedImage != null);
        if (n3 <= 0) {
            throw new IllegalArgumentException("width = " + n3);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("height = " + n4);
        }
        BufferedImage bufferedImage2 = new BufferedImage(n3, n4, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-n, -n2);
        graphics2D.transform(affineTransform);
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static int lerpAndPremultiplyColorWithAlpha(float f, int[] nArray, int[] nArray2) {
        int n;
        int n2;
        int n3;
        int n4 = nArray[0] + (int)(f * (float)(nArray2[0] - nArray[0]));
        if (n4 == 0) {
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            n3 = nArray[1] + (int)(f * (float)(nArray2[1] - nArray[1]));
            n2 = nArray[2] + (int)(f * (float)(nArray2[2] - nArray[2]));
            n = nArray[3] + (int)(f * (float)(nArray2[3] - nArray[3]));
            if (n4 != 255) {
                float f2 = (float)n4 / 255.0f;
                n3 = (int)((float)n3 * f2);
                n2 = (int)((float)n2 * f2);
                n = (int)((float)n * f2);
            }
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public static void screenWithItself(BufferedImage bufferedImage, float f) {
        assert (bufferedImage != null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(new ScreenComposite(f));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    public static BufferedImage getHighPassSharpenedImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        assert (bufferedImage != null);
        assert (bufferedImage2 != null);
        Invert.invertImage(bufferedImage2, bufferedImage2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.5f));
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.setComposite(new OverlayComposite(1.0f));
        graphics2D2.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D2.dispose();
        return bufferedImage2;
    }

    public static BufferedImage createRandomPointsTemplateBrush(int n, float f) {
        if ((double)f < 0.0 && (double)f > 1.0) {
            throw new IllegalArgumentException("density is " + f);
        }
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        int n2 = n / 2;
        int n3 = n2 * n2;
        Random random = new Random();
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = i - n2;
                int n5 = j - n2;
                int n6 = n4 * n4 + n5 * n5;
                if (n6 < n3) {
                    float f2 = random.nextFloat();
                    if (f > f2) {
                        nArray[i + j * n] = random.nextInt();
                        continue;
                    }
                    nArray[i + j * n] = -1;
                    continue;
                }
                nArray[i + j * n] = -1;
            }
        }
        return bufferedImage;
    }

    public static BufferedImage createSoftTemplateBrush(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, n, n);
        graphics2D.setColor(Color.BLACK);
        int n2 = n / 4;
        graphics2D.fillOval(n2, n2, n - 2 * n2, n - 2 * n2);
        graphics2D.dispose();
        BoxBlurFilter boxBlurFilter = new BoxBlurFilter(n2, n2, 1);
        bufferedImage = boxBlurFilter.filter(bufferedImage, bufferedImage);
        return bufferedImage;
    }

    public static void drawGrid(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n3 < 0) {
            throw new IllegalArgumentException("hWidth = " + n3);
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("vWidth = " + n5);
        }
        if (n4 <= 0) {
            throw new IllegalArgumentException("hSpacing = " + n4);
        }
        if (n6 <= 0) {
            throw new IllegalArgumentException("vSpacing = " + n6);
        }
        int n8 = n3 / 2;
        int n9 = n5 / 2;
        if (n3 > 0) {
            for (n7 = 0; n7 < n2; n7 += n6) {
                int n10 = n7 - n9;
                graphics2D.fillRect(0, n10, n, n5);
            }
        }
        if (n5 > 0) {
            for (n7 = 0; n7 < n; n7 += n4) {
                graphics2D.fillRect(n7 - n8, 0, n3, n2);
            }
        }
    }

    public static void drawBrickGrid(Graphics2D graphics2D, int n, int n2, int n3) {
        if (n < 1) {
            throw new IllegalArgumentException("size = " + n);
        }
        int n4 = n * 2;
        int n5 = n;
        int n6 = 0;
        while (n5 < n3) {
            int n7 = 0;
            if (n6 % 2 == 1) {
                n7 = n;
            }
            for (int i = n7; i < n2; i += n4) {
                graphics2D.drawLine(i, n5, i, n5 - n);
            }
            graphics2D.drawLine(0, n5, n2, n5);
            n5 += n;
            ++n6;
        }
    }

    public static BufferedImage bumpMap(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return ImageUtils.bumpMap(bufferedImage, bufferedImage2, 0.7853982f, 0.53f, 2.0f);
    }

    public static BufferedImage bumpMap(BufferedImage bufferedImage, BufferedImage bufferedImage2, float f, float f2, float f3) {
        return ImageUtils.bumpMap(bufferedImage, bufferedImage2, BlendComposite.HardLight, f, f2, f3);
    }

    public static BufferedImage bumpMap(BufferedImage bufferedImage, BufferedImage bufferedImage2, Composite composite, float f, float f2, float f3) {
        EmbossFilter embossFilter = new EmbossFilter();
        embossFilter.setAzimuth(f);
        embossFilter.setElevation(f2);
        embossFilter.setBumpHeight(f3);
        BufferedImage bufferedImage3 = embossFilter.filter(bufferedImage2, null);
        BufferedImage bufferedImage4 = ImageUtils.copyImage(bufferedImage);
        Graphics2D graphics2D = bufferedImage4.createGraphics();
        graphics2D.setComposite(composite);
        graphics2D.drawImage((Image)bufferedImage3, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage4;
    }

    public static void fillImage(BufferedImage bufferedImage, Color color) {
        int[] nArray = ImageUtils.getPixelsAsArray(bufferedImage);
        int n = color.getRGB();
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static int premultiply(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n & 0xFF;
        float f = (float)n2 * 0.003921569f;
        n3 = (int)((float)n3 * f);
        n4 = (int)((float)n4 * f);
        n5 = (int)((float)n5 * f);
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static int unPremultiply(int n) {
        int n2 = n >>> 24 & 0xFF;
        int n3 = n >>> 16 & 0xFF;
        int n4 = n >>> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (n2 == 0 || n2 == 255) {
            return n;
        }
        float f = 255.0f / (float)n2;
        n3 = (int)((float)n3 * f);
        n4 = (int)((float)n4 * f);
        n5 = (int)((float)n5 * f);
        if (n3 > 255) {
            n3 = 255;
        }
        if (n4 > 255) {
            n4 = 255;
        }
        if (n5 > 255) {
            n5 = 255;
        }
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static BufferedImage convertToGrayScaleImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 10);
        ColorConvertOp colorConvertOp = new ColorConvertOp(null);
        bufferedImage2 = colorConvertOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public void drawLightning(Graphics2D graphics2D, float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        double d = Math.sqrt(f5 * f5 + f6 * f6);
        int n = 10;
        float f7 = (float)(d / 2.0);
        for (int i = 0; i < n; ++i) {
        }
    }
}

