/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;

public class GradientBorder
extends AbstractBorder {
    private static final int WIDTH = 4;
    private Color leftColor;
    private Color rightColor;
    private Insets insets;

    public GradientBorder(Color color, Color color2) {
        this.leftColor = color;
        this.rightColor = color2;
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(4, 4, 4, 4);
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        insets.left = 4;
        insets.right = 4;
        insets.top = 4;
        insets.bottom = 4;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GradientPaint gradientPaint = new GradientPaint(n, n2, this.leftColor, n3, 0.0f, this.rightColor);
        this.insets = this.insets == null ? this.getBorderInsets(component) : this.getBorderInsets(component, this.insets);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fillRect(n, n2, n3, this.insets.top);
        graphics2D.fillRect(n, n2, this.insets.left, n4);
        graphics2D.fillRect(n + n3 - this.insets.right, n2, this.insets.right, n4);
        graphics2D.fillRect(n, n2 + n4 - this.insets.bottom, n3, this.insets.bottom);
    }
}

