/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.utils;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import pixelitor.io.FileExtensionUtils;
import pixelitor.io.OutputFormat;

public class CustomFileChooser
extends JFileChooser {
    private OutputFormat outputFormat;

    public CustomFileChooser(File file) {
        super(file);
        this.setAcceptAllFileFilterUsed(false);
    }

    @Override
    public void approveSelection() {
        int n;
        File file = this.getSelectedFile();
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this, file.getName() + " exists already. Overwrite?", "Confirmation", 0)) != 0) {
            return;
        }
        super.approveSelection();
    }

    @Override
    public File getSelectedFile() {
        File file = super.getSelectedFile();
        if (file == null) {
            return file;
        }
        String string = FileExtensionUtils.getFileExtension(file.getName());
        if (string == null) {
            string = this.getExtensionFromFileFilter();
            file = new File(file.getAbsolutePath() + '.' + string);
        } else {
            boolean bl = FileExtensionUtils.isSupportedExtension(file.getName(), FileExtensionUtils.SUPPORTED_OUTPUT_FORMATS);
            if (!bl) {
                string = this.getExtensionFromFileFilter();
                file = new File(file.getAbsolutePath() + '.' + string);
            }
        }
        this.outputFormat = OutputFormat.valueFromExtension(string);
        return file;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    private String getExtensionFromFileFilter() {
        FileFilter fileFilter = this.getFileFilter();
        return ((FileNameExtensionFilter)fileFilter).getExtensions()[0];
    }
}

