/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.tools.UserDrag;

enum TwoPointsFillType {
    LINEAR_GRADIENT{

        @Override
        public Paint getPaint(UserDrag userDrag) {
            Color color = FgBgColorSelector.getFG();
            Color color2 = FgBgColorSelector.getBG();
            return new GradientPaint(userDrag.getStartXFromCenter(), userDrag.getStartYFromCenter(), color, userDrag.getEndX(), userDrag.getEndY(), color2);
        }

        public String toString() {
            return "Linear Gradient";
        }
    }
    ,
    RADIAL_GRADIENT{
        private final float[] FRACTIONS = new float[]{0.0f, 1.0f};
        private final AffineTransform gradientTransform = new AffineTransform();

        @Override
        public Paint getPaint(UserDrag userDrag) {
            Color color = FgBgColorSelector.getFG();
            Color color2 = FgBgColorSelector.getBG();
            Point2D point2D = userDrag.getCenterPoint();
            float f = userDrag.getDistance();
            return new RadialGradientPaint(point2D, f / 2.0f, point2D, this.FRACTIONS, new Color[]{color, color2}, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, this.gradientTransform);
        }

        public String toString() {
            return "Radial Gradient";
        }
    }
    ,
    FOREGROUND{

        @Override
        public Paint getPaint(UserDrag userDrag) {
            Color color = FgBgColorSelector.getFG();
            return color;
        }

        public String toString() {
            return "Foreground";
        }
    }
    ,
    BACKGROUND{

        @Override
        public Paint getPaint(UserDrag userDrag) {
            Color color = FgBgColorSelector.getBG();
            return color;
        }

        public String toString() {
            return "Background";
        }
    };


    public abstract Paint getPaint(UserDrag var1);
}

