/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import pixelitor.AppLogic;
import pixelitor.tools.Tool;
import pixelitor.utils.IconUtils;

public class ToolButton
extends JToggleButton
implements ActionListener {
    private Tool tool;

    public ToolButton(Tool tool) {
        this.tool = tool;
        tool.setButton(this);
        this.putClientProperty("JComponent.sizeVariant", "mini");
        ImageIcon imageIcon = IconUtils.loadIcon(tool.getIconFileName());
        this.setIcon(imageIcon);
        char c = tool.getActivationKeyChar();
        String string = new String(new char[]{c}).toUpperCase();
        this.setToolTipText(tool.getName() + " Tool (" + string + ')');
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setBorderPainted(true);
        this.setRolloverEnabled(false);
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        AppLogic.setCurrentTool(this.tool);
    }
}

