/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.tools;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import pixelitor.AppLogic;
import pixelitor.Composition;
import pixelitor.ImageComponent;
import pixelitor.PixelitorWindow;
import pixelitor.filters.gui.RangeParam;
import pixelitor.filters.painters.EffectsPanel;
import pixelitor.history.History;
import pixelitor.history.NewSelectionEdit;
import pixelitor.history.PixelitorEdit;
import pixelitor.history.SelectionChangeEdit;
import pixelitor.layers.ImageLayer;
import pixelitor.selection.Selection;
import pixelitor.tools.BasicStrokeCap;
import pixelitor.tools.BasicStrokeJoin;
import pixelitor.tools.ShapeType;
import pixelitor.tools.ShapesAction;
import pixelitor.tools.StrokeType;
import pixelitor.tools.Tool;
import pixelitor.tools.ToolAffectedArea;
import pixelitor.tools.TwoPointsFillType;
import pixelitor.tools.UserDrag;
import pixelitor.utils.GUIUtils;
import pixelitor.utils.OKCancelDialog;
import pixelitor.utils.SliderSpinner;

public class ShapesTool
extends Tool {
    private EnumComboBoxModel<ShapesAction> actionModel = new EnumComboBoxModel<ShapesAction>(ShapesAction.class);
    private EnumComboBoxModel<ShapeType> typeModel = new EnumComboBoxModel<ShapeType>(ShapeType.class);
    private EnumComboBoxModel<TwoPointsFillType> fillModel = new EnumComboBoxModel<TwoPointsFillType>(TwoPointsFillType.class);
    private EnumComboBoxModel<TwoPointsFillType> strokeFillModel = new EnumComboBoxModel<TwoPointsFillType>(TwoPointsFillType.class);
    private RangeParam strokeWidthParam = new RangeParam("Stroke Width", 1, 100, 5);
    private ButtonModel dashedModel = new JToggleButton.ToggleButtonModel();
    private EnumComboBoxModel<BasicStrokeCap> strokeCapModel = new EnumComboBoxModel<BasicStrokeCap>(BasicStrokeCap.class);
    private EnumComboBoxModel<BasicStrokeJoin> strokeJoinModel = new EnumComboBoxModel<BasicStrokeJoin>(BasicStrokeJoin.class);
    private EnumComboBoxModel<StrokeType> strokeTypeModel = new EnumComboBoxModel<StrokeType>(StrokeType.class);
    private JDialog strokeDialog;
    private JButton strokeSettingsButton;
    private BasicStroke basicStroke;
    private JComboBox strokeFillCombo;
    private JComboBox fillCombo = new JComboBox<TwoPointsFillType>(this.fillModel);
    private JButton effectsButton;
    private OKCancelDialog effectsDialog;
    private EffectsPanel effectsPanel;
    private Shape backupSelectionShape = null;
    private boolean drawing = false;

    public ShapesTool() {
        super('s', "Shapes", "shapes_tool_icon.gif", "click and drag to draw a shape", Cursor.getPredefinedCursor(0), true, true, false);
        this.strokeFillModel.setSelectedItem((Object)TwoPointsFillType.BACKGROUND);
        this.strokeFillCombo = new JComboBox<TwoPointsFillType>(this.strokeFillModel);
        this.spaceDragBehavior = true;
    }

    @Override
    void initSettingsPanel() {
        this.toolSettingsPanel.add(new JLabel("Shape:"));
        JComboBox<ShapeType> jComboBox = new JComboBox<ShapeType>(this.typeModel);
        this.toolSettingsPanel.add(jComboBox);
        this.toolSettingsPanel.add(new JLabel("Action:"));
        JComboBox<ShapesAction> jComboBox2 = new JComboBox<ShapesAction>(this.actionModel);
        this.toolSettingsPanel.add(jComboBox2);
        jComboBox2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShapesTool.this.enableSettings();
            }
        });
        this.toolSettingsPanel.add(new JLabel("Fill:"));
        this.toolSettingsPanel.add(this.fillCombo);
        this.toolSettingsPanel.add(new JLabel("Stroke:"));
        this.toolSettingsPanel.add(this.strokeFillCombo);
        this.strokeSettingsButton = new JButton("Stroke Settings...");
        this.toolSettingsPanel.add(this.strokeSettingsButton);
        this.strokeSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShapesTool.this.initAndShowStrokeSettingsDialog();
            }
        });
        this.effectsButton = new JButton("Effects...");
        this.toolSettingsPanel.add(this.effectsButton);
        this.effectsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShapesTool.this.showEffectsDialog();
            }
        });
        this.enableSettings();
    }

    private void showEffectsDialog() {
        if (this.effectsPanel == null) {
            this.effectsPanel = new EffectsPanel(null);
        }
        this.effectsDialog = new OKCancelDialog(this.effectsPanel, "Effects"){

            @Override
            protected void dialogAccepted() {
                super.dialogAccepted();
                ShapesTool.closeDialog(ShapesTool.this.effectsDialog);
                ShapesTool.this.effectsPanel.updateEffectsFromGUI();
            }

            @Override
            protected void dialogCancelled() {
                super.dialogCancelled();
                ShapesTool.closeDialog(ShapesTool.this.effectsDialog);
            }
        };
        this.effectsDialog.setVisible(true);
    }

    @Override
    public void toolMousePressed(MouseEvent mouseEvent, ImageComponent imageComponent) {
        Composition composition = imageComponent.getComp();
        Selection selection = composition.getSelection();
        this.backupSelectionShape = selection != null ? selection.getShape() : null;
    }

    @Override
    public void toolMouseDragged(MouseEvent mouseEvent, ImageComponent imageComponent) {
        this.drawing = true;
        this.userDrag.setStartFromCenter(mouseEvent.isAltDown());
        Composition composition = imageComponent.getComp();
        composition.imageChanged(true, false);
    }

    @Override
    public void toolMouseReleased(MouseEvent mouseEvent, ImageComponent imageComponent) {
        Selection selection;
        this.userDrag.setStartFromCenter(mouseEvent.isAltDown());
        Composition composition = imageComponent.getComp();
        ShapesAction shapesAction = (ShapesAction)((Object)this.actionModel.getSelectedItem());
        boolean bl = shapesAction.createSelection();
        if (!bl) {
            int n = 0;
            int n2 = 0;
            if (shapesAction.enableStrokePaintSelection()) {
                n = this.strokeWidthParam.getValue();
                n2 = ((StrokeType)((Object)this.strokeTypeModel.getSelectedItem())).getExtraWidth(n);
                n += n2;
            }
            int n3 = 0;
            if (this.effectsPanel != null) {
                n3 = this.effectsPanel.getMaxEffectThickness();
                n3 += n2;
            }
            if (n3 > n) {
                n = n3;
            }
            ShapeType shapeType = (ShapeType)((Object)this.typeModel.getSelectedItem());
            Shape shape = shapeType.getShape(this.userDrag);
            Rectangle rectangle = shape.getBounds();
            rectangle.grow(n, n);
            ToolAffectedArea toolAffectedArea = new ToolAffectedArea(composition, rectangle, false);
            this.saveSubImageForUndo(composition.getActiveImageLayer().getBufferedImage(), toolAffectedArea);
        }
        this.paintShapeOnIC(composition, this.userDrag);
        if (bl && (selection = composition.getSelection()) != null) {
            selection.clipToCompSize(composition);
            PixelitorEdit pixelitorEdit = this.backupSelectionShape != null ? new SelectionChangeEdit(composition, this.backupSelectionShape, "Selection Change") : new NewSelectionEdit(composition, selection.getShape());
            History.addEdit(pixelitorEdit);
        }
        this.drawing = false;
        composition.imageChanged(true, true);
    }

    private void enableSettings() {
        ShapesAction shapesAction = (ShapesAction)((Object)this.actionModel.getSelectedItem());
        this.enableEffectSettings(shapesAction.drawEffects());
        this.enableStrokeSettings(shapesAction.enableStrokeSettings());
        this.enableFillPaintSelection(shapesAction.enableFillPaintSelection());
        this.enableStrokePaintSelection(shapesAction.enableStrokePaintSelection());
    }

    private void initAndShowStrokeSettingsDialog() {
        if (this.strokeDialog == null) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            SliderSpinner sliderSpinner = new SliderSpinner(this.strokeWidthParam, false, SliderSpinner.TextPosition.BORDER);
            jPanel.add(sliderSpinner);
            jPanel.add(sliderSpinner);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("Line Endpoints"));
            jPanel2.setLayout(new GridLayout(2, 2, 5, 5));
            jPanel2.add(new JLabel("Endpoint Cap:", 4));
            JComboBox<BasicStrokeCap> jComboBox = new JComboBox<BasicStrokeCap>(this.strokeCapModel);
            jComboBox.setToolTipText("The shape of the endpoints of the lines");
            jPanel2.add(jComboBox);
            jPanel2.add(new JLabel("Corner Join:", 4));
            JComboBox<BasicStrokeJoin> jComboBox2 = new JComboBox<BasicStrokeJoin>(this.strokeJoinModel);
            jComboBox2.setToolTipText("The way lines connect at the corners");
            jPanel2.add(jComboBox2);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel();
            jPanel3.setBorder(BorderFactory.createTitledBorder("Stroke Type"));
            jPanel3.setLayout(new GridLayout(2, 2, 5, 5));
            jPanel3.add(new JLabel("Line Type:", 4));
            jPanel3.add(new JComboBox<StrokeType>(this.strokeTypeModel));
            jPanel3.add(new JLabel("Dashed:", 4));
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setModel(this.dashedModel);
            jPanel3.add(jCheckBox);
            jPanel.add(jPanel3);
            this.strokeDialog = new JDialog((Frame)PixelitorWindow.getInstance(), "Stroke Settings");
            this.strokeDialog.setLayout(new BorderLayout());
            this.strokeDialog.add((Component)jPanel, "Center");
            JButton jButton = new JButton("OK");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ShapesTool.closeDialog(ShapesTool.this.strokeDialog);
                }
            });
            JPanel jPanel4 = new JPanel();
            jPanel4.add(jButton);
            this.strokeDialog.add((Component)jPanel4, "South");
            this.strokeDialog.pack();
        }
        GUIUtils.centerOnScreen(this.strokeDialog);
        this.strokeDialog.setVisible(true);
    }

    private static void closeDialog(JDialog jDialog) {
        if (jDialog != null) {
            jDialog.setVisible(false);
            jDialog.dispose();
        }
    }

    @Override
    protected void toolEnded() {
        ShapesTool.closeDialog(this.strokeDialog);
        ShapesTool.closeDialog(this.effectsDialog);
    }

    @Override
    public void paintOverLayer(Graphics2D graphics2D) {
        if (this.drawing) {
            this.paintShape(graphics2D, this.userDrag);
        }
    }

    public void paintShapeOnIC(Composition composition, UserDrag userDrag) {
        ImageLayer imageLayer = (ImageLayer)composition.getActiveLayer();
        int n = -imageLayer.getTranslationX();
        int n2 = -imageLayer.getTranslationY();
        BufferedImage bufferedImage = imageLayer.getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.translate(n, n2);
        composition.setSelectionClipping(graphics2D, null);
        this.paintShape(graphics2D, userDrag);
        graphics2D.dispose();
    }

    private void paintShape(Graphics2D graphics2D, UserDrag userDrag) {
        Object object;
        Object object2;
        if (userDrag.isClick()) {
            return;
        }
        if (this.basicStroke == null) {
            this.basicStroke = new BasicStroke(1.0f);
        }
        ShapeType shapeType = (ShapeType)((Object)this.typeModel.getSelectedItem());
        Shape shape = shapeType.getShape(userDrag);
        ShapesAction shapesAction = (ShapesAction)((Object)this.actionModel.getSelectedItem());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (shapesAction.fill()) {
            object2 = (TwoPointsFillType)((Object)this.fillModel.getSelectedItem());
            if (shapeType.isClosed()) {
                graphics2D.setPaint(((TwoPointsFillType)((Object)object2)).getPaint(userDrag));
                graphics2D.fill(shape);
            } else if (!shapesAction.stroke()) {
                graphics2D.setStroke(this.basicStroke);
                graphics2D.setPaint(((TwoPointsFillType)((Object)object2)).getPaint(userDrag));
                graphics2D.draw(shape);
            }
        }
        object2 = null;
        if (shapesAction.stroke()) {
            object = (AreaEffect[])this.strokeFillModel.getSelectedItem();
            object2 = this.createStroke();
            graphics2D.setStroke((Stroke)object2);
            graphics2D.setPaint(object.getPaint(userDrag));
            graphics2D.draw(shape);
        }
        if (shapesAction.drawEffects() && this.effectsPanel != null) {
            object = this.effectsPanel.getEffectsAsArray();
            for (AreaEffect areaEffect : object) {
                if (shapesAction.fill()) {
                    areaEffect.apply(graphics2D, shape, 0, 0);
                    continue;
                }
                if (shapesAction.stroke()) {
                    if (object2 == null) {
                        object2 = this.createStroke();
                    }
                    areaEffect.apply(graphics2D, object2.createStrokedShape(shape), 0, 0);
                    continue;
                }
                areaEffect.apply(graphics2D, shape, 0, 0);
            }
        }
        if (shapesAction.createSelection()) {
            object = null;
            if (shapesAction.enableStrokeSettings()) {
                if (object2 == null) {
                    object2 = this.createStroke();
                }
                object = object2.createStrokedShape(shape);
            } else if (!shapeType.isClosed()) {
                if (this.basicStroke == null) {
                    throw new IllegalStateException();
                }
                object = this.basicStroke.createStrokedShape(shape);
            } else {
                object = shape;
            }
            Composition composition = AppLogic.getActiveComp();
            Selection selection = composition.getSelection();
            if (selection == null) {
                composition.createSelectionFromShape((Shape)object);
            } else {
                selection.setShape((Shape)object);
            }
        }
    }

    private Stroke createStroke() {
        int n = this.strokeWidthParam.getValue();
        float[] fArray = null;
        if (this.dashedModel.isSelected()) {
            fArray = new float[]{2 * n, 2 * n};
        }
        Stroke stroke = ((StrokeType)((Object)this.strokeTypeModel.getSelectedItem())).getStroke(n, ((BasicStrokeCap)((Object)this.strokeCapModel.getSelectedItem())).getValue(), ((BasicStrokeJoin)((Object)this.strokeJoinModel.getSelectedItem())).getValue(), fArray);
        return stroke;
    }

    public void setShapeType(ShapeType shapeType) {
        this.typeModel.setSelectedItem((Object)shapeType);
    }

    public boolean isDrawing() {
        return this.drawing;
    }

    private void enableStrokeSettings(boolean bl) {
        this.strokeSettingsButton.setEnabled(bl);
        if (!bl) {
            ShapesTool.closeDialog(this.strokeDialog);
        }
    }

    private void enableEffectSettings(boolean bl) {
        this.effectsButton.setEnabled(bl);
        if (!bl) {
            ShapesTool.closeDialog(this.effectsDialog);
        }
    }

    private void enableStrokePaintSelection(boolean bl) {
        this.strokeFillCombo.setEnabled(bl);
    }

    private void enableFillPaintSelection(boolean bl) {
        this.fillCombo.setEnabled(bl);
    }

    public void setAction(ShapesAction shapesAction) {
        this.actionModel.setSelectedItem((Object)shapesAction);
    }

    public void setStrokeType(StrokeType strokeType) {
        this.strokeTypeModel.setSelectedItem((Object)strokeType);
    }
}

