/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.menus;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JMenu;
import javax.swing.KeyStroke;
import pixelitor.menus.MenuFactory;
import pixelitor.menus.ZoomLevel;
import pixelitor.menus.ZoomMenuItem;

public class ZoomMenu
extends JMenu {
    private ZoomLevel currentZoom = ZoomLevel.Z100;
    private static ButtonGroup radioGroup = new ButtonGroup();
    public static final ZoomMenu INSTANCE = new ZoomMenu();
    private static final String ACTION_MAP_KEY_INCREASE = "increase";
    private static final String ACTION_MAP_KEY_DECREASE = "decrease";

    private ZoomMenu() {
        super("Zoom");
        ZoomLevel[] zoomLevelArray;
        AbstractAction abstractAction = new AbstractAction("Zoom In"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ZoomMenu.this.increaseZoom();
            }
        };
        MenuFactory.createMenuItem(abstractAction, KeyStroke.getKeyStroke(521, 2), this);
        AbstractAction abstractAction2 = new AbstractAction("Zom Out"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ZoomMenu.this.decreaseZoom();
            }
        };
        MenuFactory.createMenuItem(abstractAction2, KeyStroke.getKeyStroke(45, 2), this);
        this.addSeparator();
        InputMap inputMap = this.getInputMap(2);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(61, 129), ACTION_MAP_KEY_INCREASE);
        inputMap.put(KeyStroke.getKeyStroke(107, 128), ACTION_MAP_KEY_INCREASE);
        inputMap.put(KeyStroke.getKeyStroke(109, 128), ACTION_MAP_KEY_DECREASE);
        actionMap.put(ACTION_MAP_KEY_INCREASE, abstractAction);
        actionMap.put(ACTION_MAP_KEY_DECREASE, abstractAction2);
        for (ZoomLevel zoomLevel : zoomLevelArray = ZoomLevel.values()) {
            ZoomMenuItem zoomMenuItem = zoomLevel.getMenuItem();
            if (zoomLevel == this.currentZoom) {
                zoomMenuItem.setSelected(true);
            }
            this.add(zoomMenuItem);
            radioGroup.add(zoomMenuItem);
        }
    }

    private void increaseZoom() {
        ZoomLevel zoomLevel = this.currentZoom.increase();
        this.setNewZoomLevel(zoomLevel);
    }

    private void decreaseZoom() {
        ZoomLevel zoomLevel = this.currentZoom.decrease();
        this.setNewZoomLevel(zoomLevel);
    }

    private void setNewZoomLevel(ZoomLevel zoomLevel) {
        if (zoomLevel != this.currentZoom) {
            this.currentZoom = zoomLevel;
            ZoomMenuItem zoomMenuItem = this.currentZoom.getMenuItem();
            zoomMenuItem.doClick();
        }
    }

    public void setCurrentZoom(ZoomLevel zoomLevel) {
        this.currentZoom = zoomLevel;
    }

    public void zoomChanged(ZoomLevel zoomLevel) {
        this.currentZoom = zoomLevel;
        zoomLevel.getMenuItem().setSelected(true);
    }
}

