/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import pixelitor.Composition;
import pixelitor.layers.ImageLayer;

public class TmpDrawingLayer {
    private BufferedImage image;
    private final Graphics2D g;
    private final Composite composite;
    private int tmpDrawingX = 0;
    private int tmpDrawingY = 0;

    public TmpDrawingLayer(ImageLayer imageLayer, Composite composite, boolean bl) {
        this.composite = composite;
        Composition composition = imageLayer.getComposition();
        this.image = imageLayer.createCompositionSizedTmpImage();
        this.g = this.image.createGraphics();
        if (bl) {
            composition.setSelectionClipping(this.g, null);
        }
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public void dispose() {
        this.g.dispose();
        this.image.flush();
        this.image = null;
    }

    public void paintLayer(Graphics2D graphics2D, int n, int n2) {
        if (this.composite == null) {
            throw new IllegalStateException("tmpDrawingComposite == null");
        }
        graphics2D.setComposite(this.composite);
        graphics2D.drawImage((Image)this.image, this.tmpDrawingX + n, this.tmpDrawingY + n2, null);
    }
}

