/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import pixelitor.layers.LayerButton;
import pixelitor.layers.LayersLayout;

public class LayersPanel
extends JPanel {
    private final ButtonGroup buttonGroup = new ButtonGroup();

    public LayersPanel() {
        LayersLayout layersLayout = new LayersLayout(1, 1);
        this.setLayout(layersLayout);
    }

    public void addLayerButton(LayerButton layerButton, int n) {
        if (layerButton == null) {
            throw new IllegalArgumentException("button is null");
        }
        this.buttonGroup.add(layerButton);
        this.add((Component)layerButton, n);
        layerButton.setUserInteraction(false);
        layerButton.setSelected(true);
        layerButton.setUserInteraction(true);
        this.revalidate();
        this.repaint();
    }

    public void deleteLayerButton(LayerButton layerButton) {
        this.buttonGroup.remove(layerButton);
        this.remove(layerButton);
        this.revalidate();
        this.repaint();
    }

    public void changeLayerOrder(int n, int n2) {
        Component component = this.getComponent(n);
        this.add(component, n2);
        this.revalidate();
    }
}

