/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import pixelitor.layers.Layer;
import pixelitor.layers.LayerButton;

public class LayerNameEditor
extends JTextField {
    public LayerNameEditor(final Layer layer) {
        super(layer.getName());
        this.disableEditing();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    LayerNameEditor.this.enableEditing();
                } else {
                    LayerNameEditor.this.requestFocus();
                    Container container = LayerNameEditor.this.getParent();
                    if (container != null) {
                        LayerButton layerButton = (LayerButton)container;
                        layerButton.setSelected(true);
                    }
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                LayerNameEditor.this.disableEditing();
                layer.setName(LayerNameEditor.this.getText(), true);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LayerNameEditor.this.disableEditing();
                layer.setName(LayerNameEditor.this.getText(), true);
            }
        });
    }

    private void enableEditing() {
        this.setEnabled(true);
        this.setEditable(true);
        this.requestFocus();
        this.selectAll();
        this.getCaret().setVisible(true);
    }

    private void disableEditing() {
        this.setEnabled(false);
        this.setEditable(false);
    }
}

