/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.layers;

import com.jhlabs.composite.ColorBurnComposite;
import com.jhlabs.composite.ColorComposite;
import com.jhlabs.composite.DarkenComposite;
import com.jhlabs.composite.HardLightComposite;
import com.jhlabs.composite.HueComposite;
import com.jhlabs.composite.MultiplyComposite;
import com.jhlabs.composite.OverlayComposite;
import com.jhlabs.composite.SaturationComposite;
import com.jhlabs.composite.ScreenComposite;
import com.jhlabs.composite.SoftLightComposite;
import com.jhlabs.composite.ValueComposite;
import java.awt.AlphaComposite;
import java.awt.Composite;
import org.jdesktop.swingx.graphics.BlendComposite;

public enum BlendingMode {
    NORMAL{

        @Override
        public Composite getComposite(float f) {
            return AlphaComposite.SrcOver.derive(f);
        }

        public String toString() {
            return "Normal";
        }
    }
    ,
    DARKEN{

        @Override
        public Composite getComposite(float f) {
            return new DarkenComposite(f);
        }

        public String toString() {
            return "Darken";
        }
    }
    ,
    MULTIPLY{

        @Override
        public Composite getComposite(float f) {
            return new MultiplyComposite(f);
        }

        public String toString() {
            return "Multiply";
        }
    }
    ,
    COLOR_BURN{

        @Override
        public Composite getComposite(float f) {
            return new ColorBurnComposite(f);
        }

        public String toString() {
            return "Color Burn";
        }
    }
    ,
    LIGHTEN{

        @Override
        public Composite getComposite(float f) {
            return BlendComposite.Lighten;
        }

        public String toString() {
            return "Lighten";
        }
    }
    ,
    SCREEN{

        @Override
        public Composite getComposite(float f) {
            return new ScreenComposite(f);
        }

        public String toString() {
            return "Screen";
        }
    }
    ,
    COLOR_DODGE{

        @Override
        public Composite getComposite(float f) {
            return BlendComposite.ColorDodge;
        }

        public String toString() {
            return "Color Dodge";
        }
    }
    ,
    LINEAR_DODGE{

        @Override
        public Composite getComposite(float f) {
            return BlendComposite.Add;
        }

        public String toString() {
            return "Linear Dodge (Add)";
        }
    }
    ,
    OVERLAY{

        @Override
        public Composite getComposite(float f) {
            return new OverlayComposite(f);
        }

        public String toString() {
            return "Overlay";
        }
    }
    ,
    SOFT_LIGHT{

        @Override
        public Composite getComposite(float f) {
            return new SoftLightComposite(f);
        }

        public String toString() {
            return "Soft Light";
        }
    }
    ,
    HARD_LIGHT{

        @Override
        public Composite getComposite(float f) {
            return new HardLightComposite(f);
        }

        public String toString() {
            return "Hard Light";
        }
    }
    ,
    DIFFERENCE{

        @Override
        public Composite getComposite(float f) {
            return BlendComposite.Difference;
        }

        public String toString() {
            return "Difference";
        }
    }
    ,
    EXCLUSION{

        @Override
        public Composite getComposite(float f) {
            return BlendComposite.Exclusion;
        }

        public String toString() {
            return "Exclusion";
        }
    }
    ,
    HUE{

        @Override
        public Composite getComposite(float f) {
            return new HueComposite(f);
        }

        public String toString() {
            return "Hue";
        }
    }
    ,
    SATURATION{

        @Override
        public Composite getComposite(float f) {
            return new SaturationComposite(f);
        }

        public String toString() {
            return "Saturation";
        }
    }
    ,
    COLOR{

        @Override
        public Composite getComposite(float f) {
            return new ColorComposite(f);
        }

        public String toString() {
            return "Color";
        }
    }
    ,
    LUMINOSITY{

        @Override
        public Composite getComposite(float f) {
            return new ValueComposite(f);
        }

        public String toString() {
            return "Value";
        }
    };


    public abstract Composite getComposite(float var1);
}

