/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.Layer;

public class NewLayerEdit
extends PixelitorEdit {
    private Layer layer;

    public NewLayerEdit(Composition composition, Layer layer) {
        super(composition, "New Layer");
        composition.setDirty(true);
        this.layer = layer;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.comp.removeLayer(this.layer, true);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.comp.addLayer(this.layer, false, true, false);
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        this.layer = null;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

