/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import java.awt.image.BufferedImage;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.FadeableEdit;
import pixelitor.history.History;
import pixelitor.layers.ImageLayer;

public class ImageEdit
extends FadeableEdit {
    private BufferedImage backupImage;
    private ImageLayer layer;
    private boolean canRepeat;

    public ImageEdit(String string, Composition composition, BufferedImage bufferedImage, boolean bl) {
        super(composition, string);
        this.backupImage = bufferedImage;
        this.canRepeat = bl;
        this.layer = (ImageLayer)composition.getActiveLayer();
        composition.setDirty(true);
        this.sanityCheck();
    }

    private void sanityCheck() {
        if (this.layer.getBufferedImage() == this.backupImage) {
            throw new IllegalStateException("backup BufferedImage is identical to the active one");
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.swapImages("ImageEdit UNDO");
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.swapImages("ImageEdit REDO");
    }

    private void swapImages(String string) {
        BufferedImage bufferedImage = this.layer.getImageOrSubImageIfSelected(false, true);
        this.layer.changeImageUndoRedo(this.backupImage);
        this.comp.imageChanged(true, true);
        this.backupImage = bufferedImage;
        History.postEdit(this);
        this.sanityCheck();
    }

    @Override
    public void die() {
        super.die();
        this.backupImage.flush();
        this.backupImage = null;
        this.layer = null;
    }

    @Override
    public BufferedImage getBackupImage() {
        return this.backupImage;
    }

    @Override
    public boolean canRepeat() {
        return this.canRepeat;
    }
}

