/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import java.awt.Shape;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;

public class DeselectEdit
extends PixelitorEdit {
    private Shape backupShape;
    private String reason;

    public DeselectEdit(Composition composition, Shape shape, String string) {
        super(composition, "Deselect");
        this.reason = string;
        if (shape == null) {
            throw new IllegalArgumentException("backupShape is null");
        }
        this.backupShape = shape;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        assert (!this.comp.hasSelection());
        this.comp.createSelectionFromShape(this.backupShape);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.comp.deselect(false);
        History.postEdit(this);
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public String getDebugName() {
        return super.getDebugName() + " (reason = \"" + this.reason + "\")";
    }
}

