/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.history;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pixelitor.Composition;
import pixelitor.history.History;
import pixelitor.history.PixelitorEdit;
import pixelitor.layers.Layer;

public class DeleteLayerEdit
extends PixelitorEdit {
    private Layer layer;
    private int layerIndex;

    public DeleteLayerEdit(Composition composition, Layer layer, int n) {
        super(composition, "Delete Layer");
        composition.setDirty(true);
        this.layer = layer;
        this.layerIndex = n;
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.comp.addLayer(this.layer, false, true, this.layerIndex);
        History.postEdit(this);
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.comp.removeLayer(this.layer, true);
        History.postEdit(this);
    }

    @Override
    public void die() {
        super.die();
        this.layer = null;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }
}

