/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.painters;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import org.jdesktop.swingx.painter.AbstractLayoutPainter;
import org.jdesktop.swingx.painter.TextPainter;
import org.jdesktop.swingx.painter.effects.AreaEffect;
import pixelitor.filters.FilterUtils;
import pixelitor.filters.gui.AdjustPanel;
import pixelitor.filters.gui.FilterWithGUI;
import pixelitor.filters.painters.TextFilterAdjustments;
import pixelitor.tools.FgBgColorSelector;
import pixelitor.utils.ImageUtils;

public class TextFilter
extends FilterWithGUI {
    private String text = "Pixelitor";
    private Font font = new Font("SansSerif", 1, 50);
    private AreaEffect[] areaEffects;
    AbstractLayoutPainter.VerticalAlignment verticalAlignment;
    AbstractLayoutPainter.HorizontalAlignment horizontalAlignment;
    public static final TextFilter INSTANCE = new TextFilter();
    private boolean watermark;

    private TextFilter() {
        super("Text");
        this.copySrcToDstBeforeRunning = true;
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.text.isEmpty()) {
            return FilterUtils.getDefaultImage(bufferedImage);
        }
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        TextPainter textPainter = new TextPainter();
        textPainter.setAntialiasing(true);
        textPainter.setText(this.text);
        textPainter.setFont(this.font);
        textPainter.setAreaEffects(this.areaEffects);
        textPainter.setHorizontalAlignment(this.horizontalAlignment);
        textPainter.setVerticalAlignment(this.verticalAlignment);
        if (this.watermark) {
            BufferedImage bufferedImage3 = new BufferedImage(n, n2, 1);
            Graphics2D graphics2D = bufferedImage3.createGraphics();
            graphics2D.setColor(Color.BLACK);
            graphics2D.fillRect(0, 0, n, n2);
            textPainter.setFillPaint(Color.WHITE);
            textPainter.paint(graphics2D, this, n, n2);
            graphics2D.dispose();
            bufferedImage2 = ImageUtils.bumpMap(bufferedImage, bufferedImage3);
        } else {
            textPainter.setFillPaint(FgBgColorSelector.getFG());
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            textPainter.paint(graphics2D, this, n, n2);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setAreaEffects(AreaEffect[] areaEffectArray) {
        this.areaEffects = areaEffectArray;
    }

    @Override
    public AdjustPanel getAdjustPanel() {
        return new TextFilterAdjustments(this);
    }

    public void setWatermark(boolean bl) {
        this.watermark = bl;
    }

    public void setVerticalAlignment(AbstractLayoutPainter.VerticalAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public void setHorizontalAlignment(AbstractLayoutPainter.HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public void randomizeSettings() {
        Random random = new Random();
        this.text = Long.toHexString(random.nextLong());
    }
}

