/*
 * Decompiled with CFR 0.152.
 */
package pixelitor.filters.lookup;

import java.awt.image.BufferedImage;
import java.awt.image.ShortLookupTable;
import java.util.Random;
import pixelitor.filters.gui.FilterWithGUI;
import pixelitor.filters.levels.GrayScaleLookup;
import pixelitor.filters.levels.RGBLookup;
import pixelitor.filters.lookup.FastLookupOp;

public abstract class DynamicLookupFilter
extends FilterWithGUI {
    private RGBLookup rgbLookup;

    DynamicLookupFilter(String string) {
        super(string);
    }

    public void setRGBLookup(RGBLookup rGBLookup) {
        if (rGBLookup == null) {
            throw new IllegalArgumentException("rgbLookup is null");
        }
        this.rgbLookup = rGBLookup;
    }

    @Override
    public BufferedImage transform(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (this.rgbLookup == null) {
            throw new IllegalStateException("rgbLookup not initialized in DynamicLookupOp");
        }
        FastLookupOp fastLookupOp = new FastLookupOp((ShortLookupTable)this.rgbLookup.getLookupOp());
        fastLookupOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    @Override
    public void randomizeSettings() {
        Random random = new Random();
        int n = random.nextInt(255);
        int n2 = random.nextInt(255);
        int n3 = random.nextInt(255);
        int n4 = random.nextInt(255);
        GrayScaleLookup grayScaleLookup = new GrayScaleLookup(n, n2, n3, n4);
        this.rgbLookup = new RGBLookup(grayScaleLookup, grayScaleLookup, grayScaleLookup, grayScaleLookup, grayScaleLookup, grayScaleLookup, grayScaleLookup);
    }
}

